/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.repository.ActionRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<Action>
implements ActionCrudService {
    @Autowired
    private ActionRepository actionRepository;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(Action.class).add("id").add("moduleSid").add("tenantSid");
    }

    protected BaseEntityRepository getRepository() {
        return this.actionRepository;
    }

    @Override
    public List<Long> getActionSidsByModuleSid(long tenantSid, long moduleSid) {
        if (moduleSid == 0L) {
            throw new IllegalArgumentException("moduleSid is 0");
        }
        return this.actionRepository.findActionSidsByTenantSidAndModuleSid(tenantSid, moduleSid);
    }

    @Override
    public List<Long> getActionSidsByUri(long tenantSid, String uri) {
        return this.actionRepository.findActionSidsByTenantSidAndUri(tenantSid, uri);
    }

    @Override
    public List<Action> getActionsByParentSid(long tenantSid, long parentSid) {
        if (parentSid == 0L) {
            throw new IllegalArgumentException("parentSid is 0");
        }
        return this.actionRepository.findActionsByTenantSidAndParentSid(tenantSid, parentSid);
    }

    @Override
    public Action findByUri(String uri) {
        return this.actionRepository.findByUri(uri);
    }
}

