/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionPath;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.dataplus.ActionModelVO;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.mapper.ActionMapper;
import com.digiwin.dap.middleware.iam.mapper.ConditionMapper;
import com.digiwin.dap.middleware.iam.repository.ActionRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ActionQueryService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActionQueryServiceImpl
implements ActionQueryService {
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ActionMapper actionMapper;
    @Autowired
    private ConditionMapper conditionMapper;
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private SysValidateService sysValidateService;

    @Override
    public ActionPath getActionPath(long sid) {
        if (sid == 0L) {
            throw new IllegalArgumentException("sid is 0");
        }
        ActionPath actionPath = new ActionPath();
        Action action = (Action)this.actionCrudService.findBySid(sid);
        if (action == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST, new Object[]{sid});
        }
        Module module = (Module)this.moduleCrudService.findBySid(action.getModuleSid());
        if (module == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{action.getModuleSid()});
        }
        Sys sys = (Sys)this.sysCrudService.findBySid(module.getAppSid());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{module.getAppSid()});
        }
        StringBuffer urnBuffer = new StringBuffer();
        urnBuffer.append(action.getName());
        StringBuffer uriBuffer = new StringBuffer();
        uriBuffer.append(action.getId());
        if (action.getParentSid() != 0L) {
            this.buildParentAction(action.getParentSid(), urnBuffer, uriBuffer);
        }
        uriBuffer.insert(0, "drn:iam:app:" + sys.getId() + ":" + module.getId() + ":");
        urnBuffer.insert(0, sys.getName() + ":" + module.getName() + ":");
        actionPath.setActionUri(uriBuffer.toString());
        actionPath.setActionUrn(urnBuffer.toString());
        return actionPath;
    }

    @Override
    public ActionQueryResultVO getAction(long tenantSid, long appSid, long moduleSid, long actionSid) {
        this.sysValidateService.check5(appSid, moduleSid, actionSid);
        ActionQueryResultVO actionQueryResultVO = this.actionMapper.findActionQueryResultVO(tenantSid, appSid, moduleSid, actionSid);
        if (Objects.isNull(actionQueryResultVO)) {
            return null;
        }
        if (actionQueryResultVO.getParentId() == null) {
            actionQueryResultVO.setParentId("[empty]");
        }
        List<ConditionQueryResultVO> conditionQueryResultVOs = this.conditionMapper.findConditionByActionSid(actionSid);
        for (ConditionQueryResultVO conditionQueryResultVO : conditionQueryResultVOs) {
            String typeParameter = conditionQueryResultVO.getParameter();
            conditionQueryResultVO.setTypeParameter((List)JsonUtils.jsonToObj((String)typeParameter, List.class));
        }
        actionQueryResultVO.setCondition(conditionQueryResultVOs);
        return actionQueryResultVO;
    }

    @Override
    public Map<String, Object> getActionCascade(long tenantSid, long appSid, long moduleSid, long actionSid) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ActionQueryResultVO actionQueryResultVO = this.getAction(tenantSid, appSid, moduleSid, actionSid);
        map.put("target", actionQueryResultVO);
        List<Long> actionSids = this.actionRepository.findActionSidsByTenantSidAndParentSid(tenantSid, actionSid);
        if (actionSids.size() > 0) {
            ArrayList<ActionQueryResultVO> actionQueryResultVOS = new ArrayList<ActionQueryResultVO>();
            for (Long sid : actionSids) {
                ActionQueryResultVO childrenActionQueryResultVO = this.getAction(tenantSid, appSid, moduleSid, sid);
                actionQueryResultVOS.add(childrenActionQueryResultVO);
            }
            map.put("children", actionQueryResultVOS);
        }
        return map;
    }

    @Override
    public List<String> getActionIdBySysIds(String appId, List<String> moduleIds) {
        if (moduleIds.isEmpty()) {
            return Collections.emptyList();
        }
        return this.actionMapper.findActionIdBySysIdAndModuleIds(appId, moduleIds);
    }

    private void buildParentAction(long sid, StringBuffer urnBuffer, StringBuffer uriBuffer) {
        Action action;
        if (sid != 0L && (action = (Action)this.actionCrudService.findBySid(sid)) != null) {
            urnBuffer.insert(0, action.getName() + ":");
            uriBuffer.insert(0, action.getId() + ":");
            long parentSid = action.getParentSid();
            this.buildParentAction(parentSid, urnBuffer, uriBuffer);
        }
    }

    @Override
    public List<ActionQueryResultVO> getPublicAction(String appId) {
        List<ActionQueryResultVO> actionQueryResultVO = this.actionMapper.findPublicActionQueryResultVO(appId);
        actionQueryResultVO.forEach(action -> {
            if (action.getPath() != null) {
                action.setPaths(Arrays.asList(action.getPath().split(",")));
            }
        });
        return actionQueryResultVO;
    }

    @Override
    public List<ActionModelVO> findModelAction(long tenantSid, List<String> modelIds, List<String> paths) {
        if (!CollectionUtils.isEmpty(modelIds)) {
            return this.actionMapper.findByModelIds(tenantSid, modelIds);
        }
        if (!CollectionUtils.isEmpty(paths)) {
            List<ActionModelVO> actions = this.actionMapper.findPathNotNull(tenantSid);
            return actions.stream().filter(action -> {
                ArrayList<String> intersection = new ArrayList<String>(paths);
                intersection.retainAll(Arrays.asList(action.getPath().split(",")));
                action.setPaths(intersection);
                return !action.getPaths().isEmpty();
            }).collect(Collectors.toList());
        }
        List<ActionModelVO> actions = this.actionMapper.findModelIdOrPathNotNull(tenantSid);
        actions.forEach(action -> action.setPaths(action.getPath() == null ? new ArrayList<String>() : Arrays.asList(action.getPath().split(","))));
        return actions;
    }
}

