/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ActionTenantVO;
import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ConditionVO;
import com.digiwin.dap.middleware.iam.domain.app.TenantActionFilterable;
import com.digiwin.dap.middleware.iam.domain.request.BatchDelActionsRequest;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.Condition;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.ConditionMapper;
import com.digiwin.dap.middleware.iam.repository.ActionRepository;
import com.digiwin.dap.middleware.iam.repository.ConditionRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ActionService;
import com.digiwin.dap.middleware.iam.service.app.ActionTenantCrudService;
import com.digiwin.dap.middleware.iam.service.app.ConditionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ConditionService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.remote.domain.MultiLanguageSysDetailVO;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import com.digiwin.dap.middleware.language.entity.LanguageResource;
import com.digiwin.dap.middleware.language.service.LanguageCrudService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActionServiceImpl
implements ActionService {
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionRepository actionRepository;
    @Autowired
    private ConditionCrudService conditionCrudService;
    @Autowired
    private ConditionRepository conditionRepository;
    @Autowired
    private ConditionService conditionService;
    @Autowired
    private ConditionMapper conditionMapper;
    @Autowired(required=false)
    private RamService ramService;
    @Autowired
    private SysValidateService sysValidateService;
    @Autowired
    private LanguageCrudService languageCrudService;
    @Autowired
    private ActionTenantCrudService actionTenantCrudService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private TenantCrudService tenantCrudService;

    @Override
    @Transactional
    public Action saveAction(ActionVO actionVO, boolean updateCondition) {
        this.sysValidateService.check7(actionVO);
        long actionSid = this.sysValidateService.check9(actionVO);
        Action action = actionSid == 0L ? this.addAction(actionVO) : this.modifyAction(actionVO);
        if (updateCondition) {
            this.addActionCondition(actionVO);
        }
        this.actionTenantCrudService.saveTenantAction(actionVO);
        return action;
    }

    private Action addAction(ActionVO actionVO) {
        String uri;
        Action oldAction = (Action)this.actionCrudService.findByUnionKey(new Object[]{actionVO.getId(), actionVO.getModuleSid(), actionVO.getTenantSid()});
        if (oldAction != null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_HAS_EXIST, new Object[]{actionVO.getId()});
        }
        if (actionVO.getParentSid() > 0L) {
            Action parent = (Action)this.actionCrudService.findBySid(actionVO.getParentSid());
            uri = parent.getUri() + ":" + actionVO.getId();
        } else {
            uri = "drn:iam:app:" + actionVO.getAppId() + ":" + actionVO.getModuleId() + ":" + actionVO.getId();
        }
        Action action = new Action();
        action.setId(actionVO.getId());
        action.setName(actionVO.getName());
        action.setParentSid(actionVO.getParentSid());
        action.setModuleSid(actionVO.getModuleSid());
        action.setUri(uri);
        action.setRemarks(actionVO.getRemarks());
        action.setModelId(actionVO.getModelId());
        action.setType(actionVO.getType());
        action.setPath(actionVO.getPath());
        action.setTenantSid(actionVO.getTenantSid());
        action.setRegardlessAuth(actionVO.getRegardlessAuth());
        actionVO.setSid(this.actionCrudService.create(action));
        if (!CollectionUtils.isEmpty(actionVO.getMultiLanguageActions())) {
            ArrayList languageResources = new ArrayList();
            actionVO.getMultiLanguageActions().forEach(a -> {
                LanguageResource languageResource = new LanguageResource(action.getSid(), "actionName", a.getName(), a.getLanguage());
                if (languageResources.stream().noneMatch(r -> r.getLanguage().equals(languageResource.getLanguage()) && r.getDataSid() == languageResource.getDataSid())) {
                    languageResources.add(languageResource);
                }
            });
            this.languageCrudService.saveAll(languageResources);
        }
        return action;
    }

    private void addActionCondition(ActionVO actionVO) {
        List<Long> conditionSids = this.conditionRepository.findConditionSidsByActionSid(actionVO.getSid());
        if (!conditionSids.isEmpty()) {
            this.conditionRepository.batchDelete(conditionSids);
        }
        for (ConditionVO conditionVO : actionVO.getCondition()) {
            Condition oldCondition = (Condition)this.conditionCrudService.findByUnionKey(new Object[]{conditionVO.getKey(), actionVO.getSid()});
            conditionVO.setAppSid(actionVO.getAppSid());
            conditionVO.setModuleSid(actionVO.getModuleSid());
            conditionVO.setActionSid(actionVO.getSid());
            if (oldCondition == null) {
                this.conditionService.addCondition(conditionVO);
                continue;
            }
            this.conditionService.modifyCondition(conditionVO);
        }
    }

    private Action modifyAction(ActionVO actionVO) {
        Action action = (Action)this.actionCrudService.findBySid(actionVO.getSid());
        if (action == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST, new Object[]{actionVO.getId()});
        }
        if (actionVO.getParentSid() > 0L) {
            Action parentAction = (Action)this.actionCrudService.findBySid(actionVO.getParentSid());
            action.setParentSid(parentAction.getSid());
            action.setUri(parentAction.getUri() + ":" + actionVO.getId());
        }
        if (actionVO.getName() != null) {
            action.setName(actionVO.getName());
        }
        if (actionVO.getRemarks() != null) {
            action.setRemarks(actionVO.getRemarks());
        }
        if (actionVO.getModelId() != null) {
            action.setModelId(actionVO.getModelId());
        }
        if (actionVO.getType() != null) {
            action.setType(actionVO.getType());
        }
        if (actionVO.getPath() != null) {
            action.setPath(actionVO.getPath());
        }
        action.setRegardlessAuth(actionVO.getRegardlessAuth());
        action.setDeleted(false);
        this.actionCrudService.update(action);
        if (!CollectionUtils.isEmpty(actionVO.getMultiLanguageActions())) {
            ArrayList languageResources = new ArrayList();
            List existed = this.languageCrudService.findByDataSid(action.getSid());
            actionVO.getMultiLanguageActions().forEach(a -> {
                LanguageResource languageResource = existed.stream().filter(e -> e.getLanguage().equals(a.getLanguage())).findFirst().orElse(null);
                if (languageResource == null) {
                    languageResource = new LanguageResource(action.getSid(), "actionName", a.getName(), a.getLanguage());
                } else {
                    languageResource.setContent(a.getName());
                }
                if (languageResources.stream().noneMatch(r -> r.getLanguage().equals(a.getLanguage()) && r.getDataSid() == action.getSid())) {
                    languageResources.add(languageResource);
                }
            });
            this.languageCrudService.saveAll(languageResources);
        }
        return action;
    }

    @Override
    @Transactional
    public void disAction(long tenantSid, long actionSid) {
        List<Action> actions = this.actionCrudService.getActionsByParentSid(tenantSid, actionSid);
        if (!actions.isEmpty()) {
            throw new BusinessException("\u6b64\u884c\u4e3a\uff1a" + actionSid + "\u5b58\u5728\u5b50\u884c\u4e3a");
        }
        this.actionCrudService.disable(actionSid);
    }

    @Override
    @Transactional
    public void forceDisAction(long tenantSid, long actionSid) {
        this.actionCrudService.disable(actionSid);
        List<Long> actionSids = this.actionRepository.findActionSidsByTenantSidAndParentSid(tenantSid, actionSid);
        actionSids.add(actionSid);
        this.actionRepository.batchDisable(actionSids);
        this.conditionService.disConditionByActionSids(actionSids);
    }

    @Override
    @Transactional
    public List<LanguageResource> batchAddActionWithLanguage(ActionVO actionVO, List<MultiLanguageSysDetailVO> multiLanguageSysDetailVOS, List<ConditionQueryResultVO> oldConditions) {
        ArrayList<LanguageResource> resources = new ArrayList<LanguageResource>();
        this.sysValidateService.check7(actionVO);
        Action oldAction = this.saveAction(actionVO, false);
        this.ramService.createRouteWithPolicy(actionVO.getAppId(), oldAction.getUri(), oldAction.getName(), actionVO.getApis());
        List<ConditionVO> conditionVOS = actionVO.getCondition();
        if (!conditionVOS.isEmpty()) {
            this.updateConditions(conditionVOS, oldAction.getUri(), actionVO, multiLanguageSysDetailVOS, resources, oldConditions);
        } else {
            List<Long> deleteConditionSids = oldConditions.stream().filter(c -> c.getExisted() == null || c.getExisted() == false).map(ConditionQueryResultVO::getSid).collect(Collectors.toList());
            if (!deleteConditionSids.isEmpty()) {
                this.conditionMapper.deleteCondition(deleteConditionSids);
            }
        }
        multiLanguageSysDetailVOS.forEach(multiLanguageSysDetailVO -> {
            if (multiLanguageSysDetailVO.getSysCascadeVO() == null || multiLanguageSysDetailVO.getSysCascadeVO().getActions() == null) {
                return;
            }
            multiLanguageSysDetailVO.getSysCascadeVO().getActions().forEach(actionVO1 -> {
                if (actionVO1.getId().equals(actionVO.getId()) && actionVO.getModuleId().equals(actionVO1.getModuleId())) {
                    LanguageResource multiLanguageResource = new LanguageResource(oldAction.getSid(), "actionName", actionVO1.getName(), multiLanguageSysDetailVO.getLanguage());
                    resources.add(multiLanguageResource);
                }
            });
        });
        return resources;
    }

    private void updateConditions(List<ConditionVO> conditionVOS, String policyKeyPrefix, ActionVO actionVO, List<MultiLanguageSysDetailVO> multiLanguageSysDetailVOS, List<LanguageResource> resources, List<ConditionQueryResultVO> oldConditions) {
        List actionOldConditions = oldConditions.stream().filter(c -> c.getActionSid() == actionVO.getSid()).collect(Collectors.toList());
        for (ConditionVO conditionVO : conditionVOS) {
            Long conditionSid;
            Condition oldCondition = (Condition)this.conditionCrudService.findByUnionKey(new Object[]{conditionVO.getKey(), actionVO.getSid()});
            conditionVO.setAppSid(actionVO.getAppSid());
            conditionVO.setActionSid(actionVO.getSid());
            conditionVO.setModuleSid(actionVO.getModuleSid());
            if (oldCondition == null) {
                conditionSid = this.conditionService.addCondition(conditionVO);
            } else {
                conditionSid = oldCondition.getSid();
                this.conditionService.modifyCondition(conditionVO);
            }
            multiLanguageSysDetailVOS.forEach(multiLanguageSysDetailVO -> {
                if (multiLanguageSysDetailVO.getSysCascadeVO() == null || multiLanguageSysDetailVO.getSysCascadeVO().getActions() == null) {
                    return;
                }
                multiLanguageSysDetailVO.getSysCascadeVO().getActions().forEach(actionVO1 -> {
                    if (actionVO1.getId().equals(actionVO.getId()) && actionVO.getModuleId().equals(actionVO1.getModuleId())) {
                        actionVO1.getCondition().forEach(conditionVO1 -> {
                            if (conditionVO1.getKey().equals(conditionVO.getKey())) {
                                LanguageResource multiLanguageResource = new LanguageResource(conditionSid.longValue(), "conditionName", conditionVO1.getName(), multiLanguageSysDetailVO.getLanguage());
                                resources.add(multiLanguageResource);
                            }
                        });
                    }
                });
            });
            ConditionQueryResultVO oldConditionVO = actionOldConditions.stream().filter(oc -> oc.getKey().equals(conditionVO.getKey())).findFirst().orElse(null);
            if (null != oldConditionVO) {
                oldConditionVO.setExisted(true);
            }
            this.ramService.createRouteWithPolicy(actionVO.getAppId(), String.format("%s:%s", policyKeyPrefix, conditionVO.getKey()), conditionVO.getName(), conditionVO.getApis());
        }
        List<Long> deleteConditionSids = actionOldConditions.stream().filter(c -> null == c.getExisted() || false == c.getExisted()).map(ConditionQueryResultVO::getSid).collect(Collectors.toList());
        if (!deleteConditionSids.isEmpty()) {
            this.conditionMapper.deleteCondition(deleteConditionSids);
        }
    }

    @Override
    public void deleteAction(ActionQueryResultVO actionQueryResultVO) {
        Assert.notNull((Object)actionQueryResultVO, (String)"\u884c\u4e3a\u4e0d\u80fd\u4e3anull");
        Action oldAction = (Action)this.actionCrudService.findBySid(actionQueryResultVO.getSid());
        Assert.notNull((Object)((Object)oldAction), (String)String.format("\u6ca1\u6709\u6b64\u884c\u4e3a%s", actionQueryResultVO.getSid()));
        oldAction.setDeleted(true);
        this.actionCrudService.update(oldAction);
    }

    @Override
    public Long getAction(ActionVO actionVO) {
        Long sysSid = actionVO.getAppSid();
        if (0L == sysSid && !StringUtils.isEmpty((Object)actionVO.getAppId())) {
            sysSid = this.sysCrudService.getSidById(actionVO.getAppId());
        }
        if (Objects.isNull(sysSid) || sysSid == 0L) {
            throw new BusinessException("appSid is null");
        }
        Long moduleSid = actionVO.getModuleSid();
        if (0L == moduleSid && !StringUtils.isEmpty((Object)actionVO.getModuleId())) {
            moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{actionVO.getModuleId(), sysSid});
        }
        if (Objects.isNull(moduleSid) || moduleSid == 0L) {
            throw new BusinessException("module is null");
        }
        Long actionSid = actionVO.getSid();
        if (0L == actionSid && !StringUtils.isEmpty((Object)actionVO.getId())) {
            actionSid = this.actionCrudService.getSidByUnionKey(new Object[]{actionVO.getId(), moduleSid, 0});
        }
        if (Objects.isNull(actionSid) || actionSid == 0L) {
            throw new BusinessException("action is null");
        }
        return actionSid;
    }

    @Override
    public void filterByTenantActionRelation(long sysSid, List<? extends TenantActionFilterable> actions, long tenantSid) {
        if (actions.isEmpty()) {
            return;
        }
        List<ActionTenantVO> actionTenants = this.commonCacheService.getActionTenant(sysSid);
        if (actionTenants.isEmpty()) {
            return;
        }
        Map<Long, List<ActionTenantVO>> actionTenantMap = actionTenants.stream().collect(Collectors.groupingBy(ActionTenantVO::getActionSid));
        actions.removeIf(a -> actionTenantMap.containsKey(a.getActionSid()) && ((List)actionTenantMap.get(a.getActionSid())).stream().noneMatch(b -> b.getTenantSid() == tenantSid));
    }

    @Override
    @Transactional
    @NotNull
    public List<Long> deleteTenantAction(long sysSid, long sid, long tenantSid) {
        Action action = (Action)this.actionCrudService.findBySid(sid);
        if (action == null || action.getTenantSid() != tenantSid) {
            return Collections.emptyList();
        }
        List<Action> actionList = this.actionRepository.findActionByTenantSidAndUriLike(tenantSid, action.getUri() + ":%");
        List<Long> sids = Stream.concat(Stream.of(Long.valueOf(action.getSid())), actionList.stream().map(BaseEntity::getSid)).collect(Collectors.toList());
        this.conditionRepository.deleteByActionSidIn(sids);
        this.actionTenantCrudService.deleteByActionSidIn(sysSid, sids);
        this.actionRepository.deleteAllById(sids);
        return sids;
    }

    @Override
    @Transactional
    public List<Long> deleteActionBatch(long sysSid, List<BatchDelActionsRequest.Action> actions) {
        HashMap<String, Long> tenantMap = new HashMap<String, Long>();
        HashMap<String, Long> moduleMap = new HashMap<String, Long>();
        for (BatchDelActionsRequest.Action action : actions) {
            if (!moduleMap.containsKey(action.getModuleId())) {
                Module module = this.moduleCrudService.findByAppSidAndId(sysSid, action.getModuleId());
                moduleMap.put(action.getModuleId(), module == null ? 0L : module.getSid());
            }
            if (action.getSelf().booleanValue()) {
                if (!tenantMap.containsKey(action.getTenantId())) {
                    Tenant tenant = (Tenant)this.tenantCrudService.findById(action.getTenantId());
                    tenantMap.put(action.getTenantId(), tenant == null ? -1L : tenant.getSid());
                }
                this.actionCrudService.deleteByUnionKey(new Object[]{action.getActionId(), moduleMap.get(action.getModuleId()), tenantMap.get(action.getTenantId())});
                continue;
            }
            this.actionCrudService.deleteByUnionKey(new Object[]{action.getActionId(), moduleMap.get(action.getModuleId()), 0L});
        }
        return new ArrayList<Long>(tenantMap.values());
    }
}

