/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.entity.ActionTenant;
import com.digiwin.dap.middleware.iam.repository.ActionTenantRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionTenantCrudService;
import com.digiwin.dap.middleware.iam.support.clean.ActionTenantCacheDeleteService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ActionTenantCrudServiceImpl
extends BaseEntityManagerService<ActionTenant>
implements ActionTenantCrudService {
    @Autowired
    private ActionTenantRepository actionTenantRepository;
    @Autowired
    private ActionTenantCacheDeleteService actionTenantCacheDeleteService;

    protected ActionTenantRepository getRepository() {
        return this.actionTenantRepository;
    }

    @Override
    public void saveTenantAction(ActionVO actionVO) {
        ActionTenant exist;
        if (actionVO.getSeparateTenantSid() > 0L && (exist = this.actionTenantRepository.findByActionSidAndTenantSid(actionVO.getSid(), actionVO.getSeparateTenantSid())) == null) {
            ActionTenant actionTenant = new ActionTenant();
            actionTenant.setSysSid(actionVO.getAppSid());
            actionTenant.setActionSid(actionVO.getSid());
            actionTenant.setTenantSid(actionVO.getSeparateTenantSid());
            this.create(actionTenant);
            this.actionTenantCacheDeleteService.deleteBySysSid(actionVO.getAppSid());
        }
    }

    @Override
    public void deleteByActionSidIn(long sysSid, List<Long> actionSids) {
        this.actionTenantRepository.deleteBySysSidAndActionSidIn(sysSid, actionSids);
        this.actionTenantCacheDeleteService.deleteBySysSid(sysSid);
    }

    @Override
    public void deleteBySysSid(long sysSid) {
        this.actionTenantRepository.deleteBySysSid(sysSid);
        this.actionTenantCacheDeleteService.deleteBySysSid(sysSid);
    }
}

