/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ConditionVO;
import com.digiwin.dap.middleware.iam.entity.Condition;
import com.digiwin.dap.middleware.iam.repository.ConditionRepository;
import com.digiwin.dap.middleware.iam.service.app.ConditionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ConditionService;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ConditionServiceImpl
implements ConditionService {
    @Autowired
    private ConditionCrudService conditionCrudService;
    @Autowired
    private ConditionRepository conditionRepository;
    @Autowired
    private SysValidateService sysValidateService;

    @Override
    public long addCondition(ConditionVO conditionVO) {
        this.sysValidateService.check6(conditionVO);
        Condition oldCondition = (Condition)this.conditionCrudService.findByUnionKey(new Object[]{conditionVO.getKey(), conditionVO.getActionSid()});
        if (oldCondition != null) {
            throw new BusinessException((ErrorHandler)I18nError.CONDITION_HAS_EXIST, new Object[]{conditionVO.getKey()});
        }
        Condition condition = new Condition();
        condition.setKey(conditionVO.getKey());
        condition.setName(conditionVO.getName());
        condition.setType(conditionVO.getType());
        condition.setTypeParameter(JsonUtils.objToJson(conditionVO.getTypeParameter()));
        if (conditionVO.getTypeParameter().isEmpty() && StringUtils.hasText((String)conditionVO.getParameter())) {
            condition.setTypeParameter(conditionVO.getParameter());
        }
        condition.setDefaultValue(conditionVO.getDefaultValue());
        condition.setActionSid(conditionVO.getActionSid());
        return this.conditionCrudService.create(condition);
    }

    @Override
    public void modifyCondition(ConditionVO conditionVO) {
        this.sysValidateService.check6(conditionVO);
        Condition condition = (Condition)this.conditionCrudService.findByUnionKey(new Object[]{conditionVO.getKey(), conditionVO.getActionSid()});
        if (condition == null) {
            throw new BusinessException((ErrorHandler)I18nError.CONDITION_NOT_EXIST, new Object[]{conditionVO.getKey()});
        }
        condition.setName(conditionVO.getName());
        condition.setType(conditionVO.getType());
        condition.setDeleted(false);
        condition.setTypeParameter(JsonUtils.objToJson(conditionVO.getTypeParameter()));
        if (conditionVO.getTypeParameter().isEmpty() && StringUtils.hasText((String)conditionVO.getParameter())) {
            condition.setTypeParameter(conditionVO.getParameter());
        }
        condition.setDefaultValue(conditionVO.getDefaultValue());
        this.conditionCrudService.update(condition);
    }

    @Override
    public void disConditionByActionSids(List<Long> actionSids) {
        ArrayList<Long> conditionSidList = new ArrayList<Long>();
        for (Long actionSid : actionSids) {
            List<Long> conditionSids = this.conditionRepository.findConditionSidsByActionSid(actionSid);
            conditionSidList.addAll(conditionSids);
        }
        if (conditionSidList.size() > 0) {
            this.conditionRepository.batchDisable(conditionSidList);
        }
    }
}

