/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ModuleQueryResultVO;
import com.digiwin.dap.middleware.iam.mapper.ModuleMapper;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ActionQueryService;
import com.digiwin.dap.middleware.iam.service.app.ModuleQueryService;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleQueryServiceImpl
implements ModuleQueryService {
    @Autowired
    private ModuleMapper moduleMapper;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ActionQueryService actionQueryService;
    @Autowired
    private SysValidateService sysValidateService;

    @Override
    public ModuleQueryResultVO getModuleCascade(long tenantSid, long appSid, long moduleSid) {
        ActionQueryResultVO actionQueryResultVO;
        this.sysValidateService.check2(appSid, moduleSid);
        ModuleQueryResultVO moduleQueryResultVO = this.getModuleBySysSidAndModuleSid(appSid, moduleSid);
        List<Long> actionSids = this.actionCrudService.getActionSidsByModuleSid(tenantSid, moduleSid);
        ArrayList<ActionQueryResultVO> actionQueryResultVOS = new ArrayList<ActionQueryResultVO>();
        for (Long actionSid : actionSids) {
            actionQueryResultVO = this.actionQueryService.getAction(tenantSid, appSid, moduleSid, actionSid);
            actionQueryResultVOS.add(actionQueryResultVO);
        }
        if (tenantSid > 0L) {
            actionSids = this.actionCrudService.getActionSidsByModuleSid(0L, moduleSid);
            for (Long actionSid : actionSids) {
                actionQueryResultVO = this.actionQueryService.getAction(tenantSid, appSid, moduleSid, actionSid);
                actionQueryResultVOS.add(actionQueryResultVO);
            }
        }
        moduleQueryResultVO.setActions(actionQueryResultVOS);
        return moduleQueryResultVO;
    }

    @Override
    public List<ModuleQueryResultVO> getModuleVOSBySid(long sysSid) {
        this.sysValidateService.check3(sysSid);
        return this.moduleMapper.findModuleBySysSid(sysSid);
    }

    @Override
    public ModuleQueryResultVO getModuleBySysSidAndModuleSid(long sysSid, long moduleSid) {
        this.sysValidateService.check4(sysSid, moduleSid);
        return this.moduleMapper.findBySysSidAndModuleSid(sysSid, moduleSid);
    }
}

