/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ModuleVO;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.validate.SysValidateService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ModuleServiceImpl
implements ModuleService {
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private SysValidateService sysValidateService;

    @Override
    public long addModule(ModuleVO moduleVO) {
        this.sysValidateService.check(moduleVO);
        Module oldModule = (Module)this.moduleCrudService.findByUnionKey(new Object[]{moduleVO.getId(), moduleVO.getAppSid()});
        if (oldModule != null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_HAS_EXIST, new Object[]{moduleVO.getId()});
        }
        Sys sys = (Sys)this.sysCrudService.findBySid(moduleVO.getAppSid());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{moduleVO.getAppSid()});
        }
        Module module = new Module();
        module.setId(moduleVO.getId());
        module.setAppSid(sys.getSid());
        module.setName(moduleVO.getName());
        module.setRemarks(moduleVO.getRemarks());
        return this.moduleCrudService.create(module);
    }

    @Override
    public void modifyModule(ModuleVO moduleVO) {
        this.sysValidateService.check(moduleVO);
        Module module = (Module)this.moduleCrudService.findByUnionKey(new Object[]{moduleVO.getId(), moduleVO.getAppSid()});
        if (module == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{moduleVO.getSid()});
        }
        module.setName(moduleVO.getName());
        module.setRemarks(moduleVO.getRemarks());
        this.moduleCrudService.update(module);
    }

    @Override
    public void disModule(long tenantSid, long appSid, long moduleSid) {
        List<Long> actions = this.actionCrudService.getActionSidsByModuleSid(tenantSid, moduleSid);
        if (actions.size() > 0) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_HAS_EXIST_ACTION, new Object[]{moduleSid});
        }
        this.moduleCrudService.disable(moduleSid);
    }
}

