/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.app.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.domain.app.RelocateActionVO;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnOrg;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnRole;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnUser;
import com.digiwin.dap.middleware.iam.entity.DataStatement;
import com.digiwin.dap.middleware.iam.entity.Module;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.PolicyConditionValue;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnOrgRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnRoleRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyOnUserRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicyRepository;
import com.digiwin.dap.middleware.iam.repository.DataStatementRepository;
import com.digiwin.dap.middleware.iam.repository.PolicyRepository;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.clean.RefreshCacheService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class RelocateActionService {
    private static final Logger logger = LoggerFactory.getLogger(RelocateActionService.class);
    @Resource
    private SysCrudService sysCrudService;
    @Resource
    private ModuleCrudService moduleCrudService;
    @Resource
    private ActionCrudService actionCrudService;
    @Resource
    private PolicyCrudService policyCrudService;
    @Resource
    private PolicyRepository policyRepository;
    @Resource
    private DataPolicyRepository dataPolicyRepository;
    @Resource
    private RefreshCacheService refreshCacheService;
    @Resource
    private PolicyConditionValueCrudService policyConditionValueCrudService;
    @Resource
    private DataPolicyOnOrgRepository dataPolicyOnOrgRepository;
    @Resource
    private DataPolicyOnRoleRepository dataPolicyOnRoleRepository;
    @Resource
    private DataPolicyOnUserRepository dataPolicyOnUserRepository;
    @Resource
    private DataStatementRepository dataStatementRepository;

    public void relocateAction(RelocateActionVO request) {
        logger.info("\u3010relocateAction\u3011 start");
        List<ActionVO> sources = request.getSource();
        ActionVO destination = request.getDestination();
        this.checkExistence(destination);
        sources.forEach(this::checkExistence);
        Sys destSys = (Sys)this.sysCrudService.findById(destination.getAppId());
        Module destModule = (Module)this.moduleCrudService.findByUnionKey(new Object[]{destination.getModuleId(), destSys.getSid()});
        sources.forEach(source -> this.doRelocateAction(destSys, destModule, (ActionVO)source));
        this.refreshCacheService.deletePermissionBySys(destSys.getId());
        logger.info("\u3010relocateAction\u3011 end");
    }

    private void doRelocateAction(Sys destSys, Module destModule, ActionVO source) {
        Sys sourceSys = (Sys)this.sysCrudService.findById(source.getAppId());
        Module sourceModule = (Module)this.moduleCrudService.findByUnionKey(new Object[]{source.getModuleId(), sourceSys.getSid()});
        Action sourceAction = (Action)this.actionCrudService.findByUnionKey(new Object[]{source.getId(), sourceModule.getSid(), 0});
        logger.info("\u3010relocateAction\u3011 sys:{},module:{},action:{}", new Object[]{sourceSys.getSid(), sourceModule.getSid(), sourceAction.getSid()});
        logger.info("\u3010relocateAction\u3011 \u539f\u6a21\u7ec4sid:{},\u65b0\u6a21\u7ec4sid:{}", (Object)sourceAction.getModuleSid(), (Object)destModule.getSid());
        sourceAction.setModuleSid(destModule.getSid());
        String newUri = String.format("drn:iam:app:%s:%s:%s", destSys.getId(), destModule.getId(), sourceAction.getId());
        logger.info("\u3010relocateAction\u3011 \u539furi:{},\u65b0uri:{}", (Object)sourceAction.getUri(), (Object)newUri);
        sourceAction.setUri(newUri);
        this.actionCrudService.update(sourceAction);
        logger.info("\u3010relocateAction\u3011 destModule:sid:{}", (Object)destModule.getSid());
        List<Policy> sourcePolicies = this.policyRepository.findBySysSid(sourceSys.getSid());
        List<Policy> destPolicies = this.policyRepository.findBySysSid(destSys.getSid());
        ArrayList<Policy> changedPolicies = new ArrayList<Policy>();
        for (Policy policy : sourcePolicies) {
            Policy newPolicy;
            String newPolicyId = policy.getId().replace(sourceSys.getId(), destSys.getId());
            Optional<Policy> optionalPolicy = destPolicies.stream().filter(p -> p.getId().equals(newPolicyId)).findFirst();
            if (optionalPolicy.isPresent()) {
                newPolicy = optionalPolicy.get();
            } else {
                newPolicy = new Policy();
                BeanUtils.copyProperties((Object)((Object)policy), (Object)((Object)newPolicy));
                newPolicy.setSid(SnowFlake.getInstance().newId());
                newPolicy.setId(newPolicyId);
                newPolicy.setName(newPolicyId);
                newPolicy.setSysSid(destSys.getSid());
                EntityUtils.setCreateFields((BaseEntity)newPolicy);
            }
            EntityUtils.setModifyFields((BaseEntity)newPolicy);
            logger.info("\u3010relocateAction\u3011 policy added:sid:{}", (Object)newPolicy.getSid());
            changedPolicies.add(newPolicy);
            Map<Long, Integer> statement = StatementInfo.getStatementType(policy.getStatementValue());
            Map<Long, Integer> newStatement = StatementInfo.getStatementType(newPolicy.getStatementValue());
            long sourceModuleSid = sourceModule.getSid();
            long sourceActionSid = sourceAction.getSid();
            if (statement.containsKey(sourceModuleSid)) {
                newStatement.put(destModule.getSid(), statement.get(sourceModuleSid));
            }
            if (statement.containsKey(sourceActionSid)) {
                newStatement.put(sourceActionSid, statement.get(sourceModuleSid));
            }
            newPolicy.setStatementValue(StatementInfo.getStatementValue(newStatement));
            List<PolicyConditionValue> byPolicySid = this.policyConditionValueCrudService.findByPolicySid(policy.getSid());
            for (PolicyConditionValue a2 : byPolicySid) {
                logger.info("\u3010relocateAction\u3011 PolicyConditionValue setPolicySid,old:{},new:{}", (Object)a2.getPolicySid(), (Object)newPolicy.getSid());
                a2.setPolicySid(newPolicy.getSid());
            }
            this.policyConditionValueCrudService.saveAll(byPolicySid);
        }
        this.policyCrudService.saveAll(changedPolicies);
        List<DataPolicy> dataPolicies = this.dataPolicyRepository.findBySysSid(sourceSys.getSid());
        List<DataPolicy> destDataPolicies = this.dataPolicyRepository.findBySysSid(destSys.getSid());
        for (DataPolicy dataPolicy : dataPolicies) {
            DataPolicy newDataPolicy;
            Optional<DataPolicy> optionalDataPolicy = destDataPolicies.stream().filter(a -> a.getTenantSid() == dataPolicy.getTenantSid()).findFirst();
            if (optionalDataPolicy.isPresent()) {
                newDataPolicy = optionalDataPolicy.get();
            } else {
                newDataPolicy = new DataPolicy();
                BeanUtils.copyProperties((Object)((Object)dataPolicy), (Object)((Object)newDataPolicy));
                newDataPolicy.setSid(SnowFlake.getInstance().newId());
                newDataPolicy.setId(UUID.randomUUID().toString());
                newDataPolicy.setSysSid(destSys.getSid());
                logger.info("\u3010relocateAction\u3011 DataPolicy add,sid:{}", (Object)newDataPolicy.getSid());
                this.dataPolicyRepository.save((Object)newDataPolicy);
            }
            List<DataPolicyOnOrg> dataPolicyOnOrgs = this.dataPolicyOnOrgRepository.findByPolicySid(dataPolicy.getSid());
            ArrayList<Object> dataPolicyOnOrgsToAdd = new ArrayList<Object>();
            for (DataPolicyOnOrg dataPolicyOnOrg : dataPolicyOnOrgs) {
                DataPolicyOnOrg dataPolicyOnOrg1 = new DataPolicyOnOrg();
                BeanUtils.copyProperties((Object)((Object)dataPolicyOnOrg), (Object)((Object)dataPolicyOnOrg1));
                dataPolicyOnOrg1.setPolicySid(newDataPolicy.getSid());
                dataPolicyOnOrg1.setSid(SnowFlake.getInstance().newId());
                DataPolicyOnOrg exist = this.dataPolicyOnOrgRepository.findByOrgSidAndPolicySid(dataPolicyOnOrg1.getOrgSid(), dataPolicyOnOrg1.getPolicySid());
                if (exist != null) continue;
                logger.info("\u3010relocateAction\u3011 DataPolicyOnOrg add,sid:{}", (Object)dataPolicyOnOrg1.getSid());
                dataPolicyOnOrgsToAdd.add((Object)dataPolicyOnOrg1);
            }
            this.dataPolicyOnOrgRepository.saveAll(dataPolicyOnOrgsToAdd);
            List<DataPolicyOnRole> dataPolicyOnRoles = this.dataPolicyOnRoleRepository.findByPolicySid(dataPolicy.getSid());
            ArrayList<Object> dataPolicyOnRolesToAdd = new ArrayList<Object>();
            for (DataPolicyOnRole dataPolicyOnRole : dataPolicyOnRoles) {
                DataPolicyOnRole dataPolicyOnRole1 = new DataPolicyOnRole();
                BeanUtils.copyProperties((Object)((Object)dataPolicyOnRole), (Object)((Object)dataPolicyOnRole1));
                dataPolicyOnRole1.setPolicySid(newDataPolicy.getSid());
                dataPolicyOnRole1.setSid(SnowFlake.getInstance().newId());
                DataPolicyOnRole exist = this.dataPolicyOnRoleRepository.findByRoleSidAndPolicySid(dataPolicyOnRole1.getRoleSid(), dataPolicyOnRole1.getPolicySid());
                if (exist != null) continue;
                logger.info("\u3010relocateAction\u3011 DataPolicyOnRole add,sid:{}", (Object)dataPolicyOnRole1.getSid());
                dataPolicyOnRolesToAdd.add((Object)dataPolicyOnRole1);
            }
            this.dataPolicyOnRoleRepository.saveAll(dataPolicyOnRolesToAdd);
            List<DataPolicyOnUser> dataPolicyOnUsers = this.dataPolicyOnUserRepository.findByPolicySid(dataPolicy.getSid());
            ArrayList<DataPolicyOnUser> dataPolicyOnUsersToAdd = new ArrayList<DataPolicyOnUser>();
            for (DataPolicyOnUser dataPolicyOnUser : dataPolicyOnUsers) {
                DataPolicyOnUser dataPolicyOnUser1 = new DataPolicyOnUser();
                BeanUtils.copyProperties((Object)((Object)dataPolicyOnUser), (Object)((Object)dataPolicyOnUser1));
                dataPolicyOnUser1.setPolicySid(newDataPolicy.getSid());
                dataPolicyOnUser1.setSid(SnowFlake.getInstance().newId());
                DataPolicyOnUser exist = this.dataPolicyOnUserRepository.findByUserSidAndPolicySid(dataPolicyOnUser1.getUserSid(), dataPolicyOnUser1.getPolicySid());
                if (exist != null) continue;
                logger.info("\u3010relocateAction\u3011 DataPolicyOnUser add,sid:{}", (Object)dataPolicyOnUser1.getSid());
                dataPolicyOnUsersToAdd.add(dataPolicyOnUser1);
            }
            this.dataPolicyOnUserRepository.saveAll(dataPolicyOnUsersToAdd);
            List<DataStatement> dataStatements = this.dataStatementRepository.findByPolicySid(dataPolicy.getSid());
            for (DataStatement a3 : dataStatements) {
                logger.info("\u3010relocateAction\u3011 DataStatement setPolicySid,old:{},new:{}", (Object)a3.getPolicySid(), (Object)newDataPolicy.getSysSid());
                a3.setPolicySid(newDataPolicy.getSid());
            }
            this.dataStatementRepository.saveAll(dataStatements);
        }
        this.refreshCacheService.deletePermissionBySys(sourceSys.getId());
    }

    private void checkExistence(ActionVO actionVO) {
        Action action;
        Sys sys = (Sys)this.sysCrudService.findById(actionVO.getAppId());
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{actionVO.getAppId()});
        }
        Module module = (Module)this.moduleCrudService.findByUnionKey(new Object[]{actionVO.getModuleId(), sys.getSid()});
        if (module == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{actionVO.getModuleId()});
        }
        if (StringUtils.hasLength((String)actionVO.getId()) && (action = (Action)this.actionCrudService.findByUnionKey(new Object[]{actionVO.getId(), module.getSid(), 0})) == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST, new Object[]{actionVO.getId()});
        }
    }
}

