/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.auth.impl;

import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.iam.constant.ErrorCodeEnum;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.service.auth.AppAuthCheckService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.domain.AuthAppResultVO;
import com.digiwin.dap.middleware.iam.util.RedisUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppAuthCheckServiceImpl
implements AppAuthCheckService {
    @Autowired
    private CacService cacService;
    @Autowired
    private CommonCacheService commonCacheService;

    @Override
    public AuthResult getAppAuth(AuthResult authResult, AuthoredUser authoredUser, AuthoredSys authoredSys) {
        return this.getAppAuth0(authoredSys.isPlatform(), authoredSys.getId(), authoredUser.getTenantId(), authoredUser.getUserId(), authResult.getTenants());
    }

    @Override
    public AuthResult getAppAuth(boolean isPlatform, String sysId, String tenantId, String userId) {
        return this.getAppAuth(isPlatform, sysId, tenantId, userId, Collections.emptyList());
    }

    @Override
    public AuthResult getAppAuth(boolean isPlatform, String sysId, String tenantId, String userId, List<String> tenantIds) {
        boolean exists = this.commonCacheService.existsBySysIdAndTenantId(sysId, tenantId);
        if (!exists) {
            return AuthResult.of((AuthType)AuthType.AppNone);
        }
        return this.getAppAuth0(isPlatform, sysId, tenantId, userId, tenantIds);
    }

    private AuthResult getAppAuth0(boolean isPlatform, String sysId, String tenantId, String userId, List<String> tenants) {
        String cacAuthKey = LoginUser.cacAuthKey(tenantId, userId, sysId);
        AuthAppResultVO result = (AuthAppResultVO)((Object)RedisUtils.get((Object)cacAuthKey, AuthAppResultVO.class));
        if (result == null) {
            ArrayList<String> apps = new ArrayList();
            ArrayList<String> platformApps = new ArrayList();
            if (isPlatform) {
                apps = this.commonCacheService.getSysByPlatformId(sysId);
            } else {
                platformApps = this.commonCacheService.getPlatformSysBySysId(sysId);
            }
            result = this.cacService.getAuthPlatformAppResult(tenantId, userId, sysId, apps, platformApps, tenants, !"integration;virtual".contains(userId));
        }
        if (result != null) {
            if (result.getSuccess()) {
                cacAuthKey = LoginUser.cacAuthKey(result.getTenantId(), userId, sysId);
                RedisUtils.set((String)cacAuthKey, (Object)((Object)result), (Duration)RedisUtil.calcDuration(result.getExpiredDateTime()));
                result.setAuthType(AuthType.AppOk);
            } else if ("noPurchase".equals(result.getNoAuthType())) {
                result.setAuthType(AuthType.AppNone);
            } else if ("expired".equals(result.getNoAuthType())) {
                result.setAuthType(AuthType.AppExpired);
            } else if ("noAuthorization".equals(result.getNoAuthType())) {
                result.setAuthType(AuthType.AppNoneUser);
            }
        } else {
            String message = String.format("\u83b7\u53d6\u79df\u6237[%s]\u7528\u6237[%s]\u7684\u5e94\u7528[%s]\u6388\u6743\u4fe1\u606f\u5931\u8d25", tenantId, userId, sysId);
            throw new UnauthorizedException((ErrorHandler)I18nError.ERROR_21009, message, ErrorCodeEnum.FAILED_TO_OBTAIN_AUTHORIZATION_INFORMATION.getCode().intValue());
        }
        return result;
    }
}

