/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.authapp.impl;

import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.iam.domain.authapp.AuthAppDTO;
import com.digiwin.dap.middleware.iam.domain.authapp.AuthAppVO;
import com.digiwin.dap.middleware.iam.entity.AuthApp;
import com.digiwin.dap.middleware.iam.entity.SysSsoUrlConfig;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.AuthAppMapper;
import com.digiwin.dap.middleware.iam.repository.AuthAppRepository;
import com.digiwin.dap.middleware.iam.service.authapp.AuthAppService;
import com.digiwin.dap.middleware.iam.service.sso.SysSsoUrlConfigCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageSerializable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuthAppServiceImpl
implements AuthAppService {
    @Autowired
    private AuthAppMapper authAppMapper;
    @Autowired
    private AuthAppRepository authAppRepository;
    @Autowired
    private SysSsoUrlConfigCrudService sysSsoUrlConfigCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;

    public PageSerializable<AuthAppVO> list(Page page, AuthAppDTO dto) {
        return PageHelper.startPage((int)page.getPageNum(), (int)page.getPageSize(), (String)page.getOrderBy()).doSelectPageSerializable(() -> this.authAppMapper.list(dto));
    }

    @Override
    public boolean existsByTenantIdAndSysIdAndType(String tenantId, String sysId, String type) {
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null || !tenant.isOidcLogin()) {
            return false;
        }
        AuthApp authApp = this.authAppRepository.findByTenantSidAndSysIdAndType(tenant.getSid(), sysId, type);
        if (authApp == null) {
            return false;
        }
        SysSsoUrlConfig ssoUrlConfig = this.sysSsoUrlConfigCrudService.findBySysIdAndSsoType(sysId, type);
        return ssoUrlConfig != null;
    }
}

