/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.authentication.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationInfoVO;
import com.digiwin.dap.middleware.iam.domain.authentication.TenantCertificationVO;
import com.digiwin.dap.middleware.iam.domain.authentication.UserCertificationVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserCertification;
import com.digiwin.dap.middleware.iam.service.authentication.TenantAuthenticationService;
import com.digiwin.dap.middleware.iam.service.authentication.TenantCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.authentication.UserAuthenticationService;
import com.digiwin.dap.middleware.iam.service.authentication.UserCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceDataSyncService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteAOneService;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EnterpriseAccountInfo;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EnterpriseAuthParameter;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.EnterpriseAuthResult;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonAccountInfo;
import com.digiwin.dap.middleware.iam.support.remote.authentication.service.RemoteESignService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class TenantAuthenticationServiceImpl
implements TenantAuthenticationService {
    private static final Logger logger = LoggerFactory.getLogger(TenantAuthenticationServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private RemoteAOneService remoteAOneService;
    @Autowired
    private RemoteESignService remoteESignService;
    @Autowired
    private UserAuthenticationService userAuthenticationService;
    @Autowired
    private UserCertificationCrudService userCertificationCrudService;
    @Autowired
    private TenantCertificationCrudService tenantCertificationCrudService;
    @Autowired
    private InvoiceDataSyncService invoiceDataSyncService;

    @Override
    public Map<String, String> getTenantAuthenticationUrl(User user, Tenant tenant, String redirectUrl) {
        PersonAccountInfo personAccountInfo = new PersonAccountInfo(user.getId());
        String agentAccountId = this.remoteESignService.getAccountId(personAccountInfo.getThirdId());
        if (agentAccountId == null) {
            agentAccountId = this.remoteESignService.createPersonAccount(personAccountInfo);
        }
        Assert.hasText((String)agentAccountId, (String)String.format("\u7528\u6237[%s]\u521b\u5efa\u4e2a\u4eba\u8d26\u53f7\u5931\u8d25\uff01", user.getId()));
        EnterpriseAccountInfo enterpriseAccountInfo = new EnterpriseAccountInfo(tenant, agentAccountId);
        String enterpriseAccountId = this.remoteESignService.getAccountId(enterpriseAccountInfo.getThirdId());
        if (enterpriseAccountId == null) {
            enterpriseAccountId = this.remoteESignService.createEnterpriseAccount(enterpriseAccountInfo);
        }
        Assert.hasText((String)enterpriseAccountId, (String)String.format("\u7528\u6237[%s]\u521b\u5efa\u4f01\u4e1a\u8d26\u53f7[%s]\u5931\u8d25\uff01", user.getId(), tenant.getId()));
        TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenant.getSid());
        if (tenantCertification == null) {
            tenantCertification = new TenantCertification();
            tenantCertification.setPassed(false);
            tenantCertification.setTenantSid(tenant.getSid());
            tenantCertification.setAccountId(enterpriseAccountId);
            this.tenantCertificationCrudService.create((BaseEntity)tenantCertification);
        } else {
            tenantCertification.setPassed(false);
            tenantCertification.setAccountId(enterpriseAccountId);
            this.tenantCertificationCrudService.update((BaseEntity)tenantCertification);
        }
        UserCertification userCertification = this.userCertificationCrudService.findByUserSid(tenant.getOwnerUserSid());
        if (userCertification == null) {
            userCertification = new UserCertification();
            userCertification.setAccountId(agentAccountId);
            userCertification.setUserSid(tenant.getOwnerUserSid());
            userCertification.setPassed(false);
            this.userCertificationCrudService.create(userCertification);
        } else {
            userCertification.setAccountId(agentAccountId);
            userCertification.setUserSid(tenant.getOwnerUserSid());
            userCertification.setPassed(false);
            this.userCertificationCrudService.update(userCertification);
        }
        EnterpriseAuthParameter parameterVO = new EnterpriseAuthParameter();
        parameterVO.setAgentAccountId(agentAccountId);
        parameterVO.setOrgAccountId(enterpriseAccountId);
        parameterVO.setNotifyUrl(this.envProperties.getNotifyUri() + "/api/iam/v2/authentication/tenant/callback");
        parameterVO.setRedirectUrl(redirectUrl);
        Map<String, String> reponseBody = this.remoteESignService.getEnterpriseAuthUrl(parameterVO);
        if (reponseBody != null && reponseBody.get("url") != null) {
            return reponseBody;
        }
        throw new BusinessException((ErrorHandler)I18nError.REAL_NAME_AUTHENTICATION_FAILED, new Object[]{user.getId()});
    }

    @Override
    public TenantCertification authenticationCallback(String enterpriseAccountId, String agentAccountId, String serviceId, String agentServiceId) {
        this.userAuthenticationService.authenticationCallback(agentAccountId, serviceId);
        return this.authenticationCallback(enterpriseAccountId, serviceId);
    }

    @Override
    public AuthenticationInfoVO authenticationCallback(String invitedId) {
        return null;
    }

    protected TenantCertification authenticationCallback(String enterpriseAccountId, String serviceId) {
        TenantCertification tenantCertificationInDB = this.tenantCertificationCrudService.findByAccountId(enterpriseAccountId);
        if (tenantCertificationInDB != null) {
            EnterpriseAuthResult enterpriseAuthResult = this.remoteESignService.getEnterpriseAuthenticationResult(enterpriseAccountId, serviceId);
            if (enterpriseAuthResult != null && enterpriseAuthResult.getInformation() != null) {
                BeanUtils.mergeDifferentTypeObject((Object)enterpriseAuthResult.getInformation(), (Object)((Object)tenantCertificationInDB));
                tenantCertificationInDB.setPassed(enterpriseAuthResult.getPassed());
                this.tenantCertificationCrudService.update((BaseEntity)tenantCertificationInDB);
                this.invoiceDataSyncService.certificationToInvoiceInfo(tenantCertificationInDB, "CN");
                Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantCertificationInDB.getTenantSid());
                if (null != tenant && !tenantCertificationInDB.getName().equals(tenant.getName())) {
                    tenant.setName(tenantCertificationInDB.getName());
                    this.tenantCrudService.update((BaseEntity)tenant);
                }
            } else {
                logger.error(String.format("\u83b7\u53d6\u4f01\u4e1a[%s]\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff01", enterpriseAccountId));
            }
        }
        return tenantCertificationInDB;
    }

    @Override
    public Map<String, Object> authenticationTwTenant(long tenantSid, String tenantName, String businessAccountingNo) {
        if (this.tenantCertificationCrudService.existsTenantCertificationByBusinessAccountingNo(businessAccountingNo)) {
            throw new BusinessException((ErrorHandler)I18nError.HAS_REAL_NAME_AUTHENTICATION, new Object[]{businessAccountingNo});
        }
        Map<String, Object> responseMap = this.remoteAOneService.authenticationEnterprise(businessAccountingNo);
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (responseMap != null) {
            String companyName = "Company_Name";
            if (tenantName.equals(responseMap.get("Company_Name"))) {
                result.put("msg", "\u9a8c\u8bc1\u6210\u529f\uff01");
                result.put("passed", true);
                TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenantSid);
                if (tenantCertification == null) {
                    tenantCertification = new TenantCertification();
                    tenantCertification.setName(tenantName);
                    tenantCertification.setTenantSid(tenantSid);
                    tenantCertification.setPassed(true);
                    tenantCertification.setBusinessAccountingNo(businessAccountingNo);
                    this.tenantCertificationCrudService.create((BaseEntity)tenantCertification);
                    this.invoiceDataSyncService.certificationToInvoiceInfo(tenantCertification, "TW");
                } else {
                    tenantCertification.setName(tenantName);
                    tenantCertification.setPassed(true);
                    tenantCertification.setBusinessAccountingNo(businessAccountingNo);
                    this.tenantCertificationCrudService.update((BaseEntity)tenantCertification);
                    this.invoiceDataSyncService.certificationToInvoiceInfo(tenantCertification, "TW");
                }
            } else {
                this.createTenantCertification(tenantSid, false);
                result.put("passed", false);
                result.put("msg", String.format("\u7edf\u4e00\u7f16\u7801[%s]\u5bf9\u5e94\u7684\u4f01\u4e1a\u540d\u79f0[%s]\u4e0e\u8981\u8ba4\u8bc1\u7684\u4f01\u4e1a[%s]\u4e0d\u4e00\u81f4\uff01", businessAccountingNo, responseMap.get("Company_Name"), tenantName));
                logger.error(String.format("\u7edf\u4e00\u7f16\u7801[%s]\u5bf9\u5e94\u7684\u4f01\u4e1a\u540d\u79f0[%s]\u4e0e\u8981\u8ba4\u8bc1\u7684\u4f01\u4e1a[%s]\u4e0d\u4e00\u81f4\uff01", businessAccountingNo, responseMap.get("Company_Name"), tenantName));
            }
        } else {
            this.createTenantCertification(tenantSid, false);
            result.put("passed", false);
            result.put("msg", String.format("\u672a\u627e\u5230[%s]\u5bf9\u5e94\u7684\u4f01\u4e1a\uff0c\u5b9e\u540d\u8ba4\u8bc1\u5931\u8d25\uff01", businessAccountingNo));
            logger.error(String.format("\u672a\u627e\u5230[%s]\u5bf9\u5e94\u7684\u4f01\u4e1a\uff0c\u5b9e\u540d\u8ba4\u8bc1\u5931\u8d25\uff01", businessAccountingNo));
        }
        return result;
    }

    @Override
    public AuthenticationInfoVO getAuthenticationInfo(long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", tenantSid));
        AuthenticationInfoVO authenticationInfoVO = new AuthenticationInfoVO();
        if (TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue().equals(tenant.getEnterpriseType())) {
            TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenantSid);
            if (tenantCertification != null && !StringUtils.isEmpty((Object)tenantCertification.getAccountId()) && !tenantCertification.isPassed()) {
                tenantCertification = this.authenticationCallback(tenantCertification.getAccountId(), tenantCertification.getServiceId());
            }
            TenantCertificationVO tenantCertificationVO = new TenantCertificationVO();
            BeanUtils.mergeDifferentTypeObject((Object)((Object)tenantCertification), (Object)tenantCertificationVO);
            tenantCertificationVO.setAddress(tenant.getAddress());
            if (tenantCertificationVO.getName() == null) {
                tenantCertificationVO.setName(tenant.getName());
            }
            authenticationInfoVO.setTenantCertification(tenantCertificationVO);
        }
        User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
        Assert.notNull((Object)((Object)user), (String)String.format("\u79df\u6237[%s]\u7684\u521b\u5efa\u8005[%s]\u4e0d\u5b58\u5728\uff01", tenant.getId(), tenant.getOwnerUserSid()));
        UserCertification userCertification = this.userCertificationCrudService.findByUserSid(tenant.getOwnerUserSid());
        if (userCertification != null && !StringUtils.isEmpty((Object)userCertification.getAccountId()) && !userCertification.isPassed()) {
            userCertification = this.userAuthenticationService.authenticationCallback(userCertification.getAccountId(), userCertification.getServiceId());
        }
        UserCertificationVO userCertificationVO = new UserCertificationVO();
        BeanUtils.mergeDifferentTypeObject((Object)((Object)userCertification), (Object)userCertificationVO);
        if (userCertificationVO.getName() == null) {
            userCertificationVO.setName(tenant.getContacts());
        }
        if (userCertificationVO.getMobile() == null) {
            userCertificationVO.setMobile(tenant.getPhone());
        }
        userCertificationVO.setAddress(user.getAddress());
        authenticationInfoVO.setUserCertification(userCertificationVO);
        return authenticationInfoVO;
    }

    @Override
    public void removeAuthenticationInfo(long tenantSid, long ownerUserSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        Assert.notNull((Object)((Object)tenant), (String)String.format("\u79df\u6237[%s]\u4e0d\u5b58\u5728\uff01", tenantSid));
        TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenantSid);
        if (tenantCertification != null) {
            this.tenantCertificationCrudService.deleteById(tenantCertification.getSid());
            if (tenantCertification.getBusinessAccountingNo() == null) {
                this.remoteESignService.deleteAccount(tenantCertification.getAccountId());
            }
        }
        User user = (User)this.userCrudService.findBySid(tenant.getOwnerUserSid());
        Assert.notNull((Object)((Object)user), (String)String.format("\u79df\u6237[%s]\u7684\u521b\u5efa\u8005[%s]\u4e0d\u5b58\u5728\uff01", tenant.getId(), tenant.getOwnerUserSid()));
        UserCertification userCertification = this.userCertificationCrudService.findByUserSid(tenant.getOwnerUserSid());
        if (userCertification != null) {
            this.userCertificationCrudService.deleteById(userCertification.getSid());
            this.remoteESignService.deleteAccount(userCertification.getAccountId());
        }
    }

    private void createTenantCertification(long tenantSid, boolean passed) {
        TenantCertification tenantCertification = this.tenantCertificationCrudService.findByTenantSid(tenantSid);
        if (tenantCertification == null) {
            tenantCertification = new TenantCertification();
            tenantCertification.setTenantSid(tenantSid);
            tenantCertification.setPassed(passed);
            this.tenantCertificationCrudService.create((BaseEntity)tenantCertification);
        } else {
            tenantCertification.setTenantSid(tenantSid);
            tenantCertification.setPassed(passed);
            this.tenantCertificationCrudService.update((BaseEntity)tenantCertification);
        }
    }
}

