/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.authentication.impl;

import com.digiwin.dap.middleware.commons.util.BeanUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationInfoVO;
import com.digiwin.dap.middleware.iam.domain.authentication.AuthenticationTwUserInfoVO;
import com.digiwin.dap.middleware.iam.domain.authentication.UserCertificationVO;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserCertification;
import com.digiwin.dap.middleware.iam.service.authentication.UserAuthenticationService;
import com.digiwin.dap.middleware.iam.service.authentication.UserCertificationCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonAccountInfo;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonalAuthParameter;
import com.digiwin.dap.middleware.iam.support.remote.authentication.domain.esign.obsolete.PersonalAuthResult;
import com.digiwin.dap.middleware.iam.support.remote.authentication.service.RemoteESignService;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class UserAuthenticationServiceImpl
implements UserAuthenticationService {
    private static final Logger log = LoggerFactory.getLogger(UserAuthenticationServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;
    @Autowired
    private RemoteESignService remoteESignService;
    @Autowired
    private UserCertificationCrudService userCertificationCrudService;

    @Override
    public Map<String, String> getUserAuthenticationUrl(User user, String redirectUrl) {
        PersonAccountInfo personAccountInfo = new PersonAccountInfo(user.getId());
        String accountId = this.remoteESignService.getAccountId(user.getId());
        if (accountId == null) {
            accountId = this.remoteESignService.createPersonAccount(personAccountInfo);
        }
        Assert.hasText((String)accountId, (String)String.format("\u7528\u6237[%s]\u521b\u5efa\u4e2a\u4eba\u8d26\u53f7\u5931\u8d25\uff01", user.getId()));
        UserCertification userCertification = this.userCertificationCrudService.findByUserSid(user.getSid());
        if (userCertification == null) {
            userCertification = new UserCertification();
            userCertification.setAccountId(accountId);
            userCertification.setUserSid(user.getSid());
            userCertification.setPassed(false);
            this.userCertificationCrudService.create(userCertification);
        } else {
            userCertification.setAccountId(accountId);
            userCertification.setUserSid(user.getSid());
            userCertification.setPassed(false);
            this.userCertificationCrudService.update(userCertification);
        }
        PersonalAuthParameter parameterVO = new PersonalAuthParameter();
        parameterVO.setAccountId(accountId);
        parameterVO.setNotifyUrl(this.envProperties.getNotifyUri() + "/api/iam/v2/authentication/user/callback");
        parameterVO.setRedirectUrl(redirectUrl);
        Map<String, String> reponseBody = this.remoteESignService.getPersonalAuthUrl(parameterVO);
        if (reponseBody != null && reponseBody.get("url") != null) {
            return reponseBody;
        }
        throw new BusinessException((ErrorHandler)I18nError.REAL_NAME_AUTHENTICATION_FAILED, new Object[]{user.getId()});
    }

    @Override
    public UserCertification authenticationCallback(String accountId, String serviceId) {
        UserCertification userCertificationDB = this.userCertificationCrudService.findByAccountId(accountId);
        if (userCertificationDB != null) {
            PersonalAuthResult personalAuthResult = this.remoteESignService.getPersonalAuthenticationResult(accountId, serviceId);
            if (personalAuthResult != null && personalAuthResult.getInformation() != null) {
                BeanUtils.mergeDifferentTypeObject((Object)personalAuthResult.getInformation(), (Object)((Object)userCertificationDB));
                userCertificationDB.setPassed(personalAuthResult.getPassed());
                User user = (User)this.userCrudService.findBySid(userCertificationDB.getUserSid());
                if (null != user && !userCertificationDB.getName().equals(user.getName())) {
                    user.setName(userCertificationDB.getName());
                    this.userCrudService.update((BaseEntity)user);
                }
                this.userCertificationCrudService.update(userCertificationDB);
            } else {
                log.error("\u83b7\u53d6\u4e2a\u4eba[{}]\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u5931\u8d25\uff01", (Object)accountId);
            }
        }
        return userCertificationDB;
    }

    @Override
    public Map<String, Object> authenticationTwUser(User user, AuthenticationTwUserInfoVO body) {
        String scene = "authentication";
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        if (this.remoteEMCService.checkVerificationCode(body.getEmail(), scene, body.getVerificationCode())) {
            UserCertification userCertification = this.userCertificationCrudService.findByUserSid(user.getSid());
            if (userCertification == null) {
                userCertification = new UserCertification();
                userCertification.setUserSid(user.getSid());
                userCertification.setEmail(body.getEmail());
                userCertification.setMobile(body.getMobile());
                userCertification.setPassed(true);
                this.userCertificationCrudService.create(userCertification);
            } else {
                userCertification.setUserSid(user.getSid());
                userCertification.setEmail(body.getEmail());
                userCertification.setMobile(body.getMobile());
                userCertification.setPassed(true);
                this.userCertificationCrudService.update(userCertification);
            }
            result.put("passed", true);
            result.put("msg", "\u9a8c\u8bc1\u6210\u529f\uff01");
        } else {
            result.put("passed", false);
            result.put("msg", "\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        }
        return result;
    }

    @Override
    public AuthenticationInfoVO getAuthenticationInfo(long userSid) {
        AuthenticationInfoVO authenticationInfoVO = new AuthenticationInfoVO();
        User user = (User)this.userCrudService.findBySid(userSid);
        UserCertification userCertification = this.userCertificationCrudService.findByUserSid(userSid);
        if (userCertification != null && !StringUtils.isEmpty((Object)userCertification.getAccountId()) && !userCertification.isPassed()) {
            userCertification = this.authenticationCallback(userCertification.getAccountId(), userCertification.getServiceId());
        }
        UserCertificationVO userCertificationVO = new UserCertificationVO();
        BeanUtils.mergeDifferentTypeObject((Object)((Object)userCertification), (Object)userCertificationVO);
        userCertificationVO.setAddress(user.getAddress());
        authenticationInfoVO.setUserCertification(userCertificationVO);
        return authenticationInfoVO;
    }
}

