/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.card.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.tenant.UserInTenantVO;
import com.digiwin.dap.middleware.iam.entity.CardInfo;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.CardMapper;
import com.digiwin.dap.middleware.iam.repository.CardInfoRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.card.CardInfoCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CardInfoCrudServiceImpl
extends BaseEntityManagerService<CardInfo>
implements CardInfoCrudService {
    @Autowired
    private CardMapper cardMapper;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private CardInfoRepository cardInfoRepository;
    @Autowired
    private CardInfoCrudService cardInfoCrudService;
    @Autowired
    private UserInTenantRepository userInTenantRepository;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    protected CardInfoRepository getRepository() {
        return this.cardInfoRepository;
    }

    @Override
    public CardInfo findByIdAndType(String id, String type) {
        return this.cardInfoRepository.findByIdAndType(id, type);
    }

    @Override
    public void check(UserInTenantVO body) {
        User user = (User)this.userCrudService.findById(body.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{body.getUserId()});
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(body.getTenantSid(), user.getSid());
        if (userInTenant == null) {
            String message = String.format("\u79df\u6237[%s]\u4e0b\u6ca1\u6709\u6b64\u7528\u6237[%s]", body.getTenantId(), body.getUserId());
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{body.getUserId()}, message);
        }
        body.setSid(userInTenant.getSid());
        body.setUserSid(user.getSid());
        body.setUserId(user.getId());
        body.setUserName(user.getName());
        List<CardInfo> cardInfos = this.cardMapper.findCardInfo(user.getSid(), body.getCardType());
        int cardSize = cardInfos.size();
        if (cardSize == 1 ? !cardInfos.get(0).getId().equals(body.getCardId()) || !cardInfos.get(0).getType().equals(body.getCardType()) : cardSize > 1) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_BIND_CHECK_USER);
        }
    }

    private void compatibleRfid(String cardType, String cardId, long userTenantSid) {
        if ("rfid".equals(cardType)) {
            UserInTenant userInTenant = (UserInTenant)this.userInTenantCrudService.findBySid(userTenantSid);
            userInTenant.setCardId(cardId);
            this.userInTenantRepository.save((Object)userInTenant);
        }
    }

    @Override
    public void bind(UserInTenantVO body) {
        this.check(body);
        CardInfo cardInfo = this.findByIdAndType(body.getCardId(), body.getCardType());
        if (cardInfo != null) {
            UserInTenant userInTenant = (UserInTenant)this.userInTenantCrudService.findBySid(cardInfo.getUserTenantSid());
            if (userInTenant != null) {
                Tenant tenant = (Tenant)this.tenantCrudService.findBySid(body.getTenantSid());
                User user = (User)this.userCrudService.findBySid(userInTenant.getUserSid());
                if (tenant != null && user != null && body.getSid().longValue() != userInTenant.getSid()) {
                    String message = String.format("\u8be5\u5361\u7247[(%s)%s]\u5df2\u7ecf\u7ed1\u5b9a\u79df\u6237[%s]\u4e0b\u7684\u7528\u6237[%s]", body.getCardType(), body.getCardId(), tenant.getId(), user.getId());
                    throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_BIND_CHECK_CARD, message);
                }
            }
            cardInfo.setUserTenantSid(body.getSid());
            this.cardInfoCrudService.update(cardInfo);
        } else {
            cardInfo = new CardInfo();
            cardInfo.setId(body.getCardId());
            cardInfo.setType(body.getCardType());
            cardInfo.setUserTenantSid(body.getSid());
            this.cardInfoCrudService.create(cardInfo);
        }
        this.compatibleRfid(body.getCardType(), body.getCardId(), body.getSid());
    }

    @Override
    public void bindForce(UserInTenantVO body) {
        this.check(body);
        CardInfo cardInfo = this.getCardInfo(body.getCardType(), body.getCardId());
        if (body.getSid().longValue() != cardInfo.getUserTenantSid()) {
            this.compatibleRfid(body.getCardType(), null, cardInfo.getUserTenantSid());
            this.compatibleRfid(body.getCardType(), body.getCardId(), body.getSid());
            cardInfo.setUserTenantSid(body.getSid());
            this.cardInfoCrudService.update(cardInfo);
        }
    }

    @Override
    public void unbind(UserInTenantVO body) {
        CardInfo cardInfo = this.cardInfoCrudService.findByIdAndType(body.getCardId(), body.getCardType());
        if (cardInfo != null) {
            UserInTenant userInTenant = (UserInTenant)this.userInTenantCrudService.findBySid(cardInfo.getUserTenantSid());
            if (userInTenant != null) {
                User user;
                body.setSid(userInTenant.getSid());
                Tenant tenant = (Tenant)this.tenantCrudService.findBySid(userInTenant.getTenantSid());
                if (tenant != null) {
                    body.setTenantSid(tenant.getSid());
                    body.setTenantId(tenant.getId());
                    body.setTenantName(tenant.getName());
                }
                if ((user = (User)this.userCrudService.findBySid(userInTenant.getUserSid())) != null) {
                    body.setUserSid(user.getSid());
                    body.setUserId(user.getId());
                    body.setUserName(user.getName());
                }
                if (tenant != null && user != null && !body.getTenantId().equals(tenant.getId())) {
                    String message = String.format("\u5f53\u524d\u79df\u6237[%s]\u4e0d\u80fd\u89e3\u7ed1\u5176\u4ed6\u79df\u6237[%s]\u4e0b\u7684\u7528\u6237[%s]", body.getTenantId(), tenant.getId(), user.getId());
                    throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_BIND_OTHER_TENANT, message);
                }
                this.compatibleRfid(body.getCardType(), null, body.getSid());
            }
            this.cardInfoCrudService.deleteById(cardInfo.getSid());
        }
    }

    @Override
    public void info(UserInTenantVO body) {
        CardInfo cardInfo = this.getCardInfo(body.getCardType(), body.getCardId());
        UserInTenant userInTenant = this.getUserInTenant(body.getCardType(), body.getCardId(), cardInfo.getUserTenantSid());
        Tenant tenant = this.getTenant(cardInfo.getType(), cardInfo.getId(), userInTenant.getTenantSid());
        User user = this.getUser(cardInfo.getType(), cardInfo.getId(), userInTenant.getUserSid());
        if (!body.getTenantId().equals(tenant.getId())) {
            String message = String.format("\u5f53\u524d\u79df\u6237[%s]\u4e0d\u80fd\u67e5\u770b\u5176\u4ed6\u79df\u6237[%s]\u4e0b\u7684\u7528\u6237[%s]\u7ed1\u5b9a\u4fe1\u606f", body.getTenantId(), tenant.getId(), user.getId());
            throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_BIND_OTHER_TENANT, message);
        }
        body.setSid(userInTenant.getSid());
        body.setUserSid(user.getSid());
        body.setUserId(user.getId());
        body.setUserName(user.getName());
        body.setTenantSid(tenant.getSid());
        body.setTenantId(tenant.getId());
        body.setTenantName(tenant.getName());
    }

    private CardInfo getCardInfo(String cardType, String cardId) {
        CardInfo cardInfo = this.cardInfoCrudService.findByIdAndType(cardId, cardType);
        if (cardInfo == null) {
            String message = String.format("\u8be5\u5361\u7247[(%s)%s]\u6ca1\u6709\u7ed1\u5b9a\u8bb0\u5f55", cardType, cardId);
            throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_NOT_EXISTED, message);
        }
        return cardInfo;
    }

    private UserInTenant getUserInTenant(String cardType, String cardId, long userTenantSid) {
        UserInTenant userInTenant = (UserInTenant)this.userInTenantCrudService.findBySid(userTenantSid);
        if (userInTenant == null) {
            String message = String.format("\u8be5\u5361\u7247[(%s)%s]\u7684\u7ed1\u5b9a\u8bb0\u5f55[%s]\u672a\u627e\u5230", cardType, cardId, userTenantSid);
            throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_NOT_EXISTED, message);
        }
        return userInTenant;
    }

    private Tenant getTenant(String cardType, String cardId, long tenantSid) {
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(tenantSid);
        if (tenant == null) {
            String message = String.format("\u8be5\u5361\u7247[(%s)%s]\u7684\u7ed1\u5b9a\u8bb0\u5f55\u79df\u6237[%s]\u672a\u627e\u5230", cardType, cardId, tenantSid);
            throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_NOT_EXISTED, message);
        }
        return tenant;
    }

    private User getUser(String cardType, String cardId, long userSid) {
        User user = (User)this.userCrudService.findBySid(userSid);
        if (user == null) {
            String message = String.format("\u8be5\u5361\u7247[(%s)%s]\u7684\u7ed1\u5b9a\u8bb0\u5f55\u7528\u6237[%s]\u672a\u627e\u5230", cardType, cardId, userSid);
            throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_NOT_EXISTED, message);
        }
        return user;
    }
}

