/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.creator.impl;

import cn.hutool.core.date.LocalDateTimeUtil;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TransferCreatorStatusEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.creator.TransferCreatorApplicationPageVO;
import com.digiwin.dap.middleware.iam.domain.creator.TransferCreatorApplicationRspVO;
import com.digiwin.dap.middleware.iam.domain.creator.TransferCreatorApplicationVO;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.TransferCreatorApplication;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.TransferCreatorMapper;
import com.digiwin.dap.middleware.iam.repository.TransferCreatorRepository;
import com.digiwin.dap.middleware.iam.service.creator.TransferCreatorCrudService;
import com.digiwin.dap.middleware.iam.service.creator.TransferCreatorService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalDate;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TransferCreatorServiceImpl
implements TransferCreatorService {
    @Resource
    private RemoteEMCService emcService;
    @Resource
    private TransferCreatorCrudService transferCreatorCrudService;
    @Resource
    private TransferCreatorMapper transferCreatorMapper;
    @Resource
    private TransferCreatorRepository transferCreatorRepository;
    @Resource
    private MessageService messageService;
    @Resource
    private UserCrudService userCrudService;
    @Resource
    private TenantCrudService tenantCrudService;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Resource
    private EnvProperties envProperties;

    @Override
    public void create(TransferCreatorApplicationVO body) {
        if (!this.emcService.checkVerificationCode(Optional.ofNullable(body.getEmail()).orElse(body.getTelephone()), "register", body.getVerifyCode())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_VERIFICATION_CODE_ERROR);
        }
        TransferCreatorApplication transferCreatorApplication = (TransferCreatorApplication)((Object)body.doForward());
        transferCreatorApplication.setStatus(TransferCreatorStatusEnum.INIT.getStatus());
        transferCreatorApplication.setApplyCode(this.generateApplyCode());
        this.transferCreatorCrudService.create(transferCreatorApplication);
        this.messageService.sendTransferCreatorReminder(transferCreatorApplication);
    }

    private String generateApplyCode() {
        String prefix = "creat";
        if (this.envProperties.isAli()) {
            prefix = "creac";
        }
        prefix = prefix + LocalDateTimeUtil.format((LocalDate)LocalDate.now(), (String)"yyMMdd");
        int newSeq = this.transferCreatorMapper.findMaxCode(prefix) + 1;
        return prefix + String.format("%04d", newSeq);
    }

    @Override
    public PageSerializable<TransferCreatorApplicationRspVO> findPage(TransferCreatorApplicationPageVO body) {
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize(), (String)Optional.ofNullable(body.getOrderBy()).orElse("tc.sid desc"));
        return new PageSerializable(this.transferCreatorMapper.findPage(body));
    }

    @Override
    @Transactional
    public void reject(TransferCreatorApplicationVO body) {
        TransferCreatorApplication transferCreatorApplication = (TransferCreatorApplication)((Object)this.transferCreatorRepository.findById(body.getSid()).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.IAM_DATA_NOT_EXIST)));
        transferCreatorApplication.setStatus(TransferCreatorStatusEnum.REJECTED.getStatus());
        this.messageService.sendRejectMessage(transferCreatorApplication, body);
    }

    @Override
    @Transactional
    public void change(TransferCreatorApplicationVO body) {
        TransferCreatorApplication application = (TransferCreatorApplication)((Object)this.transferCreatorRepository.findById(body.getSid()).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.IAM_DATA_NOT_EXIST)));
        application.setStatus(TransferCreatorStatusEnum.CLOSED.getStatus());
        User transferTo = (User)Optional.ofNullable(this.userCrudService.findById(application.getTransferTo())).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{application.getTransferTo()}));
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(application.getTenantSid());
        long oldOwnerUserSid = tenant.getOwnerUserSid();
        tenant.setOwnerUserSid(transferTo.getSid());
        this.tenantCrudService.update((BaseEntity)tenant);
        this.userInRoleService.addAdminRole(tenant, transferTo);
        this.userInTenantCrudService.disable(tenant.getSid(), oldOwnerUserSid);
        this.messageService.sendUpdateTenantCreator(application.getTenantSid(), application.getEmail(), transferTo.getId(), oldOwnerUserSid, application.getTelephone(), "new");
    }
}

