/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dataplus.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusDataFilterVO;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusEditLimitVO;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusFieldFilterVO;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusOperationUnitVO;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusPermission;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusTypeEnum;
import com.digiwin.dap.middleware.iam.domain.dataplus.OperationUnitTargetEnum;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourceActionConditionVO;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourceCondition;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourceConditionPermission;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourceConditionVO;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetCondition;
import com.digiwin.dap.middleware.iam.entity.DataPlusPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPlusStatement;
import com.digiwin.dap.middleware.iam.mapper.DataPlusOperationUnitMapper;
import com.digiwin.dap.middleware.iam.repository.DataPlusOperationUnitRepository;
import com.digiwin.dap.middleware.iam.repository.DataPlusPolicyRepository;
import com.digiwin.dap.middleware.iam.repository.DataPlusStatementRepository;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusPolicyCrudService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DataPlusPolicyCrudServiceImpl
extends BaseEntityManagerService<DataPlusPolicy>
implements DataPlusPolicyCrudService {
    @Autowired
    private DataPlusPolicyRepository dataPlusPolicyRepository;
    @Autowired
    private DataPlusOperationUnitMapper dataPlusOperationUnitMapper;
    @Autowired
    private DataPlusStatementRepository dataPlusStatementRepository;
    @Autowired
    private DataPlusOperationUnitRepository dataPlusOperationUnitRepository;

    protected DataPlusPolicyRepository getRepository() {
        return this.dataPlusPolicyRepository;
    }

    @Override
    @Transactional
    public void batchDel(long tenantSid, String type, long targetSid, List<String> resourceIds) {
        List<DataPlusPolicy> dataPlusPolicies = this.dataPlusPolicyRepository.findByTenantSidAndTypeAndTargetSidAndResourceIdIn(tenantSid, type, targetSid, resourceIds);
        List<Long> dataPlusPolicySids = dataPlusPolicies.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        this.dataPlusPolicyRepository.deleteBySidIn(dataPlusPolicySids);
        this.dataPlusPolicyRepository.flush();
        this.dataPlusStatementRepository.deleteByPolicySidIn(dataPlusPolicySids);
        this.dataPlusOperationUnitRepository.deleteByTypeAndPolicySidIn(OperationUnitTargetEnum.POLICY.name(), dataPlusPolicySids);
    }

    @Override
    @Transactional
    public void batchDel(List<Long> dataPlusPolicySids) {
        this.dataPlusStatementRepository.deleteByPolicySidIn(dataPlusPolicySids);
        this.dataPlusOperationUnitRepository.deleteByTypeAndPolicySidIn(OperationUnitTargetEnum.POLICY.name(), dataPlusPolicySids);
    }

    @Override
    public List<ResourceConditionVO> findResourceCondition(long tenantSid, String type, long targetSid, List<String> resourceIds) {
        List<DataPlusPolicy> dataPlusPolicies = CollectionUtils.isEmpty(resourceIds) ? this.dataPlusPolicyRepository.findByTenantSidAndTypeAndTargetSid(tenantSid, type, targetSid) : this.dataPlusPolicyRepository.findByTenantSidAndTypeAndTargetSidAndResourceIdIn(tenantSid, type, targetSid, resourceIds);
        ArrayList<ResourceConditionVO> resourceConditions = new ArrayList<ResourceConditionVO>();
        dataPlusPolicies.forEach(it -> {
            ResourceConditionVO condition = new ResourceConditionVO();
            condition.setResourceId(it.getResourceId());
            condition.setResourceType(it.getResourceType());
            condition.setConditions(TargetCondition.parse(it.getConditions()));
            resourceConditions.add(condition);
        });
        return resourceConditions;
    }

    @Override
    public List<ResourceActionConditionVO> findActionCondition(long tenantSid, String type, long targetSid, List<String> resourceIds) {
        ArrayList<ResourceActionConditionVO> resourceActionConditions = new ArrayList<ResourceActionConditionVO>();
        List<ResourceCondition> conditions = this.dataPlusOperationUnitMapper.findConditionByResource(tenantSid, type, targetSid, resourceIds);
        conditions.forEach(it -> {
            ResourceActionConditionVO condition = new ResourceActionConditionVO();
            condition.setSysSid(it.getSysSid());
            condition.setActionSid(it.getActionSid());
            condition.setResourceId(it.getResourceId());
            condition.setConditions(TargetCondition.parse(it.getConditionValue()));
            resourceActionConditions.add(condition);
        });
        return resourceActionConditions;
    }

    @Override
    public DataPlusPermission findDetail(long tenantSid, String type, long targetSid, String resourceId, boolean onlyValid) {
        DataPlusPolicy dataPlusPolicy = this.dataPlusPolicyRepository.findByTenantSidAndTypeAndTargetSidAndResourceId(tenantSid, type, targetSid, resourceId);
        if (dataPlusPolicy == null) {
            return null;
        }
        Map<String, List<DataPlusStatement>> dataPlusStatementMap = this.dataPlusStatementRepository.findByPolicySid(dataPlusPolicy.getSid()).stream().collect(Collectors.groupingBy(DataPlusStatement::getType));
        DataPlusPermission dataPlusPermission = new DataPlusPermission();
        dataPlusPermission.setSid(dataPlusPolicy.getSid());
        dataPlusPermission.setResourceId(resourceId);
        List<DataPlusStatement> statements = dataPlusStatementMap.get(DataPlusTypeEnum.DEPT_DATA.name());
        if (statements != null) {
            dataPlusPermission.setDeptData(Arrays.stream(statements.get(0).getValue().split(",")).collect(Collectors.toList()));
        }
        List dataFilters = dataPlusStatementMap.getOrDefault(DataPlusTypeEnum.DATA_FILTER.name(), new ArrayList());
        dataPlusPermission.setDataFilters(dataFilters.stream().map(DataPlusDataFilterVO::new).collect(Collectors.toList()));
        List editLimits = dataPlusStatementMap.getOrDefault(DataPlusTypeEnum.EDIT_LIMIT.name(), new ArrayList());
        dataPlusPermission.setEditLimits(editLimits.stream().map(DataPlusEditLimitVO::new).collect(Collectors.toList()));
        List<DataPlusStatement> fieldFilters = dataPlusStatementMap.get(DataPlusTypeEnum.FIELD_FILTER.name());
        if (fieldFilters != null) {
            dataPlusPermission.setFieldFilters(DataPlusFieldFilterVO.get(fieldFilters.get(0).getFilter()));
        }
        dataPlusPermission.setOperationUnits(this.findOperationUnits(OperationUnitTargetEnum.POLICY, dataPlusPermission.getSid(), onlyValid));
        return dataPlusPermission;
    }

    @Override
    public List<DataPlusOperationUnitVO> findOperationUnits(OperationUnitTargetEnum type, long policySid, boolean onlyValid) {
        List<DataPlusOperationUnitVO> operationUnits = this.dataPlusOperationUnitMapper.findByTypeAndPolicySid(type.name(), policySid, onlyValid);
        if (operationUnits.isEmpty()) {
            return null;
        }
        return operationUnits;
    }

    @Override
    public ResourceConditionPermission findCondition(long tenantSid, TargetType targetType, long targetSid, String resourceId) {
        DataPlusPolicy dataPlusPolicy = this.dataPlusPolicyRepository.findByTenantSidAndTypeAndTargetSidAndResourceId(tenantSid, targetType.name(), targetSid, resourceId);
        if (dataPlusPolicy == null) {
            return null;
        }
        ResourceConditionPermission condition = new ResourceConditionPermission();
        condition.setType(targetType.name());
        condition.setConditions(TargetCondition.parse(dataPlusPolicy.getConditions()));
        return condition;
    }

    @Override
    public List<ResourceCondition> findActionByResourceId(long tenantSid, String type, long targetSid, String resourceId) {
        List<ResourceCondition> targets = this.dataPlusOperationUnitMapper.findActionByResourceId(tenantSid, type, targetSid, resourceId);
        return targets;
    }
}

