/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dataplus.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.dataplus.ActionPlusPermission;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusPermission;
import com.digiwin.dap.middleware.iam.domain.dataplus.DataPlusTypeEnum;
import com.digiwin.dap.middleware.iam.domain.dataplus.OperationUnitTargetEnum;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourceCondition;
import com.digiwin.dap.middleware.iam.domain.dataplus.ResourcePermission;
import com.digiwin.dap.middleware.iam.domain.permission.v2.StatementInfo;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPlusOperationUnit;
import com.digiwin.dap.middleware.iam.entity.DataPlusPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPlusStatement;
import com.digiwin.dap.middleware.iam.entity.Policy;
import com.digiwin.dap.middleware.iam.entity.PolicyResource;
import com.digiwin.dap.middleware.iam.repository.DataPlusPolicyRepository;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusOperationUnitCrudService;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusPolicyService;
import com.digiwin.dap.middleware.iam.service.dataplus.DataPlusStatementCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyConditionValueCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyCrudService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyHandleService;
import com.digiwin.dap.middleware.iam.service.policy.PolicyResourceCrudService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DataPlusPolicyServiceImpl
implements DataPlusPolicyService {
    @Autowired
    private PolicyCrudService policyCrudService;
    @Autowired
    private PolicyHandleService policyHandleService;
    @Autowired
    private DataPlusPolicyCrudService dataPlusPolicyCrudService;
    @Autowired
    private DataPlusStatementCrudService dataPlusStatementCrudService;
    @Autowired
    private DataPlusOperationUnitCrudService dataPlusOperationUnitCrudService;
    @Autowired
    private PolicyConditionValueCrudService policyConditionValueCrudService;
    @Autowired
    private PolicyResourceCrudService policyResourceCrudService;
    @Autowired
    private DataPlusPolicyRepository dataPlusPolicyRepository;

    @Override
    @Transactional
    public void saveAction(long tenantSid, long sysSid, String type, long targetSid, List<ActionPlusPermission> actionPermission) {
        if (actionPermission == null) {
            return;
        }
        Policy policy = this.policyHandleService.savePolicy(tenantSid, sysSid, targetSid, type);
        List<Long> actionSids = actionPermission.stream().map(ActionPlusPermission::getActionSid).collect(Collectors.toList());
        this.policyCrudService.updatePolicy(policy.getSid(), policy.getTenantSid(), StatementInfo.addAllowActionSids(policy.getStatementValue(), actionSids));
        for (ActionPlusPermission item : actionPermission) {
            TargetPolicy targetPolicy = item.toTargetPolicy();
            targetPolicy.setTenantSid(policy.getTenantSid());
            targetPolicy.setType(type);
            targetPolicy.setSysSid(sysSid);
            targetPolicy.setTargetSid(targetSid);
            this.policyHandleService.saveConditionValue(policy.getSid(), targetPolicy);
        }
        ArrayList<PolicyResource> policyResources = new ArrayList<PolicyResource>();
        for (ActionPlusPermission item : actionPermission) {
            if (this.policyResourceCrudService.existsByPolicySidAndActionSid(policy.getSid(), item.getActionSid())) continue;
            PolicyResource policyResource = new PolicyResource();
            policyResource.setPolicySid(policy.getSid());
            policyResource.setActionSid(item.getActionSid());
            policyResource.setResourceId(item.getResourceId());
            policyResource.setResourceType(item.getResourceType());
            policyResources.add(policyResource);
        }
        this.policyResourceCrudService.insertAll(policyResources);
    }

    @Override
    @Transactional
    public void saveCondition(long tenantSid, String type, long targetSid, List<ResourcePermission> resourcePermission) {
        if (resourcePermission == null) {
            return;
        }
        List<String> resourceIds = resourcePermission.stream().map(ResourcePermission::getResourceId).collect(Collectors.toList());
        List<DataPlusPolicy> dbDataPlusPolicies = this.dataPlusPolicyRepository.findByTenantSidAndTypeAndTargetSidAndResourceIdIn(tenantSid, type, targetSid, resourceIds);
        Map<String, DataPlusPolicy> dataPlusPolicyMap = dbDataPlusPolicies.stream().collect(Collectors.toMap(DataPlusPolicy::getResourceId, a -> a, (k1, k2) -> k1));
        ArrayList<DataPlusPolicy> inserts = new ArrayList<DataPlusPolicy>();
        ArrayList<DataPlusPolicy> updates = new ArrayList<DataPlusPolicy>();
        for (ResourcePermission item : resourcePermission) {
            DataPlusPolicy dbDataPlusPolicy = dataPlusPolicyMap.get(item.getResourceId());
            if (dataPlusPolicyMap.containsKey(item.getResourceId())) {
                dbDataPlusPolicy.setConditions(JsonUtils.objToJson(item.getConditionValue()));
                dbDataPlusPolicy.setResourceType(item.getResourceType());
                updates.add(dbDataPlusPolicy);
                continue;
            }
            DataPlusPolicy dataPlusPolicy = new DataPlusPolicy();
            dataPlusPolicy.setSid(SnowFlake.getInstance().newId());
            dataPlusPolicy.setTenantSid(tenantSid);
            dataPlusPolicy.setType(type);
            dataPlusPolicy.setTargetSid(targetSid);
            dataPlusPolicy.setResourceId(item.getResourceId());
            dataPlusPolicy.setResourceType(item.getResourceType());
            dataPlusPolicy.setConditions(JsonUtils.objToJson(item.getConditionValue()));
            inserts.add(dataPlusPolicy);
        }
        this.dataPlusPolicyCrudService.insertAll(inserts);
        this.dataPlusPolicyCrudService.updateAll(updates);
    }

    @Override
    @Transactional
    public void saveDataPlus(long tenantSid, String type, long targetSid, List<DataPlusPermission> dataPermission) {
        if (dataPermission == null) {
            return;
        }
        List<String> resourceIds = dataPermission.stream().map(DataPlusPermission::getResourceId).collect(Collectors.toList());
        List<DataPlusPolicy> dbDataPlusPolicies = this.dataPlusPolicyRepository.findByTenantSidAndTypeAndTargetSidAndResourceIdIn(tenantSid, type, targetSid, resourceIds);
        List<Long> dataPlusPolicySids = dbDataPlusPolicies.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        Map<String, Long> dataPlusPolicySidMap = dbDataPlusPolicies.stream().collect(Collectors.toMap(DataPlusPolicy::getResourceId, BaseEntity::getSid));
        ArrayList<DataPlusPolicy> dataPlusPolicies = new ArrayList<DataPlusPolicy>();
        ArrayList<DataPlusStatement> statements = new ArrayList<DataPlusStatement>();
        ArrayList operationUnits = new ArrayList();
        for (DataPlusPermission item : dataPermission) {
            Long dataPlusPolicySid = dataPlusPolicySidMap.getOrDefault(item.getResourceId(), SnowFlake.getInstance().newId());
            if (!dataPlusPolicySidMap.containsKey(item.getResourceId())) {
                DataPlusPolicy dataPlusPolicy = new DataPlusPolicy();
                dataPlusPolicy.setSid(dataPlusPolicySid);
                dataPlusPolicy.setTenantSid(tenantSid);
                dataPlusPolicy.setType(type);
                dataPlusPolicy.setTargetSid(targetSid);
                dataPlusPolicy.setResourceId(item.getResourceId());
                dataPlusPolicies.add(dataPlusPolicy);
            }
            if (!CollectionUtils.isEmpty(item.getDeptData())) {
                DataPlusStatement statement1 = new DataPlusStatement();
                statement1.setTenantSid(tenantSid);
                statement1.setPolicySid(dataPlusPolicySid);
                statement1.setType(DataPlusTypeEnum.DEPT_DATA.name());
                statement1.setValue(String.join((CharSequence)",", item.getDeptData()));
                statements.add(statement1);
            }
            if (!CollectionUtils.isEmpty(item.getDataFilters())) {
                item.getDataFilters().forEach(it -> {
                    DataPlusStatement statement2 = new DataPlusStatement();
                    statement2.setTenantSid(tenantSid);
                    statement2.setPolicySid(dataPlusPolicySid);
                    statement2.setType(DataPlusTypeEnum.DATA_FILTER.name());
                    statement2.setFilter(JsonUtils.objToJson((Object)it.getFilter()));
                    statement2.setValue(String.join((CharSequence)",", it.getOptions()));
                    statement2.setDescription(it.getDescription());
                    statement2.setErrorDescription(it.getErrorDescription());
                    statements.add(statement2);
                });
            }
            if (!CollectionUtils.isEmpty(item.getEditLimits())) {
                item.getEditLimits().forEach(it -> {
                    DataPlusStatement statement3 = new DataPlusStatement();
                    statement3.setTenantSid(tenantSid);
                    statement3.setPolicySid(dataPlusPolicySid);
                    statement3.setType(DataPlusTypeEnum.EDIT_LIMIT.name());
                    statement3.setFilter(JsonUtils.objToJson((Object)it.getFilter()));
                    statement3.setValue(it.getField());
                    statement3.setDescription(it.getDescription());
                    statement3.setErrorDescription(it.getErrorDescription());
                    statements.add(statement3);
                });
            }
            if (!CollectionUtils.isEmpty(item.getFieldFilters())) {
                DataPlusStatement statement4 = new DataPlusStatement();
                statement4.setTenantSid(tenantSid);
                statement4.setPolicySid(dataPlusPolicySid);
                statement4.setType(DataPlusTypeEnum.FIELD_FILTER.name());
                statement4.setFilter(JsonUtils.objToJson(item.getFieldFilters()));
                statements.add(statement4);
            }
            if (CollectionUtils.isEmpty(item.getOperationUnits())) continue;
            item.getOperationUnits().forEach(it -> {
                DataPlusOperationUnit operationUnit = it.toEntity();
                operationUnit.setTenantSid(tenantSid);
                operationUnit.setPolicySid(dataPlusPolicySid);
                operationUnit.setType(OperationUnitTargetEnum.POLICY.name());
                operationUnits.add(operationUnit);
            });
        }
        this.dataPlusPolicyCrudService.batchDel(dataPlusPolicySids);
        this.dataPlusPolicyCrudService.insertAll(dataPlusPolicies);
        this.dataPlusStatementCrudService.insertAll(statements);
        this.dataPlusOperationUnitCrudService.insertAll(operationUnits);
    }

    @Override
    @Transactional
    public void delete(long tenantSid, long sysSid, String type, long targetSid, long actionSid) {
        Policy policy = this.policyCrudService.findPolicy(tenantSid, sysSid, targetSid, type);
        String statementValue = StatementInfo.delAllowActionSid(policy.getStatementValue(), actionSid);
        this.policyCrudService.updatePolicy(policy.getSid(), policy.getTenantSid(), statementValue);
        this.policyConditionValueCrudService.deleteByPolicySidAndActionSid(policy.getSid(), actionSid);
        PolicyResource policyResource = this.policyResourceCrudService.findByPolicySidAndActionSid(policy.getSid(), actionSid);
        if (policyResource != null) {
            this.policyResourceCrudService.deleteByPolicySidAndActionSid(policy.getSid(), actionSid);
            List<ResourceCondition> actions = this.dataPlusPolicyCrudService.findActionByResourceId(tenantSid, type, targetSid, policyResource.getResourceId());
            if (actions.stream().noneMatch(p -> p.getActionSid() != actionSid)) {
                this.dataPlusPolicyCrudService.batchDel(tenantSid, type, targetSid, Collections.singletonList(policyResource.getResourceId()));
            }
        }
    }
}

