/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.datapolicy.impl;

import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionDataVO;
import com.digiwin.dap.middleware.iam.domain.policy.CopyPermissionVO;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnOrg;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnRole;
import com.digiwin.dap.middleware.iam.entity.DataStatement;
import com.digiwin.dap.middleware.iam.mapper.DataPolicyMapper;
import com.digiwin.dap.middleware.iam.mapper.DataStatementMapper;
import com.digiwin.dap.middleware.iam.service.datapolicy.CopyDataPolicyService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyOnOrgCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyOnRoleCrudService;
import com.digiwin.dap.middleware.util.SnowFlake;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CopyDataPolicyServiceImpl
implements CopyDataPolicyService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DataPolicyMapper dataPolicyMapper;
    @Autowired
    private DataPolicyCrudService dataPolicyCrudService;
    @Autowired
    private DataPolicyOnOrgCrudService dataPolicyOnOrgCrudService;
    @Autowired
    private DataPolicyOnRoleCrudService dataPolicyOnRoleCrudService;
    @Autowired
    private DataStatementMapper dataStatementMapper;

    @Override
    public void copyDataPolicy(CopyPermissionVO copyPermissionVO, long tenantSid) {
        List<DataPolicy> sourceDataPolicy;
        List<CopyPermissionDataVO> copyPermissionDataVOS = copyPermissionVO.getTargets();
        ArrayList<Long> targetOrgSids = new ArrayList<Long>();
        ArrayList<Long> targetRoleSids = new ArrayList<Long>();
        for (CopyPermissionDataVO targetCopyPermissionDataVO : copyPermissionDataVOS) {
            if ("org".equals(targetCopyPermissionDataVO.getType())) {
                targetOrgSids.add(targetCopyPermissionDataVO.getSid());
            }
            if (!"role".equals(targetCopyPermissionDataVO.getType())) continue;
            targetRoleSids.add(targetCopyPermissionDataVO.getSid());
        }
        CopyPermissionDataVO sourceCopyPermissionDataVO = copyPermissionVO.getSource();
        String sourceType = sourceCopyPermissionDataVO.getType();
        ArrayList<DataPolicy> sourceDataPolicyList = new ArrayList<DataPolicy>();
        if ("org".equals(sourceType)) {
            targetOrgSids.remove(sourceCopyPermissionDataVO.getSid());
            sourceDataPolicy = this.dataPolicyMapper.findDataPolicyByOrg(sourceCopyPermissionDataVO.getSid());
            sourceDataPolicyList.addAll(sourceDataPolicy);
        }
        if ("role".equals(sourceType)) {
            targetRoleSids.remove(sourceCopyPermissionDataVO.getSid());
            sourceDataPolicy = this.dataPolicyMapper.findDataPolicyByRole(sourceCopyPermissionDataVO.getSid());
            sourceDataPolicyList.addAll(sourceDataPolicy);
        }
        if (targetOrgSids.size() > 0) {
            this.dataPolicyMapper.deleteDataPolicyByOrg(targetOrgSids);
            this.dataPolicyMapper.deleteDataPolicyOnOrg(targetOrgSids);
            this.dataPolicyMapper.deleteDataStatementByOrg(targetOrgSids);
        }
        if (targetRoleSids.size() > 0) {
            this.dataPolicyMapper.deleteDataPolicyByRole(targetRoleSids);
            this.dataPolicyMapper.deleteDataPolicyOnRole(targetRoleSids);
            this.dataPolicyMapper.deleteDataStatementByRole(targetRoleSids);
        }
        for (DataPolicy sourceDataPolicy2 : sourceDataPolicyList) {
            long dataPolicySid = 0L;
            for (Long targetOrgSid : targetOrgSids) {
                dataPolicySid = this.addDataPolicy(sourceDataPolicy2);
                DataPolicyOnOrg dataPolicyOnOrg = new DataPolicyOnOrg();
                dataPolicyOnOrg.setOrgSid(targetOrgSid);
                dataPolicyOnOrg.setPolicySid(dataPolicySid);
                this.dataPolicyOnOrgCrudService.create(dataPolicyOnOrg);
                this.copyDataStatement(sourceDataPolicy2, dataPolicySid);
            }
            for (Long targetRoleSid : targetRoleSids) {
                dataPolicySid = this.addDataPolicy(sourceDataPolicy2);
                DataPolicyOnRole dataPolicyOnRole = new DataPolicyOnRole();
                dataPolicyOnRole.setRoleSid(targetRoleSid);
                dataPolicyOnRole.setPolicySid(dataPolicySid);
                this.dataPolicyOnRoleCrudService.create(dataPolicyOnRole);
                this.copyDataStatement(sourceDataPolicy2, dataPolicySid);
            }
        }
    }

    private void copyDataStatement(DataPolicy sourceDataPolicy, long dataPolicySid) {
        List<DataStatement> dataStatementList = this.dataStatementMapper.searchDataStatementByPolicySid(sourceDataPolicy.getSid());
        if (CollectionUtils.isEmpty(dataStatementList)) {
            return;
        }
        dataStatementList.forEach(dataStatement -> {
            dataStatement.setSid(SnowFlake.getInstance().newId());
            dataStatement.setPolicySid(dataPolicySid);
        });
        this.dataStatementMapper.batchInsertDataStatement(dataStatementList);
    }

    private long addDataPolicy(DataPolicy sourceDataPolicy) {
        String policyId = UUID.randomUUID().toString();
        DataPolicy dataPolicy = new DataPolicy();
        dataPolicy.setTenantSid(sourceDataPolicy.getTenantSid());
        dataPolicy.setId(policyId);
        dataPolicy.setName(policyId);
        dataPolicy.setSysSid(sourceDataPolicy.getSysSid());
        dataPolicy.setEffectiveTime(sourceDataPolicy.getEffectiveTime());
        dataPolicy.setExpiredTime(sourceDataPolicy.getExpiredTime());
        return this.dataPolicyCrudService.create((BaseEntity)dataPolicy);
    }
}

