/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.datapolicy.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.datapolicy.Item;
import com.digiwin.dap.middleware.iam.domain.datapolicy.SchemaFieldVO;
import com.digiwin.dap.middleware.iam.domain.datapolicy.Table;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionDataDTO;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchema;
import com.digiwin.dap.middleware.iam.entity.DataPolicySchemaField;
import com.digiwin.dap.middleware.iam.mapper.DataPolicySchemaMapper;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaFieldRepository;
import com.digiwin.dap.middleware.iam.repository.DataPolicySchemaRepository;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicySchemaService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.support.remote.domain.DataPermissionFilterable;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DataPolicySchemaServiceImpl
implements DataPolicySchemaService {
    private static final Logger logger = LoggerFactory.getLogger(DataPolicySchemaServiceImpl.class);
    @Autowired
    private DataPolicySchemaMapper dataPolicySchemaMapper;
    @Autowired
    private DataPolicyService dataPolicyService;
    @Autowired
    private DataPolicySchemaRepository dataPolicySchemaRepository;
    @Autowired
    private DataPolicySchemaFieldRepository dataPolicySchemaFieldRepository;

    @Override
    public List<Table> getSchemas(String schemaActionId) {
        String language = LocaleContextHolder.getLocale().toLanguageTag();
        List<Table> fields = this.dataPolicySchemaMapper.getSchemas(schemaActionId);
        fields.forEach(p -> {
            if ("zh-TW".equals(language)) {
                p.setName(p.getNameTW());
                p.getFields().forEach(f -> f.setName(f.getNameTW()));
            } else if ("en-US".equals(language)) {
                p.setName(p.getNameUS());
                p.getFields().forEach(f -> f.setName(f.getNameUS()));
            }
        });
        return fields;
    }

    @Override
    public List<DataPermissionFilterable> getAppsByActionId(String actionId, String tableId, String id, String sysId, String moduleId) {
        String values = this.dataPolicySchemaMapper.getAppsByActionId(actionId, tableId, id);
        List<Item> items = this.getValuesByJson(values);
        long tenantSid = UserUtils.getTenantSid();
        ArrayList<DataPermissionFilterable> filterd = new ArrayList<DataPermissionFilterable>(items);
        return this.dataPolicyService.getActionData(tenantSid, UserUtils.getUserSid(), filterd, sysId, moduleId, actionId);
    }

    private List<Item> getValuesByJson(String values) {
        try {
            String language = LocaleContextHolder.getLocale().toLanguageTag();
            Map object = (Map)JsonUtils.createObjectMapper().readValue(values, (TypeReference)new TypeReference<Map<String, List<Item>>>(){});
            return object.getOrDefault(language, Collections.emptyList());
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u5b57\u6bb5\u503c\u5931\u8d25\u3002\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            return Collections.emptyList();
        }
    }

    @Override
    public SchemaFieldVO getSchemaField(String actionId, String tableId, String fieldId) {
        SchemaFieldVO schemaField = this.dataPolicySchemaMapper.getSchemaField(actionId, tableId, fieldId);
        if (schemaField == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST_SCHEMA, new Object[]{actionId, fieldId});
        }
        return schemaField;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDatas(List<PermissionDataDTO> datas) {
        datas.forEach(d -> {
            DataPolicySchema schema = this.dataPolicySchemaRepository.findByActionIdAndTableId(d.getActionId(), d.getTableId());
            if (null == schema) {
                schema = new DataPolicySchema();
                schema.setSid(SnowFlake.getInstance().newId());
                schema.setTableId(d.getTableId());
                schema.setActionId(d.getActionId());
                schema.setTableName(d.getTableName());
                schema.setTableNameTW(d.getTableNameTW());
                schema.setTableNameUS(d.getTableNameUS());
                this.dataPolicySchemaRepository.save((Object)schema);
            }
            for (DataPolicySchemaField f : d.getFields()) {
                f.setSchemaSid(schema.getSid());
                this.dataPolicySchemaFieldRepository.save((Object)f);
            }
        });
    }
}

