/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.datapolicy.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.app.ActionVO;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataPolicyTargetVO;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataPolicyVO;
import com.digiwin.dap.middleware.iam.domain.datapolicy.DataTypeEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.PolicyIdentifierEnum;
import com.digiwin.dap.middleware.iam.domain.datapolicy.RowFilter;
import com.digiwin.dap.middleware.iam.domain.permission.ColPermission;
import com.digiwin.dap.middleware.iam.domain.permission.DataPermission;
import com.digiwin.dap.middleware.iam.domain.permission.PermissionDataDTO;
import com.digiwin.dap.middleware.iam.domain.permission.v2.TargetType;
import com.digiwin.dap.middleware.iam.domain.policy.v2.TargetAction;
import com.digiwin.dap.middleware.iam.domain.role.RoleInfo;
import com.digiwin.dap.middleware.iam.entity.Action;
import com.digiwin.dap.middleware.iam.entity.DataPolicy;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnOrg;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnRole;
import com.digiwin.dap.middleware.iam.entity.DataPolicyOnUser;
import com.digiwin.dap.middleware.iam.entity.DataStatement;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.ActionMapper;
import com.digiwin.dap.middleware.iam.mapper.DataPolicyMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.service.app.ActionCrudService;
import com.digiwin.dap.middleware.iam.service.app.ActionService;
import com.digiwin.dap.middleware.iam.service.app.ModuleCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyOnOrgCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyOnRoleCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyOnUserCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataPolicyService;
import com.digiwin.dap.middleware.iam.service.datapolicy.DataStatementCrudService;
import com.digiwin.dap.middleware.iam.service.datapolicy.IdentifierAnalyzeService;
import com.digiwin.dap.middleware.iam.service.permission.AuthService;
import com.digiwin.dap.middleware.iam.service.permission.DataPolicyCalcService;
import com.digiwin.dap.middleware.iam.service.sys.SysCrudService;
import com.digiwin.dap.middleware.iam.support.remote.domain.DataPermissionFilterable;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DataPolicyServiceImpl
implements DataPolicyService {
    private static final Logger LOGGGER = LoggerFactory.getLogger(DataPolicyServiceImpl.class);
    @Autowired
    private DataPolicyMapper dataPolicyMapper;
    @Autowired
    private DataPolicyCrudService dataPolicyCrudService;
    @Autowired
    private DataStatementCrudService dataStatementCrudService;
    @Autowired
    private DataPolicyOnOrgCrudService dataPolicyOnOrgCrudService;
    @Autowired
    private DataPolicyOnRoleCrudService dataPolicyOnRoleCrudService;
    @Autowired
    private DataPolicyOnUserCrudService dataPolicyOnUserCrudService;
    @Autowired
    private SysCrudService sysCrudService;
    @Autowired
    private ModuleCrudService moduleCrudService;
    @Autowired
    private ActionCrudService actionCrudService;
    @Autowired
    private AuthService authService;
    @Autowired
    private ActionService actionService;
    @Autowired
    private List<IdentifierAnalyzeService> identifierAnalyzeServices;
    @Autowired
    private DataPolicyCalcService dataPolicyCalcService;
    @Autowired
    private UserMapper userMapper;
    @Autowired
    private ActionMapper actionMapper;

    @Override
    public void updateDataPolicy(long tenantSid, DataPolicyVO body) {
        DataPolicy dataPolicy;
        Action before = (Action)this.actionCrudService.findBySid(body.getActionSid());
        if (before.getId().equals("boss-notifier-management")) {
            Action replacement = (Action)this.actionCrudService.findByUnionKey(new Object[]{"boss-message-center", before.getModuleSid(), 0});
            Optional.ofNullable(replacement).ifPresent(a -> body.setActionSid(a.getSid()));
        }
        if ((dataPolicy = this.getDataPolicy(tenantSid, body.getType(), body.getTargetSid(), body.getSysSid())) == null) {
            String policyId = UUID.randomUUID().toString();
            dataPolicy = new DataPolicy();
            dataPolicy.setId(policyId);
            dataPolicy.setName(policyId);
            dataPolicy.setTenantSid(tenantSid);
            dataPolicy.setSysSid(body.getSysSid());
            this.dataPolicyCrudService.create((BaseEntity)dataPolicy);
        }
        this.addDataPolicyToTarget(body.getType(), body.getTargetSid(), dataPolicy.getSid());
        DataStatement dataStatement = (DataStatement)this.dataStatementCrudService.findByUnionKey(new Object[]{dataPolicy.getSid(), body.getActionSid()});
        if (this.emptyPermission(body)) {
            if (dataStatement != null) {
                this.dataStatementCrudService.deleteById(dataStatement.getSid());
            }
            return;
        }
        this.alterRowPermissionStructure(body);
        if (dataStatement == null) {
            dataStatement = new DataStatement();
            dataStatement.setPolicySid(dataPolicy.getSid());
            dataStatement.setActionSid(body.getActionSid());
            dataStatement.setFilter(body.getRowPermissions());
            dataStatement.setInclude(body.getColPermission());
            dataStatement.setEffect("allow");
            this.dataStatementCrudService.create(dataStatement);
        } else {
            dataStatement.setFilter(body.getRowPermissions());
            dataStatement.setInclude(body.getColPermission());
            dataStatement.setEffect("allow");
            this.dataStatementCrudService.update(dataStatement);
        }
    }

    private boolean emptyPermission(DataPolicyVO body) {
        return StringUtils.isEmpty((Object)body.getColPermission()) && StringUtils.isEmpty((Object)body.getRowPermission()) && StringUtils.isEmpty((Object)body.getRowPermissions()) || !StringUtils.isEmpty((Object)body.getColPermission()) && body.getColPermission().length() < 3 || !StringUtils.isEmpty((Object)body.getRowPermission()) && body.getRowPermission().length() < 3 || !StringUtils.isEmpty((Object)body.getRowPermissions()) && body.getRowPermissions().length() < 3;
    }

    private void alterRowPermissionStructure(DataPolicyVO body) {
        boolean enableMultiRow = false;
        Sys sys = (Sys)this.sysCrudService.findBySid(body.getSysSid());
        if (sys != null) {
            enableMultiRow = sys.isEnableMultiRow();
        }
        body.markRowPermissionTableName(enableMultiRow);
    }

    @Override
    public DataPolicy getDataPolicy(long tenantSid, String type, long targetSid, long sysSid) {
        DataPolicy dataPolicy = null;
        if ("org".equals(type)) {
            dataPolicy = this.dataPolicyMapper.findDataPolicyByOrgAndSys(tenantSid, targetSid, sysSid);
        } else if ("role".equals(type)) {
            dataPolicy = this.dataPolicyMapper.findDataPolicyByRoleAndSys(tenantSid, targetSid, sysSid);
        } else if ("user".equals(type)) {
            dataPolicy = this.dataPolicyMapper.findDataPolicyByUserAndSys(tenantSid, targetSid, sysSid);
        }
        return dataPolicy;
    }

    @Override
    public DataPermission getDataPolicy(long tenantSid, String type, long targetSid, long sysSid, long actionSid, Boolean parse) {
        Action replacement;
        Action action = (Action)this.actionCrudService.findBySid(actionSid);
        if (action.getId().equals("boss-notifier-management") && (replacement = (Action)this.actionCrudService.findByUnionKey(new Object[]{"boss-message-center", action.getModuleSid(), 0})) != null) {
            actionSid = replacement.getSid();
        }
        DataPermission result = DataPermission.normal();
        List<TargetAction> targets = this.dataPolicyCalcService.getDataPolicy(tenantSid, type, targetSid, sysSid, actionSid);
        if (targets.isEmpty()) {
            return result;
        }
        if (targets.size() == 1) {
            TargetAction targetAction = targets.get(0);
            if (parse.booleanValue() && TargetType.user.name().equals(type)) {
                targetAction.setRow(this.analyzeValue(targetSid, targets.get(0).getRow()));
            }
            if (targetAction.isOldRowData()) {
                result.setRowPermission(targetAction.getRowDataOld());
                result.setRowPermissions(Collections.singletonList(result.getRowPermission()));
            } else {
                Map<String, RowFilter> rowData = targetAction.getRowData();
                result.setRowPermissions(new ArrayList<RowFilter>(rowData.values()));
                if (!rowData.isEmpty()) {
                    result.setRowPermission(rowData.values().iterator().next());
                }
            }
            List<ColPermission> colData = targetAction.getColData();
            result.setColEnabled(!colData.isEmpty());
            result.setColPermission(colData);
        } else {
            if (targets.get(0).isOldRowData()) {
                ArrayList<RowFilter> filters = new ArrayList<RowFilter>();
                targets.forEach(o -> {
                    if (parse.booleanValue() && TargetType.user.name().equals(type)) {
                        o.setRow(this.analyzeValue(o.getTargetSid(), o.getRow()));
                    }
                    if (o.getRowDataOld().isNull()) {
                        filters.add(o.getRowDataOld());
                    }
                });
                if (filters.size() == 1) {
                    result.setRowPermission((RowFilter)filters.get(0));
                } else if (filters.size() > 1) {
                    RowFilter values = RowFilter.buildRowFilter4OR(filters);
                    result.setRowPermission(values);
                    result.setRowPermissions(Collections.singletonList(values));
                }
            } else {
                this.mergeRow(result, targets, parse);
            }
            this.mergeCol(result, targets);
        }
        return result;
    }

    private String analyzeValue(Long targetSid, String rowValue) {
        List empIds;
        List userIds;
        List deptIds;
        Object object;
        User user = this.userMapper.findBySid(targetSid);
        if (Objects.isNull((Object)user)) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        String userId = user.getId();
        if (ObjectUtils.isEmpty((Object)userId)) {
            LOGGGER.error("[\u6570\u636e\u6743\u9650]\u89e3\u6790\u5f02\u5e38\uff0c\u7528\u6237{}\u4e0d\u5b58\u5728", (Object)targetSid);
            return rowValue;
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.CURRENT_USER_ID.getCode()))) {
            userId = (String)this.analyzeCore(userId, PolicyIdentifierEnum.CURRENT_USER_ID.getCode());
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.CURRENT_USER_ID.getCode()), this.matchPrefix(userId));
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.CURRENT_EMP_ID.getCode()))) {
            String empId = (String)this.analyzeCore(userId, PolicyIdentifierEnum.CURRENT_EMP_ID.getCode());
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.CURRENT_EMP_ID.getCode()), this.matchPrefix(empId));
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.CURRENT_DEPT_IDS.getCode())) && Objects.nonNull(object = this.analyzeCore(userId, PolicyIdentifierEnum.CURRENT_DEPT_IDS.getCode()))) {
            deptIds = (List)object;
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.CURRENT_DEPT_IDS.getCode()), this.transferResult(deptIds));
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.CURRENT_DEPT_SUB_IDS.getCode())) && Objects.nonNull(object = this.analyzeCore(userId, PolicyIdentifierEnum.CURRENT_DEPT_SUB_IDS.getCode()))) {
            deptIds = (List)object;
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.CURRENT_DEPT_SUB_IDS.getCode()), this.transferResult(deptIds));
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_USER_ID.getCode())) && Objects.nonNull(object = this.analyzeCore(userId, PolicyIdentifierEnum.SUBORDINATE_USER_ID.getCode()))) {
            userIds = (List)object;
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_USER_ID.getCode()), this.transferResult(userIds));
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_EMP_ID.getCode())) && Objects.nonNull(object = this.analyzeCore(userId, PolicyIdentifierEnum.SUBORDINATE_EMP_ID.getCode()))) {
            empIds = (List)object;
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_EMP_ID.getCode()), this.transferResult(empIds));
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_SUB_USER_ID.getCode())) && Objects.nonNull(object = this.analyzeCore(userId, PolicyIdentifierEnum.SUBORDINATE_SUB_USER_ID.getCode()))) {
            userIds = (List)object;
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_SUB_USER_ID.getCode()), this.transferResult(userIds));
        }
        if (rowValue.contains(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_SUB_EMP_ID.getCode())) && Objects.nonNull(object = this.analyzeCore(userId, PolicyIdentifierEnum.SUBORDINATE_SUB_EMP_ID.getCode()))) {
            empIds = (List)object;
            rowValue = rowValue.replace(this.matchPrefix(PolicyIdentifierEnum.SUBORDINATE_SUB_EMP_ID.getCode()), this.transferResult(empIds));
        }
        return rowValue;
    }

    private Object analyzeCore(String userId, String type) {
        for (IdentifierAnalyzeService identifierAnalyzeService : this.identifierAnalyzeServices) {
            if (!identifierAnalyzeService.support(type).booleanValue()) continue;
            return identifierAnalyzeService.analyze(userId);
        }
        return null;
    }

    private String matchPrefix(String prefix) {
        return String.format("\"%s\"", prefix);
    }

    private String transferResult(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtils.objToJson(list).replace("[", "").replace("]", "");
    }

    private void mergeRow(DataPermission result, List<TargetAction> targets, Boolean parse) {
        HashMap<String, List> rowPermissionOfEachTable = new HashMap<String, List>();
        for (TargetAction target : targets) {
            if (parse.booleanValue()) {
                if (TargetType.user.name().equals(target.getTargetType())) {
                    target.setRow(this.analyzeValue(target.getTargetSid(), target.getRow()));
                }
            } else {
                target.setRow(target.getRow());
            }
            Map<String, RowFilter> aRowPermission = target.getRowData();
            for (Map.Entry<String, RowFilter> permissionEntry : aRowPermission.entrySet()) {
                rowPermissionOfEachTable.computeIfAbsent(permissionEntry.getKey(), a -> new ArrayList()).add(permissionEntry.getValue());
            }
        }
        if (rowPermissionOfEachTable.size() == 1 && rowPermissionOfEachTable.containsKey("default")) {
            RowFilter rowFilter = RowFilter.buildRowFilter4OR((List)rowPermissionOfEachTable.get("default"));
            result.setRowPermission(rowFilter);
            result.setRowPermissions(Collections.singletonList(rowFilter));
        } else {
            ArrayList<RowFilter> rowFilters = new ArrayList<RowFilter>();
            for (List value : rowPermissionOfEachTable.values()) {
                rowFilters.add(RowFilter.buildRowFilter4OR(value));
            }
            result.setRowPermission(new RowFilter());
            result.setRowPermissions(rowFilters);
        }
    }

    private void mergeCol(DataPermission result, List<TargetAction> targets) {
        ArrayList includes = new ArrayList();
        targets.forEach(o -> {
            List<ColPermission> colData = o.getColData();
            if (!colData.isEmpty()) {
                includes.add(colData);
            }
        });
        result.setColEnabled(!includes.isEmpty());
        if (includes.size() == 1) {
            result.setColPermission((List)includes.get(0));
        } else if (includes.size() > 1) {
            HashMap<String, ColPermission> mapTable = new HashMap<String, ColPermission>();
            for (List include : includes) {
                for (ColPermission col : include) {
                    if (mapTable.containsKey(col.getTable())) {
                        ColPermission existing = (ColPermission)mapTable.get(col.getTable());
                        HashSet<String> mergedFields = new HashSet<String>(existing.getFields());
                        mergedFields.addAll(col.getFields());
                        existing.setFields(new ArrayList<String>(mergedFields));
                        continue;
                    }
                    mapTable.put(col.getTable(), new ColPermission(col.getTable(), col.getType(), new ArrayList<String>(col.getFields())));
                }
            }
            result.setColPermission(new ArrayList<ColPermission>(mapTable.values()));
        }
    }

    private void addDataPolicyToTarget(String type, long targetSid, long dataPolicySid) {
        if ("user".equals(type) && !this.dataPolicyOnUserCrudService.existsByUnionKey(new Object[]{targetSid, dataPolicySid})) {
            DataPolicyOnUser dataPolicyOnUser = new DataPolicyOnUser();
            dataPolicyOnUser.setUserSid(targetSid);
            dataPolicyOnUser.setPolicySid(dataPolicySid);
            this.dataPolicyOnUserCrudService.create(dataPolicyOnUser);
        } else if ("role".equals(type) && !this.dataPolicyOnRoleCrudService.existsByUnionKey(new Object[]{targetSid, dataPolicySid})) {
            DataPolicyOnRole dataPolicyOnRole = new DataPolicyOnRole();
            dataPolicyOnRole.setRoleSid(targetSid);
            dataPolicyOnRole.setPolicySid(dataPolicySid);
            this.dataPolicyOnRoleCrudService.create(dataPolicyOnRole);
        } else if ("org".equals(type) && !this.dataPolicyOnOrgCrudService.existsByUnionKey(new Object[]{targetSid, dataPolicySid})) {
            DataPolicyOnOrg dataPolicyOnOrg = new DataPolicyOnOrg();
            dataPolicyOnOrg.setOrgSid(targetSid);
            dataPolicyOnOrg.setPolicySid(dataPolicySid);
            this.dataPolicyOnOrgCrudService.create(dataPolicyOnOrg);
        }
    }

    @Override
    public List<DataPermissionFilterable> getActionData(long tenantSid, long userSid, List<DataPermissionFilterable> items, String sysId, String moduleId, String actionId) {
        try {
            long sysSid = this.sysCrudService.getSidById(sysId);
            long moduleSid = this.moduleCrudService.getSidByUnionKey(new Object[]{moduleId, sysSid});
            long actionSid = this.actionCrudService.getSidByUnionKey(new Object[]{actionId, moduleSid, 0});
            DataPermission dataPermission = this.authService.getDataPermission(tenantSid, userSid, sysSid, actionSid);
            boolean superadmin = dataPermission.getSuperadmin();
            if (!superadmin) {
                ArrayList<String> lists = new ArrayList<String>();
                RowFilter rowMap = dataPermission.getRowPermission();
                String filterType = rowMap.getFilterType();
                if ("in".equals(filterType)) {
                    lists.addAll((List)rowMap.getFilterValue());
                } else if ("or".equals(filterType)) {
                    lists.addAll(rowMap.fetchAllValues());
                }
                return items.stream().filter(o -> o.hasDataPermission(lists)).collect(Collectors.toList());
            }
        }
        catch (Exception e) {
            LOGGGER.error("getActionData error, return emptyList", (Throwable)e);
            return Collections.emptyList();
        }
        return items;
    }

    @Override
    public void updateDataPolicyForDev(long tenantSid, PermissionDataDTO dataPolicyDTO) {
        List filterValues;
        RowFilter rowFilter;
        Map filterMap;
        DataStatement dataStatement;
        DataPolicy dataPolicy;
        List<Object> addRoles = new ArrayList();
        List<Object> deleteRoles = new ArrayList();
        if (CollectionUtils.isEmpty(dataPolicyDTO.getRoles()) && !CollectionUtils.isEmpty(dataPolicyDTO.getOldRoles())) {
            deleteRoles = dataPolicyDTO.getOldRoles();
        } else if (!CollectionUtils.isEmpty(dataPolicyDTO.getRoles()) && CollectionUtils.isEmpty(dataPolicyDTO.getOldRoles())) {
            addRoles = dataPolicyDTO.getRoles();
        } else {
            addRoles = dataPolicyDTO.getRoles().stream().filter(p -> !dataPolicyDTO.getOldRoles().stream().anyMatch(o -> p.getId().equals(o.getId()))).collect(Collectors.toList());
            deleteRoles = dataPolicyDTO.getOldRoles().stream().filter(p -> !dataPolicyDTO.getRoles().stream().anyMatch(o -> p.getId().equals(o.getId()))).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(addRoles) && CollectionUtils.isEmpty(deleteRoles)) {
            LOGGGER.warn("\u65e0\u65b0\u589e/\u5220\u9664\u7684\u89d2\u8272\uff0c\u65e0\u9700\u66f4\u65b0");
            return;
        }
        Sys sys = (Sys)this.sysCrudService.findById(dataPolicyDTO.getSysId());
        if (null == sys) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{dataPolicyDTO.getSysId()});
        }
        ActionVO actionVO = new ActionVO(0L, dataPolicyDTO.getActionId(), sys.getSid(), dataPolicyDTO.getSysId(), 0L, dataPolicyDTO.getModuleId(), 0L);
        Long actionSid = this.actionService.getAction(actionVO);
        if (!CollectionUtils.isEmpty(addRoles)) {
            List<DataPolicyTargetVO> addDataPolicies = this.dataPolicyMapper.findDataPolicyBySysInRoles(tenantSid, addRoles.stream().map(RoleInfo::getSid).collect(Collectors.toList()), sys.getSid());
            for (RoleInfo roleInfo : addRoles) {
                dataPolicy = addDataPolicies.stream().filter(p -> p.getTargetSid().longValue() == r.getSid()).findFirst().orElse(null);
                if (dataPolicy == null) {
                    String policyId = UUID.randomUUID().toString();
                    dataPolicy = new DataPolicy();
                    dataPolicy.setId(policyId);
                    dataPolicy.setName(policyId);
                    dataPolicy.setTenantSid(tenantSid);
                    dataPolicy.setSysSid(sys.getSid());
                    this.dataPolicyCrudService.create((BaseEntity)dataPolicy);
                }
                this.addDataPolicyToTarget("role", roleInfo.getSid(), dataPolicy.getSid());
                dataStatement = (DataStatement)this.dataStatementCrudService.findByUnionKey(new Object[]{dataPolicy.getSid(), actionSid});
                if (dataStatement == null) {
                    dataStatement = new DataStatement();
                    dataStatement.setPolicySid(dataPolicy.getSid());
                    dataStatement.setActionSid(actionSid);
                    List<String> filterValue = Collections.singletonList(dataPolicyDTO.getDevAppId());
                    List<String> filterValueName = Collections.singletonList(dataPolicyDTO.getDevAppName());
                    RowFilter rowFilter2 = new RowFilter(SnowFlake.getInstance().newId(), "in", "\u5c5e\u4e8e", "dev_app", "\u5e94\u7528\u7ba1\u7406", "devAppId", "\u5e94\u7528id", filterValue, filterValueName, DataTypeEnum.STRING.toString(), "1");
                    HashMap<String, RowFilter> defaultTable = new HashMap<String, RowFilter>();
                    defaultTable.put("default", rowFilter2);
                    dataStatement.setFilter(JsonUtils.objToJson(defaultTable));
                    dataStatement.setEffect("allow");
                    this.dataStatementCrudService.create(dataStatement);
                    continue;
                }
                try {
                    filterMap = (Map)JsonUtils.createObjectMapper().readValue(dataStatement.getFilter(), Map.class);
                    rowFilter = (RowFilter)JsonUtils.createObjectMapper().readValue(JsonUtils.objToJson(filterMap.get("default")), RowFilter.class);
                    if (rowFilter == null) {
                        rowFilter = (RowFilter)JsonUtils.createObjectMapper().readValue(dataStatement.getFilter(), RowFilter.class);
                    }
                    if (!(filterValues = (List)JsonUtils.createObjectMapper().readValue(JsonUtils.objToJson((Object)rowFilter.getFilterValue()), (TypeReference)new TypeReference<List<String>>(){})).contains(dataPolicyDTO.getDevAppId())) {
                        filterValues.add(dataPolicyDTO.getDevAppId());
                        rowFilter.getFilterValueName().add(dataPolicyDTO.getDevAppName());
                        rowFilter.setFilterValue(filterValues);
                        filterMap.put("default", rowFilter);
                        dataStatement.setFilter(JsonUtils.objToJson((Object)filterMap));
                        dataStatement.setEffect("allow");
                        this.dataStatementCrudService.update(dataStatement);
                        continue;
                    }
                    LOGGGER.warn("\u5f00\u53d1\u5546\u5e94\u7528{}\u5df2\u7ed1\u5b9a\u5230\u89d2\u8272{}\uff0c\u65e0\u9700\u91cd\u590d\u7ed1\u5b9a", (Object)dataPolicyDTO.getDevAppId(), (Object)roleInfo.getId());
                }
                catch (IOException e) {
                    LOGGGER.error("\u65b0\u589e\u5f00\u53d1\u5546\u5e94\u7528\u7ed1\u5b9a\u7684\u89d2\u8272,\u89e3\u6790\u6570\u636e\u6743\u9650\u5931\u8d25\uff0c{}", (Object)dataStatement.getFilter(), (Object)e);
                }
            }
        }
        if (!CollectionUtils.isEmpty(deleteRoles)) {
            List<DataPolicyTargetVO> deleteDataPolicies = this.dataPolicyMapper.findDataPolicyBySysInRoles(tenantSid, deleteRoles.stream().map(RoleInfo::getSid).collect(Collectors.toList()), sys.getSid());
            for (RoleInfo roleInfo : deleteRoles) {
                dataPolicy = deleteDataPolicies.stream().filter(p -> p.getTargetSid().longValue() == r.getSid()).findFirst().orElse(null);
                if (dataPolicy == null) break;
                dataStatement = (DataStatement)this.dataStatementCrudService.findByUnionKey(new Object[]{dataPolicy.getSid(), actionSid});
                if (dataStatement == null) continue;
                try {
                    filterMap = (Map)JsonUtils.createObjectMapper().readValue(dataStatement.getFilter(), Map.class);
                    rowFilter = (RowFilter)JsonUtils.createObjectMapper().readValue(JsonUtils.objToJson(filterMap.get("default")), RowFilter.class);
                    if (rowFilter == null) {
                        rowFilter = (RowFilter)JsonUtils.createObjectMapper().readValue(dataStatement.getFilter(), RowFilter.class);
                    }
                    filterValues = (List)JsonUtils.createObjectMapper().readValue(JsonUtils.objToJson((Object)rowFilter.getFilterValue()), (TypeReference)new TypeReference<List<String>>(){});
                    filterValues.remove(dataPolicyDTO.getDevAppId());
                    rowFilter.getFilterValueName().remove(dataPolicyDTO.getDevAppName());
                    rowFilter.setFilterValue(filterValues);
                    if (CollectionUtils.isEmpty((Collection)filterValues)) {
                        this.dataStatementCrudService.deleteByUnionKey(new Object[]{dataPolicy.getSid(), actionSid});
                        continue;
                    }
                    filterMap.put("default", rowFilter);
                    dataStatement.setFilter(JsonUtils.objToJson((Object)filterMap));
                    dataStatement.setEffect("allow");
                    this.dataStatementCrudService.update(dataStatement);
                }
                catch (IOException e) {
                    LOGGGER.error("\u5220\u9664\u5f00\u53d1\u5546\u5e94\u7528\u7ed1\u5b9a\u7684\u89d2\u8272\uff0c\u89e3\u6790\u6570\u636e\u6743\u9650\u5931\u8d25\uff0c{}", (Object)dataStatement.getFilter(), (Object)e);
                }
            }
        }
    }

    @Override
    @Transactional
    public void deleteSysDataPolicy(Long tenantSid, String type, Long targetSid, Long sysSid) {
        DataPolicy dataPolicy = this.getDataPolicy(tenantSid, type, targetSid, sysSid);
        if (Objects.isNull((Object)dataPolicy)) {
            return;
        }
        List<ActionQueryResultVO> actionQueryResultVOS = this.actionMapper.findActionBySys(tenantSid, sysSid);
        if (CollectionUtils.isEmpty(actionQueryResultVOS)) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST);
        }
        List actionSidList = actionQueryResultVOS.stream().map(ActionQueryResultVO::getSid).collect(Collectors.toList());
        for (Long actionSid : actionSidList) {
            this.dataStatementCrudService.deleteByUnionKey(new Object[]{dataPolicy.getSid(), actionSid});
        }
    }
}

