/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.datapolicy.impl;

import com.digiwin.dap.middleware.iam.domain.datapolicy.PolicyIdentifierEnum;
import com.digiwin.dap.middleware.iam.service.datapolicy.IdentifierAnalyzeService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="currentDeptIds")
@Order(value=2)
public class IdentifierAnalyzeForCurrentDeptsServiceImpl
implements IdentifierAnalyzeService<List<String>> {
    private static final Logger log = LoggerFactory.getLogger(IdentifierAnalyzeForCurrentDeptsServiceImpl.class);
    @Autowired
    private RemoteEocService remoteEocService;

    @Override
    public Boolean support(String type) {
        return PolicyIdentifierEnum.CURRENT_DEPT_IDS.getCode().equalsIgnoreCase(type);
    }

    @Override
    public List<String> analyze(String userId) {
        List<String> depts = this.remoteEocService.getDirectDepts(userId, 0);
        if (CollectionUtils.isEmpty(depts)) {
            log.error("\u7528\u6237{}\u65e0\u6240\u5c5e\u7684\u90e8\u95e8\u4fe1\u606f", (Object)UserUtils.getUserId());
            return depts;
        }
        return depts;
    }
}

