/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.datapolicy.impl;

import com.digiwin.dap.middleware.iam.domain.datapolicy.PolicyIdentifierEnum;
import com.digiwin.dap.middleware.iam.service.datapolicy.IdentifierAnalyzeService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.EmpInfoVO;
import com.digiwin.dap.middleware.util.UserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service(value="currentUserEmpService")
@Order(value=1)
public class IdentifierAnalyzeForCurrentEmpServiceImpl
implements IdentifierAnalyzeService<String> {
    private static final Logger log = LoggerFactory.getLogger(IdentifierAnalyzeForCurrentEmpServiceImpl.class);
    @Autowired
    private RemoteEocService remoteEocService;

    @Override
    public Boolean support(String type) {
        return PolicyIdentifierEnum.CURRENT_EMP_ID.getCode().equalsIgnoreCase(type);
    }

    @Override
    public String analyze(String userId) {
        EmpInfoVO emp = this.remoteEocService.getEmpByUserId(userId, true);
        if (null == emp) {
            log.error("\u7528\u6237{}\u672a\u7ed1\u5b9a\u5458\u5de5", (Object)UserUtils.getUserId());
            return "";
        }
        return emp.getId();
    }
}

