/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.datapolicy.impl;

import com.digiwin.dap.middleware.iam.domain.datapolicy.PolicyIdentifierEnum;
import com.digiwin.dap.middleware.iam.service.datapolicy.IdentifierAnalyzeService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.message.EmpUserVO;
import com.digiwin.dap.middleware.util.StringUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="subordinateUserId")
@Order(value=4)
public class IdentifierAnalyzeForSubordinateUserIdServiceImpl
implements IdentifierAnalyzeService<List<String>> {
    private static final Logger log = LoggerFactory.getLogger(IdentifierAnalyzeForSubordinateUserIdServiceImpl.class);
    @Autowired
    private RemoteEocService remoteEocService;

    @Override
    public Boolean support(String type) {
        return PolicyIdentifierEnum.SUBORDINATE_USER_ID.getCode().equalsIgnoreCase(type);
    }

    @Override
    public List<String> analyze(String userId) {
        List<EmpUserVO> empUserVOS = this.remoteEocService.getSubordinateEmpInfos(userId, 0);
        if (CollectionUtils.isEmpty(empUserVOS)) {
            log.error("\u7528\u6237{}\u65e0\u4e0b\u5c5e\u5458\u5de5", (Object)UserUtils.getUserId());
            return new ArrayList<String>();
        }
        return empUserVOS.stream().filter(e -> !StringUtils.isEmpty((Object)e.getUserId())).map(EmpUserVO::getUserId).distinct().collect(Collectors.toList());
    }
}

