/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dev.app.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionPath;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevConditionQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.DevAction;
import com.digiwin.dap.middleware.iam.entity.DevModule;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.mapper.DevActionMapper;
import com.digiwin.dap.middleware.iam.mapper.DevConditionMapper;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionCrudService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionQueryService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleCrudService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevActionQueryServiceImpl
implements DevActionQueryService {
    @Autowired
    private DevActionCrudService devActionCrudService;
    @Autowired
    private DevModuleCrudService devModuleCrudService;
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private DevActionMapper devActionMapper;
    @Autowired
    private DevConditionMapper devConditionMapper;

    @Override
    public ActionPath getActionPath(long sid) {
        ActionPath actionPath = new ActionPath();
        DevAction devAction = (DevAction)this.devActionCrudService.findBySid(sid);
        if (devAction == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST, new Object[]{sid});
        }
        DevModule devModule = (DevModule)this.devModuleCrudService.findBySid(devAction.getDevModuleSid());
        if (devModule == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST_MODULE, new Object[]{devAction.getDevModuleSid()});
        }
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(devModule.getDevAppSid());
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST_APP, new Object[]{devModule.getDevAppSid()});
        }
        StringBuffer urnBuffer = new StringBuffer();
        urnBuffer.append(devAction.getNameCN());
        StringBuffer uriBuffer = new StringBuffer();
        uriBuffer.append(devAction.getId());
        if (devAction.getParentSid() != 0L) {
            this.buildParentAction(devAction.getParentSid(), urnBuffer, uriBuffer);
        }
        uriBuffer.insert(0, "drn:iam:app:" + devSys.getId() + ":" + devModule.getId() + ":");
        urnBuffer.insert(0, devSys.getNameCN() + ":" + devModule.getNameCN() + ":");
        actionPath.setActionUri(uriBuffer.toString());
        actionPath.setActionUrn(urnBuffer.toString());
        return actionPath;
    }

    @Override
    public DevActionQueryResultVO getAction(long actionSid) {
        DevActionQueryResultVO devActionQueryResultVO = this.devActionMapper.findDevActionQueryResultVOByDevActionSid(actionSid);
        if (devActionQueryResultVO == null) {
            throw new BusinessException("\u6ca1\u6709\u6b64\u884c\u4e3a" + actionSid);
        }
        List<DevConditionQueryResultVO> devConditionQueryResultVOS = this.devConditionMapper.findDevConditionByActionSid(actionSid);
        if (devConditionQueryResultVOS.size() > 0) {
            for (DevConditionQueryResultVO devConditionQueryResultVO : devConditionQueryResultVOS) {
                String typeParameter = devConditionQueryResultVO.getParameter();
                devConditionQueryResultVO.setTypeParameter((List)JsonUtils.jsonToObj((String)typeParameter, List.class));
            }
        }
        devActionQueryResultVO.setDevCondition(devConditionQueryResultVOS);
        return devActionQueryResultVO;
    }

    @Override
    public List<DevActionQueryResultVO> getDevAction(long devModuleSid) {
        return this.devActionMapper.findDevActionQueryResultVO(devModuleSid);
    }

    private void buildParentAction(long sid, StringBuffer urnBuffer, StringBuffer uriBuffer) {
        DevAction devAction;
        if (sid != 0L && (devAction = (DevAction)this.devActionCrudService.findBySid(sid)) != null) {
            urnBuffer.insert(0, devAction.getNameCN() + ":");
            uriBuffer.insert(0, devAction.getId() + ":");
            long parentSid = devAction.getParentSid();
            this.buildParentAction(parentSid, urnBuffer, uriBuffer);
        }
    }
}

