/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dev.app.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.app.ActionPath;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevConditionVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevModuleVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.entity.DevAction;
import com.digiwin.dap.middleware.iam.entity.DevCondition;
import com.digiwin.dap.middleware.iam.entity.DevModule;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.mapper.DevActionMapper;
import com.digiwin.dap.middleware.iam.mapper.DevConditionMapper;
import com.digiwin.dap.middleware.iam.mapper.DevModuleMapper;
import com.digiwin.dap.middleware.iam.repository.DevActionRepository;
import com.digiwin.dap.middleware.iam.repository.DevConditionRepository;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionCrudService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionQueryService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevConditionCrudService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleCrudService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DevActionServiceImpl
implements DevActionService {
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private DevActionCrudService devActionCrudService;
    @Autowired
    private DevModuleCrudService devModuleCrudService;
    @Autowired
    private DevConditionCrudService devConditionCrudService;
    @Autowired
    private DevActionQueryService devActionQueryService;
    @Autowired
    private DevConditionMapper devConditionMapper;
    @Autowired
    private DevActionRepository devActionRepository;
    @Autowired
    private DevConditionRepository devConditionRepository;
    @Autowired
    private OtherValidateService otherValidateService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private DevModuleMapper devModuleMapper;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private DevActionMapper devActionMapper;

    @Override
    public long addDevAction(DevActionVO devActionVO, long tenantSid) {
        String uri;
        this.otherValidateService.addDevActionCheck(devActionVO);
        DevAction oldDevAction = (DevAction)this.devActionCrudService.findByUnionKey(new Object[]{devActionVO.getId(), devActionVO.getModuleSid(), tenantSid});
        if (oldDevAction != null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_HAS_EXIST, new Object[]{devActionVO.getId()});
        }
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(devActionVO.getAppSid());
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{devActionVO.getAppSid()});
        }
        DevModule devModule = (DevModule)this.devModuleCrudService.findBySid(devActionVO.getModuleSid());
        if (devModule == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{devActionVO.getModuleSid()});
        }
        if (devModule.getDevAppSid() != devSys.getSid()) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST_APP, new Object[]{devModule.getDevAppSid()});
        }
        if (devActionVO.getParentSid() != 0L) {
            ActionPath actionPath = this.devActionQueryService.getActionPath(devActionVO.getParentSid());
            uri = actionPath.getActionUri() + ":" + devActionVO.getId();
        } else {
            uri = "drn:iam:app:" + devSys.getId() + ":" + devModule.getId() + ":" + devActionVO.getId();
        }
        DevAction devAction = new DevAction();
        devAction.setSid(devActionVO.getSid() == null ? 0L : devActionVO.getSid());
        devAction.setId(devActionVO.getId());
        devAction.setUri(uri);
        devAction.setNameCN(devActionVO.getNameCN());
        devAction.setNameTW(devActionVO.getNameTW());
        devAction.setNameUS(devActionVO.getNameUS());
        devAction.setNameVN(devActionVO.getNameVN());
        devAction.setDevModuleSid(devActionVO.getModuleSid());
        devAction.setParentSid(devActionVO.getParentSid());
        devAction.setRemarks(devActionVO.getRemarks());
        devAction.setTenantSid(tenantSid);
        Long sid = this.devActionCrudService.create(devAction);
        List<DevConditionVO> conditionVOS = devActionVO.getConditions();
        for (DevConditionVO conditionVO : conditionVOS) {
            DevCondition devCondition = new DevCondition();
            devCondition.setKey(conditionVO.getKey());
            devCondition.setNameCN(conditionVO.getNameCN());
            devCondition.setNameTW(conditionVO.getNameTW());
            devCondition.setNameUS(conditionVO.getNameUS());
            devCondition.setNameVN(conditionVO.getNameVN());
            devCondition.setType(conditionVO.getType());
            devCondition.setTypeParameter(JsonUtils.objToJson(conditionVO.getTypeParameter()));
            devCondition.setDefaultValue(conditionVO.getDefaultValue());
            devCondition.setDevActionSid(sid);
            this.devConditionCrudService.create(devCondition);
        }
        return sid;
    }

    @Override
    public void updateDevAction(DevActionVO devActionVO, long tenantSid) {
        if (devActionVO == null) {
            throw new IllegalArgumentException("devActionRequestVO is null");
        }
        DevAction devAction = (DevAction)this.devActionCrudService.findBySid(devActionVO.getSid());
        if (devAction == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST, new Object[]{devActionVO.getSid()});
        }
        if (devActionVO.getParentSid() != 0L) {
            DevAction parentAction = (DevAction)this.devActionCrudService.findBySid(devActionVO.getParentSid());
            if (parentAction == null) {
                throw new BusinessException((ErrorHandler)I18nError.PARENT_ACTION_NOT_EXIST, new Object[]{devActionVO.getParentSid()});
            }
            if (parentAction.getDevModuleSid() != devActionVO.getModuleSid().longValue()) {
                throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST_MODULE, new Object[]{parentAction.getSid()});
            }
        }
        devAction.setNameCN(devActionVO.getNameCN());
        devAction.setNameUS(devActionVO.getNameUS());
        devAction.setNameTW(devActionVO.getNameTW());
        devAction.setNameVN(devActionVO.getNameVN());
        devAction.setRemarks(devActionVO.getRemarks());
        this.devActionCrudService.update(devAction);
        List<Long> devConditionSids = this.devConditionRepository.findConditionSidsByActionSid(devActionVO.getSid());
        if (devConditionSids.size() > 0) {
            this.devConditionRepository.batchDelete(devConditionSids);
        }
        List<DevConditionVO> conditionVOS = devActionVO.getConditions();
        ArrayList<Long> deleteSids = new ArrayList<Long>();
        if (conditionVOS.size() > 0) {
            for (DevConditionVO devConditionVO : conditionVOS) {
                if (1 == devConditionVO.getStatus()) {
                    deleteSids.add(devConditionVO.getSid());
                } else {
                    DevCondition devCondition = new DevCondition();
                    DevCondition oldDevCondition = (DevCondition)this.devConditionCrudService.findByUnionKey(new Object[]{devConditionVO.getKey(), devActionVO.getSid()});
                    devCondition.setNameCN(devConditionVO.getNameCN());
                    devCondition.setNameTW(devConditionVO.getNameTW());
                    devCondition.setNameUS(devConditionVO.getNameUS());
                    devCondition.setNameVN(devConditionVO.getNameVN());
                    devCondition.setType(devConditionVO.getType());
                    devCondition.setTypeParameter(JsonUtils.objToJson(devConditionVO.getTypeParameter()));
                    devCondition.setDefaultValue(devConditionVO.getDefaultValue());
                    devCondition.setKey(devConditionVO.getKey());
                    devCondition.setDevActionSid(devActionVO.getSid());
                    if (oldDevCondition == null) {
                        this.devConditionCrudService.create(devCondition);
                    } else {
                        devCondition.setSid(oldDevCondition.getSid());
                        this.devConditionCrudService.update(devCondition);
                    }
                }
                if (deleteSids.size() <= 0) continue;
                this.devConditionMapper.deleteBySids(deleteSids);
            }
        }
    }

    @Override
    public void deleteDevAction(long sid) {
        DevAction devAction = (DevAction)this.devActionCrudService.findBySid(sid);
        if (devAction == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACTION_NOT_EXIST, new Object[]{sid});
        }
        List<DevModuleVO> modules = this.devModuleMapper.getListInSids(Arrays.asList(devAction.getDevModuleSid()));
        if (!(CollectionUtils.isEmpty(modules) || UserUtils.getTenantId().equalsIgnoreCase(modules.get(0).getTenantId()) || this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), "/api/iam/v2/dev/app/module/action/{sid}", UserUtils.getSysId()).booleanValue())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.devActionRepository.deleteById(sid);
        this.changeLogService.createChangeLog(ChangeTypeEnum.DEV_ACTION_DEL.getName(), (Object)devAction, ChangeTypeEnum.DEV_ACTION_DEL.getPrimaryKey(), String.valueOf(devAction.getSid()));
        List<Long> devConditionSids = this.devConditionRepository.findConditionSidsByActionSid(sid);
        if (!devConditionSids.isEmpty()) {
            this.devConditionRepository.batchDelete(devConditionSids);
        }
    }

    @Override
    public void deleteDevActionBySys(long sysSid) {
        this.devConditionMapper.deleteBySys(sysSid);
        this.devActionMapper.deleteBySysSid(sysSid);
    }
}

