/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dev.app.impl;

import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionQueryResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevModuleQueryResultVO;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.mapper.DevModuleMapper;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionQueryService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleQueryService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevModuleQueryServiceImpl
implements DevModuleQueryService {
    @Autowired
    private DevModuleMapper devModuleMapper;
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private DevActionQueryService devActionQueryService;

    @Override
    public List<DevModuleQueryResultVO> getDevModuleVOSBySid(long sid) {
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(sid);
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sid});
        }
        List<DevModuleQueryResultVO> devModuleQueryResultVOS = this.devModuleMapper.findDevModuleBySysSid(sid);
        if (devModuleQueryResultVOS.size() > 0) {
            devModuleQueryResultVOS.forEach(o -> {
                List<DevActionQueryResultVO> devActionQueryResultVOS = this.devActionQueryService.getDevAction(o.getSid());
                o.setDevActions(devActionQueryResultVOS);
            });
        }
        return devModuleQueryResultVOS;
    }
}

