/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dev.app.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.dev.DevModuleVO;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.entity.DevModule;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.repository.DevActionRepository;
import com.digiwin.dap.middleware.iam.repository.DevConditionRepository;
import com.digiwin.dap.middleware.iam.repository.DevModuleRepository;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleCrudService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.iam.support.validate.OtherValidateService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DevModuleServiceImpl
implements DevModuleService {
    @Autowired
    private DevModuleCrudService devModuleCrudService;
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private DevModuleRepository devModuleRepository;
    @Autowired
    private DevActionRepository devActionRepository;
    @Autowired
    private DevConditionRepository devConditionRepository;
    @Autowired
    private OtherValidateService otherValidateService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private AuthValidateService authValidateService;

    @Override
    public long addDevModule(DevModuleVO devModuleVO) {
        this.otherValidateService.addDevModuleCheck(devModuleVO);
        DevModule oldDevModule = (DevModule)this.devModuleCrudService.findByUnionKey(new Object[]{devModuleVO.getId(), devModuleVO.getAppSid()});
        if (oldDevModule != null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_HAS_EXIST, new Object[]{oldDevModule.getId()});
        }
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(devModuleVO.getAppSid());
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{devModuleVO.getAppSid()});
        }
        DevModule devModule = new DevModule();
        devModule.setSid(devModuleVO.getSid() == null ? 0L : devModuleVO.getSid());
        devModule.setId(devModuleVO.getId());
        devModule.setDevAppSid(devSys.getSid());
        devModule.setNameCN(devModuleVO.getNameCN());
        devModule.setNameTW(devModuleVO.getNameTW());
        devModule.setNameUS(devModuleVO.getNameUS());
        devModule.setRemarks(devModuleVO.getRemarks());
        devModule.setNameVN(devModuleVO.getNameVN());
        return this.devModuleCrudService.create(devModule);
    }

    @Override
    public void modifyDevModule(DevModuleVO devModuleVO) {
        DevModule devModule = (DevModule)this.devModuleCrudService.findBySid(devModuleVO.getSid());
        if (devModule == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{devModuleVO.getSid()});
        }
        devModule.setNameCN(devModuleVO.getNameCN());
        devModule.setNameTW(devModuleVO.getNameTW());
        devModule.setNameUS(devModuleVO.getNameUS());
        devModule.setNameVN(devModuleVO.getNameVN());
        devModule.setRemarks(devModuleVO.getRemarks());
        this.devModuleCrudService.update(devModule);
    }

    @Override
    public void deleteDevModule(long sid) {
        DevModule devModule = (DevModule)this.devModuleCrudService.findBySid(sid);
        if (devModule == null) {
            throw new BusinessException((ErrorHandler)I18nError.MODULE_NOT_EXIST, new Object[]{sid});
        }
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(devModule.getDevAppSid());
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{devModule.getDevAppSid()});
        }
        if (!UserUtils.getTenantId().equalsIgnoreCase(devSys.getTenantId()) && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), "/api/iam/v2/dev/app/module/{sid}", UserUtils.getSysId()).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.devModuleRepository.deleteById(sid);
        this.changeLogService.createChangeLog(ChangeTypeEnum.DEV_MODULE_DEL.getName(), (Object)devModule, ChangeTypeEnum.DEV_MODULE_DEL.getPrimaryKey(), String.valueOf(devModule.getSid()));
        List<Long> devActionSids = this.devActionRepository.findActionSidsByModuleSid(sid);
        if (!devActionSids.isEmpty()) {
            devActionSids.forEach(devActionSid -> {
                this.devActionRepository.deleteById(devActionSid);
                List<Long> devConditionSids = this.devConditionRepository.findConditionSidsByActionSid((long)devActionSid);
                if (!devConditionSids.isEmpty()) {
                    this.devConditionRepository.batchDelete(devConditionSids);
                }
            });
        }
    }
}

