/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dev.sys.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.StdData;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.dev.AppSecretDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DeleteCheckDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevActionVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevModuleVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysDTO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysInfoVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysSyncVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO2;
import com.digiwin.dap.middleware.iam.domain.dev.DevSysVO3;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopAction;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopApp;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopCondition;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopLanguage;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopModule;
import com.digiwin.dap.middleware.iam.domain.dev.DevelopSys;
import com.digiwin.dap.middleware.iam.domain.enumeration.ChangeTypeEnum;
import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiRelationVO;
import com.digiwin.dap.middleware.iam.domain.service.permission.MetadataApiVO;
import com.digiwin.dap.middleware.iam.entity.DevAction;
import com.digiwin.dap.middleware.iam.entity.DevAppSecret;
import com.digiwin.dap.middleware.iam.entity.DevAppToken;
import com.digiwin.dap.middleware.iam.entity.DevCondition;
import com.digiwin.dap.middleware.iam.entity.DevModule;
import com.digiwin.dap.middleware.iam.entity.DevSys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.DevSysMapper;
import com.digiwin.dap.middleware.iam.mapper.ServicePermissionMapper;
import com.digiwin.dap.middleware.iam.repository.DevActionRepository;
import com.digiwin.dap.middleware.iam.repository.DevAppSecretRepository;
import com.digiwin.dap.middleware.iam.repository.DevAppTokenRepository;
import com.digiwin.dap.middleware.iam.repository.DevConditionRepository;
import com.digiwin.dap.middleware.iam.repository.DevModuleRepository;
import com.digiwin.dap.middleware.iam.repository.DevSysRepository;
import com.digiwin.dap.middleware.iam.repository.SysRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionCrudService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevActionService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleCrudService;
import com.digiwin.dap.middleware.iam.service.dev.app.DevModuleService;
import com.digiwin.dap.middleware.iam.service.dev.appscret.DevAppSecretCrudService;
import com.digiwin.dap.middleware.iam.service.dev.apptoken.DevAppTokenCrudService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysCrudService;
import com.digiwin.dap.middleware.iam.service.dev.sys.DevSysService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeService;
import com.digiwin.dap.middleware.iam.service.sys.SysService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantQueryService;
import com.digiwin.dap.middleware.iam.support.log.ChangeLogService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteIamService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteLMCService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.pagehelper.PageSerializable;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class DevSysServiceImpl
implements DevSysService {
    private Logger log = LoggerFactory.getLogger(DevSysServiceImpl.class);
    @Autowired
    private DevSysCrudService devSysCrudService;
    @Autowired
    private DevSysRepository devSysRepository;
    @Autowired
    private DevAppTokenCrudService devAppTokenCrudService;
    @Autowired
    private DevAppSecretCrudService devAppSecretCrudService;
    @Autowired
    private DevAppTokenRepository devAppTokenRepository;
    @Autowired
    private SysRepository sysRepository;
    @Autowired
    private DevSysMapper devSysMapper;
    @Autowired
    private DevModuleRepository devModuleRepository;
    @Autowired
    private DevActionRepository devActionRepository;
    @Autowired
    private DevConditionRepository devConditionRepository;
    @Autowired
    private DevAppSecretRepository devAppSecretRepository;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private ServicePermissionMapper servicePermissionMapper;
    @Autowired
    private RemoteIamService remoteIamService;
    @Autowired
    private TenantQueryService tenantQueryService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private SysService sysService;
    @Autowired
    private DevModuleService devModuleService;
    @Autowired
    private DevModuleCrudService devModuleCrudService;
    @Autowired
    private DevActionService devActionService;
    @Autowired
    DevActionCrudService devActionCrudService;
    @Autowired
    private DevSysService devSysService;
    @Autowired
    private CacService cacService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private SysNoticeService sysNoticeService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private DevSysService self;
    @Autowired
    private RemoteLMCService remoteLMCService;
    @Autowired
    private ChangeLogService changeLogService;
    @Autowired
    private AuthValidateService authValidateService;
    @Autowired
    private TenantRepository tenantRepository;

    @Override
    public DevSysInfoVO getDevSysFullInfo(String sysId) {
        List<Long> actionIds;
        DevSys devSys = (DevSys)this.devSysCrudService.findById(sysId);
        if (Objects.isNull((Object)devSys)) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sysId});
        }
        DevSysVO2 devSys2 = new DevSysVO2(devSys);
        Tenant tenant = (Tenant)this.tenantCrudService.findById(devSys.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_TENANT_NOT_EXIST, new Object[]{sysId, devSys.getTenantId()});
        }
        devSys2.setTenantId(tenant.getId());
        devSys2.setTenantName(tenant.getName());
        DevAppToken devAppToken = (DevAppToken)this.devAppTokenCrudService.findById(sysId);
        if (Objects.isNull((Object)devAppToken)) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_TOKEN_NOT_EXIST, new Object[]{sysId});
        }
        List<Object> actions = new ArrayList();
        List<DevCondition> conditions = new ArrayList<DevCondition>();
        List<DevModule> modules = this.devModuleRepository.findByDevAppSid(devSys.getSid());
        List<Long> moduleIds = modules.stream().map(BaseEntity::getSid).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(moduleIds) && !CollectionUtils.isEmpty(actionIds = (actions = this.devActionRepository.findAllByDevModuleSidIn(moduleIds)).stream().map(BaseEntity::getSid).collect(Collectors.toList()))) {
            conditions = this.devConditionRepository.findAllByDevActionSidIn(actionIds);
        }
        DevSysInfoVO vo = DevSysInfoVO.builder().appToken(devAppToken.getToken()).devSys(devSys2).modules(modules).actions(actions).conditions(conditions).build();
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long save(DevSysDTO dto) {
        if (this.devSysRepository.existsById(dto.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_HAS_EXIST, new Object[]{dto.getId()});
        }
        DevSys devSys = new DevSys();
        com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)dto, (Object)((Object)devSys));
        devSys.setApp(true);
        if (dto.getNonDev().booleanValue()) {
            devSys.setTenantSid(0L);
            devSys.setCommon(1);
        }
        if (dto.isLandingApp()) {
            devSys.setCommon(2);
        }
        this.populateTenantInfoFromToken(devSys, dto);
        this.devSysCrudService.create((BaseEntity)devSys);
        String token = DigestUtils.getAppToken((String)devSys.getId(), (String)KeyConstant.OTHER);
        DevAppToken devAppToken = new DevAppToken();
        devAppToken.setToken(token);
        devAppToken.setId(devSys.getId());
        this.devAppTokenCrudService.create((BaseEntity)devAppToken);
        DevAppSecret devAppSecret = this.newAppSecret(devSys);
        this.remoteLMCService.insertDevSysLog(devSys);
        this.sync(devSys, token, devAppSecret);
        return devSys.getSid();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public long importSys(String language, String appId, DevelopApp developApp) {
        if (!ObjectUtils.nullSafeEquals((Object)appId, (Object)developApp.getApp().getId())) {
            throw new BusinessException("\u6c47\u5165\u7684\u5e94\u7528\u4fe1\u606f\u4e0d\u5339\u914d");
        }
        DevSys devSys = (DevSys)this.devSysCrudService.findById(appId);
        if (null == devSys) {
            throw new BusinessException(String.format("\u5e94\u7528%s\u4e0d\u5b58\u5728", appId));
        }
        long devSysSid = devSys.getSid();
        List<DevModule> devModules = this.devModuleRepository.findByDevAppSid(devSysSid);
        ArrayList modules = new ArrayList();
        developApp.getModules().forEach(m -> {
            DevModule devModule = devModules.stream().filter(dm -> m.getId().equalsIgnoreCase(dm.getId())).findFirst().orElse(null);
            if (null == devModule) {
                devModule = m.generateEntity(devSysSid);
            } else {
                m.updateEntity(language, devModule);
            }
            modules.add(devModule);
        });
        this.devModuleRepository.saveAll(modules);
        List<DevAction> devActions = this.devActionRepository.findAllByDevModuleSidIn(modules.stream().map(BaseEntity::getSid).collect(Collectors.toList()));
        List<DevCondition> devConditions = this.devConditionRepository.findByDevActionSidIn(devActions.stream().map(BaseEntity::getSid).collect(Collectors.toList()));
        ArrayList actions = new ArrayList();
        ArrayList conditions = new ArrayList();
        developApp.getActions().stream().sorted(Comparator.comparing(DevelopAction::getParentId, Comparator.nullsFirst(Comparator.naturalOrder()))).collect(Collectors.toList()).forEach(a -> {
            DevModule matchModule = modules.stream().filter(m -> a.getModuleId().equalsIgnoreCase(m.getId())).findFirst().orElse(null);
            DevAction devAction = devActions.stream().filter(e -> ObjectUtils.nullSafeEquals((Object)matchModule.getSid(), (Object)e.getDevModuleSid()) && ObjectUtils.nullSafeEquals((Object)e.getId(), (Object)a.getId())).findFirst().orElse(null);
            if (null == devAction) {
                devAction = a.generateEntity(matchModule.getSid());
            } else {
                a.updateEntity(language, devAction);
            }
            if (StringUtils.hasText((String)a.getParentId())) {
                DevAction parentAction = actions.stream().filter(p -> ObjectUtils.nullSafeEquals((Object)matchModule.getSid(), (Object)p.getDevModuleSid()) && ObjectUtils.nullSafeEquals((Object)p.getId(), (Object)a.getParentId())).findFirst().orElse(null);
                if (null == parentAction) {
                    throw new BusinessException(String.format("\u6c47\u5165\u5e94\u7528%s\u6a21\u7ec4\u4fe1\u606f\u62a5\u9519\uff0c\u884c\u4e3a%s\u7684\u7236\u884c\u4e3a%s\u4e0d\u5b58\u5728", appId, a.getId(), a.getParentId()));
                }
                devAction.setUri(String.format("%s:%s", parentAction.getUri(), a.getId()));
                devAction.setParentSid(parentAction.getSid());
            } else {
                devAction.setParentSid(0L);
                devAction.setUri(String.format("%s:%s:%s:%s", "drn:iam:app", appId, a.getModuleId(), a.getId()));
            }
            actions.add(devAction);
            long actionSid = devAction.getSid();
            a.getCondition().forEach(c -> {
                DevCondition devCondition = devConditions.stream().filter(ec -> ObjectUtils.nullSafeEquals((Object)actionSid, (Object)ec.getDevActionSid()) && ObjectUtils.nullSafeEquals((Object)ec.getKey(), (Object)c.getKey())).findFirst().orElse(null);
                if (null == devCondition) {
                    devCondition = c.generateEntity(actionSid);
                } else {
                    c.updateEntity(language, devCondition, actionSid);
                }
                conditions.add(devCondition);
            });
        });
        this.devActionRepository.saveAll(actions);
        this.devConditionRepository.saveAll(conditions);
        ArrayList deleteModules = new ArrayList();
        devModules.forEach(m -> {
            if (!modules.stream().anyMatch(mm -> ObjectUtils.nullSafeEquals((Object)mm.getId(), (Object)m.getId()))) {
                deleteModules.add(m);
            }
        });
        if (!CollectionUtils.isEmpty(deleteModules)) {
            this.devModuleRepository.deleteAll(deleteModules);
        }
        ArrayList deleteActions = new ArrayList();
        devActions.forEach(a -> {
            if (!actions.stream().anyMatch(aa -> ObjectUtils.nullSafeEquals((Object)aa.getDevModuleSid(), (Object)a.getDevModuleSid()) && ObjectUtils.nullSafeEquals((Object)aa.getId(), (Object)a.getId()))) {
                deleteActions.add(a);
            }
        });
        if (!CollectionUtils.isEmpty(deleteActions)) {
            this.devActionRepository.deleteAll(deleteActions);
        }
        ArrayList deleteConditions = new ArrayList();
        devConditions.forEach(c -> {
            if (!conditions.stream().anyMatch(cc -> ObjectUtils.nullSafeEquals((Object)cc.getDevActionSid(), (Object)c.getDevActionSid()) && ObjectUtils.nullSafeEquals((Object)cc.getKey(), (Object)c.getKey()))) {
                deleteConditions.add(c);
            }
        });
        if (!CollectionUtils.isEmpty(deleteConditions)) {
            this.devConditionRepository.deleteAll(deleteConditions);
        }
        return devSysSid;
    }

    private void populateTenantInfoFromToken(DevSys devSys, DevSysDTO dto) {
        if (StringUtils.isEmpty((Object)dto.getTenantId()) && StringUtils.isEmpty((Object)dto.getTenantName())) {
            devSys.setTenantId(UserUtils.getTenantId());
            devSys.setTenantName(UserUtils.getTenantName());
        }
    }

    @Override
    public void sync(DevSys devSys, String token, DevAppSecret devAppSecret, String deleteId) {
        if (this.isLcdp()) {
            return;
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sys", (Object)devSys);
        params.put("appToken", token);
        params.put("deleteId", deleteId);
        params.put("appSecret", (Object)devAppSecret);
        this.sysNoticeService.syncDevAppInfo(params);
    }

    @Override
    public void sync(DevSys devSys, String token, DevAppSecret devAppSecret) {
        this.sync(devSys, token, devAppSecret, null);
    }

    private boolean isLcdp() {
        String id = Optional.ofNullable(UserUtils.getAuthoredSys()).map(AuthoredSys::getId).orElse("");
        return "athena-lcdp".equals(id);
    }

    private DevAppSecret newAppSecret(DevSys devSys) {
        String content = String.format("%s_@#$_%s_%s", devSys.getTenantId(), devSys.getId(), System.currentTimeMillis());
        String appSecret = AES.encryptCBC((String)content, (String)KeyConstant.OTHER);
        DevAppSecret devAppSecret = new DevAppSecret(devSys.getId(), appSecret);
        this.devAppSecretCrudService.create(devAppSecret);
        this.changeLogService.createChangeLog(ChangeTypeEnum.DEV_SECRET_RESET.getName(), (Object)devAppSecret, ChangeTypeEnum.DEV_SECRET_RESET.getPrimaryKey(), devAppSecret.getId());
        return devAppSecret;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DevSysDTO dto) {
        DevSys devSys = dto.getSid() != null ? (DevSys)this.devSysCrudService.findBySid(dto.getSid()) : (DevSys)this.devSysCrudService.findById(dto.getId());
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{dto.getSid()});
        }
        DevSys snapShot = new DevSys();
        BeanUtils.copyProperties((Object)((Object)devSys), (Object)((Object)snapShot));
        this.populateTenantInfoFromToken(devSys, dto);
        this.devSysCrudService.update((BaseEntity)devSys.update(dto));
        this.remoteLMCService.updateDevSysLog(snapShot, devSys);
        this.sync(devSys, null, null);
    }

    @Override
    public DevSysVO findDevSysBySid(Long sid) {
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(sid);
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sid});
        }
        return this.getDevSysVO(devSys);
    }

    private DevSysVO getDevSysVO(DevSys devSys) {
        DevAppToken devAppToken = (DevAppToken)this.devAppTokenRepository.findById(devSys.getId());
        DevSysVO devSysVO = new DevSysVO();
        com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)((Object)devSys), (Object)devSysVO);
        devSysVO.setAppToken(devAppToken.getToken());
        List<DevAppSecret> appSecrets = this.devAppSecretRepository.findById(devSys.getId());
        appSecrets.stream().filter(a -> a.getExpireTime() == null).findFirst().ifPresent(a -> devSysVO.setAppSecret(a.getAppSecret()));
        return devSysVO;
    }

    @Override
    public DevSysVO findDevSysById(String id) {
        DevSys devSys = (DevSys)this.devSysCrudService.findById(id);
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{id});
        }
        return this.getDevSysVO(devSys);
    }

    @Override
    public DevSysVO findDevSysByIdAndTenantSid(String id, Long tenantSid) {
        DevSys devSys = this.devSysRepository.findByIdAndTenantSid(id, tenantSid);
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{id});
        }
        DevAppToken devAppToken = (DevAppToken)this.devAppTokenRepository.findById(devSys.getId());
        DevSysVO devSysVO = new DevSysVO();
        com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)((Object)devSys), (Object)devSysVO);
        devSysVO.setAppToken(devAppToken.getToken());
        return devSysVO;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteDevSysBySid(Long sid) {
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(sid);
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{sid});
        }
        if (this.sysRepository.existsById(devSys.getId())) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_DELETE_ERROR, new Object[]{devSys.getId()});
        }
        this.devAppTokenRepository.deleteById(devSys.getId());
        this.devAppSecretRepository.deleteById(devSys.getId());
        List<DevModule> devModules = this.devModuleRepository.findByDevAppSid(devSys.getSid());
        if (!devModules.isEmpty()) {
            devModules.forEach(devModule -> {
                List<Long> devActionSids = this.devActionRepository.findActionSidsByModuleSid(devModule.getSid());
                if (!devActionSids.isEmpty()) {
                    devActionSids.forEach(devActionSid -> this.devActionRepository.deleteById(devActionSid));
                }
                this.devModuleRepository.deleteById(devModule.getSid());
            });
        }
        this.devSysRepository.deleteById(sid);
        this.changeLogService.createChangeLog(ChangeTypeEnum.DEV_APP_DEL.getName(), (Object)devSys, ChangeTypeEnum.DEV_APP_DEL.getPrimaryKey(), devSys.getId());
    }

    @Override
    public PageSerializable<DevSysVO> findDevSyses(Integer pageNum, Integer pageSize, String orderBy, DevSysDTO dto) {
        List<DevSysVO> devSysVOS = this.devSysMapper.findDevSysList(pageNum, pageSize, orderBy, dto);
        return new PageSerializable(devSysVOS);
    }

    @Override
    public List<DevSysVO> findDevSyses(DevSysDTO dto) {
        return this.devSysMapper.findDevSyses(dto);
    }

    @Override
    public List<DevSysVO> getAllSysInfos(DevSysDTO devSysDTO) {
        return this.devSysMapper.findNonDevSyses(devSysDTO.getExcludeBiding() == false);
    }

    @Override
    public void updateAppToTenant(DevSysVO devSysVO) {
        if (!devSysVO.getApps().isEmpty()) {
            String tenantId = null;
            String tenantName = null;
            if (0L != devSysVO.getTenantSid()) {
                Tenant tenant = (Tenant)this.tenantCrudService.findBySid(devSysVO.getTenantSid());
                if (null == tenant) {
                    throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{devSysVO.getTenantSid()});
                }
                tenantId = tenant.getId();
                tenantName = tenant.getName();
            }
            List<DevSys> devSysList = this.devSysMapper.findSysByIds(devSysVO.getApps());
            List existedAppIds = devSysList.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
            devSysVO.getApps().forEach(s -> {
                if (!existedAppIds.contains(s)) {
                    this.log.error(String.format("\u5e94\u7528%s\u4e0d\u5b58\u5728", s));
                } else {
                    DevSys sys = devSysList.stream().filter(d -> d.getId().equals(s)).findFirst().orElse(null);
                    if (sys.getCommon() == null || sys.getCommon() != 1) {
                        this.log.error(String.format("\u5e94\u7528%s\u4e0d\u662f\u666e\u901a\u5e94\u7528\uff0c\u4e0d\u80fd\u518d\u5f52\u5c5e\u4e8e\u79df\u6237\u6216\u89e3\u9664\u4e0e\u79df\u6237\u7684\u5173\u7cfb", s));
                    }
                }
            });
            this.devSysMapper.updateDevSysTenant(devSysVO.getApps(), devSysVO.getTenantSid(), tenantId, tenantName, devSysVO.getSysCategory(), devSysVO.getSysType(), devSysVO.getDevPlatform());
            for (String appId : devSysVO.getApps()) {
                DevSys byId = (DevSys)this.devSysCrudService.findById(appId);
                if (byId == null) continue;
                byId.setTenantId(tenantId);
                byId.setTenantName(tenantName);
                this.sync(byId, null, null);
            }
        }
    }

    @Override
    public void bindingLandingSys(DevSysDTO devSysDTO) {
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(devSysDTO.getSid());
        if (devSys == null) {
            throw new BusinessException(String.format("\u7ed1\u5b9a\u5e94\u7528%s\u4e0d\u5b58\u5728", devSysDTO.getSid()));
        }
        if (!devSys.getId().startsWith(String.format("%s_", devSysDTO.getTenantId()))) {
            throw new BusinessException(String.format("\u7ed1\u5b9a\u5e94\u7528%s\u524d\u7f00\u4e0d\u662f\u79df\u6237%s_,\u4e0d\u80fd\u7ed1\u5b9a", devSys.getId(), devSysDTO.getTenantId()));
        }
        devSys.setTenantId(devSysDTO.getTenantId());
        devSys.setTenantName(devSysDTO.getTenantName());
        devSys.setRemarks(devSysDTO.getRemarks());
        this.devSysCrudService.update((BaseEntity)devSys);
    }

    @Override
    public void unbindLandingSys(DevSysDTO devSysDTO) {
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(devSysDTO.getSid());
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{devSysDTO.getSid()});
        }
        devSys.setTenantId("");
        devSys.setTenantName("");
        this.devSysCrudService.update((BaseEntity)devSys);
    }

    @Override
    public List<DevSysVO> getLandingSysInfos(DevSysDTO devSysDTO) {
        return this.devSysMapper.findTenantLandingSyses(devSysDTO.getTenantSid());
    }

    @Override
    public boolean existsWithProdById(String id) {
        boolean existsCurrent = this.devSysRepository.existsById(id);
        if (existsCurrent) {
            return true;
        }
        if (0 == this.envProperties.getCloud()) {
            boolean existsAliProd = this.remoteIamService.existsDevAppById(id, DeployAreaEnum.AliyunProd);
            if (existsAliProd) {
                return true;
            }
            return this.remoteIamService.existsDevAppById(id, DeployAreaEnum.AzureProd);
        }
        return false;
    }

    @Override
    public DevSysVO findDevSys(DevSysDTO dto) {
        DevAppToken devAppToken;
        DevSys devSys = null;
        if (dto.getSid() != null) {
            devSys = (DevSys)this.devSysCrudService.findBySid(dto.getSid());
        } else if (!StringUtils.isEmpty((Object)dto.getId())) {
            devSys = (DevSys)this.devSysCrudService.findById(dto.getId());
        } else if (!StringUtils.isEmpty((Object)dto.getAppToken())) {
            devAppToken = this.devAppTokenRepository.findByToken(dto.getAppToken());
            Assert.notNull((Object)((Object)devAppToken), (String)"\u8be5\u5e94\u7528AppToken\u4e0d\u5b58\u5728");
            devSys = (DevSys)this.devSysCrudService.findById(devAppToken.getId());
        }
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{dto.getId()});
        }
        devAppToken = (DevAppToken)this.devAppTokenRepository.findById(devSys.getId());
        DevSysVO devSysVO = new DevSysVO();
        com.digiwin.dap.middleware.commons.util.BeanUtils.mergeDifferentTypeObject((Object)((Object)devSys), (Object)devSysVO);
        devSysVO.setAppToken(devAppToken.getToken());
        return devSysVO;
    }

    @Override
    @Transactional
    public Boolean deleteAppCascade(String appId) {
        DevSys devSys = this.devSysMapper.findSysWithTenantInfo(appId);
        List<String> tenantIds = this.tenantQueryService.getTenantIdsByAppId(appId);
        if (!tenantIds.isEmpty()) {
            if (tenantIds.size() > 1) {
                return false;
            }
            String tenantId = tenantIds.get(0);
            if (tenantId.equals(UserUtils.getTenantId()) && tenantId.equals(devSys.getTenantId())) {
                this.log.info("\u5e94\u7528{}\u6388\u6743\u7684\u79df\u6237\u662f{}\u4e0e\u5e94\u7528\u7684\u5f00\u53d1\u5546\u4e00\u81f4\uff0c\u5141\u8bb8\u5220\u9664", (Object)appId, (Object)tenantId);
                this.cacService.deletePurchaseGoods(tenantId, appId);
            } else {
                this.log.info("\u5e94\u7528{}\u6388\u6743\u7684\u79df\u6237\u662f{}\u4e0e\u5e94\u7528\u7684\u5f00\u53d1\u5546{}\u4e0d\u4e00\u81f4\uff0c\u4e0d\u5141\u8bb8\u5220\u9664", new Object[]{appId, tenantId, devSys.getTenantId()});
                return false;
            }
        }
        this.gmcService.deleteGoods(appId);
        this.sysService.deleteSysCascade(appId);
        if (devSys != null) {
            this.deleteDevSysBySid(devSys.getSid());
        }
        return true;
    }

    @Override
    @Transactional
    public DeleteCheckDTO deleteAppCascadeCheck(String appId) {
        DeleteCheckDTO deleteCheckDTO = new DeleteCheckDTO();
        DevSys devSys = this.devSysMapper.findSysWithTenantInfo(appId);
        List<String> tenantIds = this.tenantQueryService.getTenantIdsByAppId(appId);
        deleteCheckDTO.setDevSys(devSys);
        deleteCheckDTO.setTenantIds(tenantIds);
        return deleteCheckDTO;
    }

    @Override
    @Transactional
    public Boolean deleteAppCascadeDelete(DeleteCheckDTO deleteCheckDTO) {
        DevSys devSys = deleteCheckDTO.getDevSys();
        if (devSys != null) {
            DevSys existedDevSys = this.devSysRepository.findByIdAndTenantSid(devSys.getId(), UserUtils.getTenantSid());
            if (null == existedDevSys && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            this.sysService.deleteSysCascade(devSys.getId());
            this.deleteDevSysBySid(devSys.getSid());
        }
        return true;
    }

    @Override
    public void updateDevSysVisible(Long sid) {
        DevSys devSys = (DevSys)this.devSysCrudService.findBySid(sid);
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_IS_NOT_IN_DATABASE, new Object[]{sid});
        }
        devSys.setVisible(!devSys.isVisible());
        this.devSysCrudService.update((BaseEntity)devSys);
    }

    @Override
    public DevelopApp getDevAppInfo(String sysId, Boolean currentLanguage) {
        DevelopApp developApp = this.getDevApp(sysId);
        if (currentLanguage.booleanValue()) {
            developApp.toLanguage();
        }
        return developApp;
    }

    @Override
    public DevelopApp getDevAppInfoWithApiMetadata(String sysId, Boolean currentLanguage, Boolean withApi) {
        DevelopApp developApp = this.getDevAppInfo(sysId, currentLanguage);
        if (withApi.booleanValue()) {
            ArrayList<Long> dataSidList = new ArrayList<Long>();
            dataSidList.add(developApp.getApp().getSid());
            dataSidList.addAll(developApp.getModules().stream().map(DevelopLanguage::getSid).collect(Collectors.toList()));
            developApp.getActions().forEach(a -> {
                dataSidList.add(a.getSid());
                dataSidList.addAll(a.getCondition().stream().map(DevelopLanguage::getSid).collect(Collectors.toList()));
            });
            if (!dataSidList.isEmpty()) {
                List<MetadataApiRelationVO> apis = this.servicePermissionMapper.getRelatedMetadataApis(dataSidList);
                List<MetadataApiRelationVO> appApis = apis.stream().filter(a -> a.getType().equals(0)).collect(Collectors.toList());
                appApis.forEach(a -> {
                    MetadataApiVO metadataApiVO = new MetadataApiVO((MetadataApiRelationVO)a);
                    developApp.getApp().getApis().add(metadataApiVO);
                });
                appApis = apis.stream().filter(a -> a.getType().equals(1)).collect(Collectors.toList());
                appApis.forEach(a -> {
                    MetadataApiVO metadataApiVO = new MetadataApiVO((MetadataApiRelationVO)a);
                    DevelopModule module = developApp.getModules().stream().filter(m -> m.getSid().equals(a.getDataSid())).findFirst().orElse(null);
                    if (module != null) {
                        module.getApis().add(metadataApiVO);
                    } else {
                        this.log.error(String.format("\u6a21\u7ec4%s\u4e0d\u5b58\u5728", a.getDataSid()));
                    }
                });
                appApis = apis.stream().filter(a -> a.getType().equals(2)).collect(Collectors.toList());
                appApis.forEach(a -> {
                    MetadataApiVO metadataApiVO = new MetadataApiVO((MetadataApiRelationVO)a);
                    DevelopAction action = developApp.getActions().stream().filter(c -> c.getSid().equals(a.getDataSid())).findFirst().orElse(null);
                    if (action != null) {
                        action.getApis().add(metadataApiVO);
                    } else {
                        this.log.error(String.format("\u884c\u4e3a%s\u4e0d\u5b58\u5728", a.getDataSid()));
                    }
                });
                appApis = apis.stream().filter(a -> a.getType().equals(3)).collect(Collectors.toList());
                appApis.forEach(a -> {
                    MetadataApiVO metadataApiVO = new MetadataApiVO((MetadataApiRelationVO)a);
                    developApp.getActions().forEach(p -> {
                        DevelopCondition condition = p.getCondition().stream().filter(c -> c.getSid().equals(a.getDataSid())).findFirst().orElse(null);
                        if (condition != null) {
                            condition.getApis().add(metadataApiVO);
                        } else {
                            this.log.error(String.format("\u6761\u4ef6%s\u4e0d\u5b58\u5728", a.getDataSid()));
                        }
                    });
                });
            }
        }
        return developApp;
    }

    @Override
    public DevelopApp getDevApp(String sysId) {
        DevelopSys sys = this.devSysMapper.findSys(sysId);
        if (sys == null) {
            throw new BusinessException((ErrorHandler)I18nError.APP_NOT_EXISTED, new Object[]{sysId});
        }
        String appToken = this.devSysMapper.findAppToken(sysId);
        List<DevelopModule> modules = this.devSysMapper.findModule(sysId);
        List<DevelopAction> actions = this.devSysMapper.findAction(sysId);
        List<DevelopCondition> conditions = this.devSysMapper.findCondition(sysId);
        ObjectMapper objectMapper = JsonUtils.createObjectMapper();
        conditions.forEach(c -> {
            if (StringUtils.hasText((String)c.getParameter())) {
                try {
                    c.setTypeParameter((List)objectMapper.readValue(c.getParameter(), List.class));
                }
                catch (IOException e) {
                    this.log.error(String.format("\u8f6c\u6362\u6761\u4ef6%s\u5931\u8d25", c.getParameter()));
                }
            }
        });
        Map<Long, List<DevelopCondition>> conditionMap = conditions.stream().collect(Collectors.groupingBy(DevelopCondition::getActionSid));
        actions.forEach(action -> {
            if (conditionMap.containsKey(action.getSid())) {
                action.setCondition((List)conditionMap.get(action.getSid()));
            }
        });
        DevelopApp app = new DevelopApp();
        app.setAppToken(appToken);
        app.setApp(sys);
        app.setModules(modules);
        app.setActions(actions);
        return app;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateSys(DevSysVO3 body) {
        List<DevActionVO> actions;
        long appSid;
        DevSys byId = (DevSys)this.devSysCrudService.findById(body.getApp().getId());
        if (byId == null) {
            appSid = this.devSysService.save(body.getApp());
        } else {
            appSid = byId.getSid();
            this.devSysService.update(body.getApp());
        }
        HashMap<String, Long> moduleSidMap = new HashMap<String, Long>();
        List<DevModuleVO> modules = body.getModules();
        if (!CollectionUtils.isEmpty(modules)) {
            for (DevModuleVO module : modules) {
                module.setAppSid(appSid);
                DevModule byUnionKey = (DevModule)this.devModuleCrudService.findByUnionKey(new Object[]{module.getId(), appSid});
                if (byUnionKey == null) {
                    long moduleSid = this.devModuleService.addDevModule(module);
                    moduleSidMap.put(module.getId(), moduleSid);
                    continue;
                }
                module.setSid(byUnionKey.getSid());
                this.devModuleService.modifyDevModule(module);
                moduleSidMap.put(module.getId(), byUnionKey.getSid());
            }
        }
        if (!CollectionUtils.isEmpty(actions = body.getActions())) {
            for (DevActionVO action : actions) {
                DevAction byUnionKey;
                DevAction parent;
                action.setAppSid(appSid);
                action.setModuleSid((Long)moduleSidMap.get(action.getModuleId()));
                if (!StringUtils.isEmpty((Object)action.getParentId()) && (parent = (DevAction)this.devActionCrudService.findByUnionKey(new Object[]{action.getParentId(), action.getModuleSid(), UserUtils.getTenantSid()})) != null) {
                    action.setParentSid(parent.getSid());
                }
                if ((byUnionKey = (DevAction)this.devActionCrudService.findByUnionKey(new Object[]{action.getId(), action.getModuleSid(), UserUtils.getTenantSid()})) == null) {
                    this.devActionService.addDevAction(action, UserUtils.getTenantSid());
                    continue;
                }
                action.setSid(byUnionKey.getSid());
                this.devActionService.updateDevAction(action, UserUtils.getTenantSid());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void resetAppSecret(String id) {
        DevSys devSys = (DevSys)this.devSysCrudService.findById(id);
        if (devSys == null) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_NOT_EXISTED, new Object[]{id});
        }
        if (!UserUtils.getTenantId().equalsIgnoreCase(devSys.getTenantId()) && !this.authValidateService.checkAccessPermission("TenantSys", "POST", "/api/iam/v2/dev/app/secret/reset", String.format("%s-%s", UserUtils.getTenantId(), UserUtils.getSysId())).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
        }
        this.expireOldAppSecrets(id);
        DevAppSecret devAppSecret = this.newAppSecret(devSys);
        this.sync(null, null, new DevAppSecret(devAppSecret));
    }

    private void expireOldAppSecrets(String id) {
        List<DevAppSecret> appSecrets = this.devAppSecretRepository.findById(id);
        appSecrets.stream().filter(a -> a.getExpireTime() == null).forEach(a -> a.setExpireTime(LocalDateTime.now().plusHours(24L)));
        this.devAppSecretCrudService.saveAll(appSecrets);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncSys(DevSysSyncVO body) {
        this.log.info("syncSys start:{}", (Object)body);
        if (StringUtils.hasLength((String)body.getDeleteId())) {
            DevSys byId = (DevSys)this.devSysCrudService.findById(body.getDeleteId());
            if (byId != null) {
                this.self.deleteDevSysBySid(byId.getSid());
            }
            return;
        }
        Optional.ofNullable(body.getSys()).map(DevSysDTO::getId).ifPresent(a -> {
            DevSys devSys = (DevSys)this.devSysCrudService.findById(body.getSys().getId());
            if (devSys == null) {
                this.devSysCrudService.create((BaseEntity)new DevSys(body.getSys()));
            } else {
                this.devSysCrudService.update((BaseEntity)devSys.updateWhenSync(body.getSys()));
            }
        });
        Optional.ofNullable(body.getAppToken()).ifPresent(t -> {
            String id = body.getSys().getId();
            DevAppToken appToken = (DevAppToken)this.devAppTokenCrudService.findById(id);
            if (appToken == null) {
                this.devAppTokenCrudService.create((BaseEntity)new DevAppToken((String)t, id));
            } else {
                appToken.setToken((String)t);
                this.devAppTokenCrudService.update((BaseEntity)appToken);
            }
        });
        Optional.ofNullable(body.getAppSecret()).ifPresent(a -> {
            this.expireOldAppSecrets(a.getId());
            this.devAppSecretCrudService.create(new DevAppSecret((AppSecretDTO)a));
        });
        this.log.info("syncSys end");
    }

    @Override
    public String syncSysUpgrade(String input) {
        List all = this.devSysCrudService.findAll();
        int success = 0;
        int skip = 0;
        for (DevSys devSys : all) {
            if (new Integer(1).equals(devSys.getDevPlatform())) {
                ++skip;
                continue;
            }
            DevSysSyncVO devSysSyncVO = new DevSysSyncVO();
            DevSysDTO devSysDTO = new DevSysDTO();
            BeanUtils.copyProperties((Object)((Object)devSys), (Object)devSysDTO);
            devSysSyncVO.setSys(devSysDTO);
            DevAppToken appToken = (DevAppToken)this.devAppTokenCrudService.findById(devSys.getId());
            if (appToken != null) {
                devSysSyncVO.setAppToken(appToken.getToken());
                if (!StringUtils.isEmpty((Object)appToken.getAppSecret())) {
                    AppSecretDTO appSecretDTO = new AppSecretDTO();
                    appSecretDTO.setAppSecret(appToken.getAppSecret());
                    appSecretDTO.setId(devSys.getId());
                    devSysSyncVO.setAppSecret(appSecretDTO);
                }
            }
            try {
                String url = input + "/api/iam/v2/dev/app/sync";
                HttpHeaders headers = new HttpHeaders();
                HttpEntity request = new HttpEntity((Object)devSysSyncVO, (MultiValueMap)headers);
                ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, request, (ParameterizedTypeReference)new ParameterizedTypeReference<StdData<Boolean>>(){}, new Object[0]);
                if (responseEntity.getStatusCodeValue() != 200) {
                    this.log.error("syncSysUpgrade failed,message:{}", responseEntity.getBody());
                }
                ++success;
            }
            catch (Exception e) {
                this.log.error("syncSysUpgrade failed", (Throwable)e);
            }
        }
        return String.format("all:%s,success:%s,skip:%s", all.size(), success, skip);
    }

    @Override
    @Transactional
    public void deleteIntellySys(String appId) {
        DevSys devSys = this.devSysMapper.findSysWithTenantInfo(appId);
        this.sysService.deleteSysCascade(appId);
        if (devSys != null) {
            this.self.deleteDevSysBySid(devSys.getSid());
        }
    }

    @Override
    public String getCurrentSecret() {
        DevSysVO vo = this.devSysService.findDevSysById(UserUtils.getSysId());
        String appSecretKey = String.format("dap:encrypt:app:secret:%s", UserUtils.getSysId());
        RedisUtils.set((String)appSecretKey, (Object)vo.getAppSecret(), (Duration)Duration.ofHours(8L));
        return vo.getAppSecret();
    }

    @Override
    public List<DevelopSys> getDevSysOrByCustomerCross() {
        Tenant tenant;
        List<DevelopSys> sysList = this.devSysMapper.findSysByTenantId(UserUtils.getTenantId(), null);
        if (CollectionUtils.isEmpty(sysList) && StringUtils.hasText((String)(tenant = (Tenant)this.tenantCrudService.findBySid(UserUtils.getTenantSid())).getCustomerId()) && !DeployAreaEnum.AliyunProd.toString().equals(this.envProperties.getDeployArea())) {
            sysList = this.remoteIamService.getDevSysOrByCustomer(tenant.getCustomerId(), DeployAreaEnum.valueOf((String)this.envProperties.getRemoteDeployArea()));
        }
        return sysList;
    }

    @Override
    public List<DevelopSys> getDevSysOrByCustomer(String customerId) {
        List<String> tenantIds = this.tenantRepository.findIdByCustomerId(customerId);
        if (!CollectionUtils.isEmpty(tenantIds)) {
            List<DevelopSys> sysList = this.devSysMapper.findSysByTenantIds(tenantIds);
            return sysList;
        }
        return Collections.emptyList();
    }
}

