/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.dev.test.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.app.SysVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestAppCheckResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestCheckResultVO;
import com.digiwin.dap.middleware.iam.domain.dev.DevTestRegisterInfo;
import com.digiwin.dap.middleware.iam.domain.dev.RegisterResultInfoVO;
import com.digiwin.dap.middleware.iam.domain.role.QueryRoleResultVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantInfoVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.SysMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInRoleMapper;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.dev.test.DevTestEnvService;
import com.digiwin.dap.middleware.iam.service.policy.DefaultPolicyService;
import com.digiwin.dap.middleware.iam.service.tenant.PurchaseApplicationService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.initialize.TenantInitializeService;
import com.digiwin.dap.middleware.iam.support.remote.CacService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.OmcService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.util.EntityUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DevTestEnvServiceImpl
implements DevTestEnvService {
    private static Logger logger = LoggerFactory.getLogger(DevTestEnvServiceImpl.class);
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private SysMapper sysMapper;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private TenantInitializeService tenantInitializeService;
    @Autowired
    private OmcService omcService;
    @Autowired
    private PurchaseApplicationService purchaseApplicationService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private CacService cacService;
    @Autowired
    private DefaultPolicyService defaultPolicyService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private UserInRoleMapper userInRoleMapper;
    @Autowired
    private UserInRoleService userInRoleService;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private DevTestEnvService devTestEnvService;

    @Override
    public DevTestCheckResultVO existedTenantAndApps(String tenantId, List<DevTestAppCheckResultVO> apps) {
        DevTestCheckResultVO devTestCheckResultVO = new DevTestCheckResultVO();
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        devTestCheckResultVO.setTenantId(tenantId);
        if (null == tenant) {
            return devTestCheckResultVO;
        }
        devTestCheckResultVO.setExisted(true);
        List<Sys> existedApps = this.sysMapper.findByTenantSid(tenant.getSid());
        List appIds = existedApps.stream().map(BaseEntityWithId::getId).collect(Collectors.toList());
        apps.forEach(a -> {
            if (appIds.stream().anyMatch(i -> i.equalsIgnoreCase(a.getAppId()))) {
                a.setExisted(true);
            }
        });
        devTestCheckResultVO.setApps(apps);
        return devTestCheckResultVO;
    }

    @Override
    public Long registerTestInfoInTestArea(DevTestRegisterInfo registerInfo, String teamId) {
        logger.info("0.registerTestInfoInTestArea registerInfo :[{}]", (Object)registerInfo);
        if (null == registerInfo.getTenant()) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_REGISTER_ERROR_TENANT_NOT_NULL, new Object[]{registerInfo.getAppId()});
        }
        if (null == registerInfo.getUser()) {
            throw new BusinessException((ErrorHandler)I18nError.SYS_REGISTER_ERROR_USER_NOT_NULL, new Object[]{registerInfo.getAppId()});
        }
        Tenant tenant = registerInfo.getTenant();
        User user = registerInfo.getUser();
        String appId = registerInfo.getAppId();
        String gmcUri = registerInfo.getDeployGmcUrl();
        String tempPassword = DigestUtils.sha256((String)(tenant.getId() + user.getId())).replace("/", "").replace("+", "").substring(1, 21);
        try {
            logger.info("1.tenantid:[{}], teamId : [{}] ", (Object)registerInfo.getTenant().getId(), (Object)teamId);
            if ("1".equals(teamId) || "4".equals(teamId)) {
                logger.info("tenantid:[{}], autoCreateGoods appid:[{}] ", (Object)registerInfo.getTenant().getId(), (Object)appId);
                Boolean success = this.gmcService.autoCreateGoods(appId, registerInfo.getCloud(), false, gmcUri, registerInfo.getAppCloudUrl(), registerInfo.getPmEmails(), registerInfo.getSourceIamUri(), registerInfo.getTenant().getId(), registerInfo.getSourceCloud(), registerInfo.getSourceArea());
                logger.info("tenantid:[{}], autoCreateGoods appid:[{}], success:[{}] ", new Object[]{registerInfo.getTenant().getId(), appId, success});
                if (!success.booleanValue()) {
                    throw new BusinessException((ErrorHandler)I18nError.SYS_CREATE_GOODS_FAILED, new Object[]{registerInfo.getAppId()});
                }
            }
            RegisterResultInfoVO registerResultInfoVO = this.devTestEnvService.initializeTenantInfos(tenant, user, appId, registerInfo.getSysCategory(), teamId, tempPassword);
            Tenant testTenant = registerResultInfoVO.getTenant();
            String testTenantId = testTenant.getId();
            if (1 == this.envProperties.getCloud()) {
                this.purchaseApplicationService.purchaseAppForPreOrderInLanding(appId, testTenant, registerResultInfoVO.getUser().getId());
            } else {
                this.omcService.addPreOrder(gmcUri.replaceFirst("gmc", "omc"), appId, testTenant);
                this.cacService.addAuthorization(gmcUri.replaceFirst("gmc", "cac"), testTenantId, appId, registerResultInfoVO.getUser().getId());
            }
            if (testTenant.isEoc()) {
                TenantInfoVO tenantInfoVO = new TenantInfoVO();
                tenantInfoVO.setSid(testTenant.getSid());
                tenantInfoVO.setId(testTenantId);
                tenantInfoVO.setName(testTenant.getName());
                this.remoteEocService.initialize(tenantInfoVO);
            }
            registerInfo.setTestUserId(user.getId());
            registerInfo.setTestTenantId(testTenantId);
            registerInfo.setTestTenantName(registerResultInfoVO.getTenant().getName());
            registerInfo.setUserId(user.getId());
            registerInfo.setPassword(registerResultInfoVO.isUserExist() ? "\u5bc6\u7801\u8bf7\u4f9d\u4e2a\u4eba\u8bbe\u7f6e\u6216\u67e5\u9605\u5386\u53f2\u90ae\u4ef6\u627e\u56de" : tempPassword);
            registerInfo.setCode("dev");
            if (StringUtils.isEmpty((Object)registerInfo.getConsoleTestUri())) {
                registerInfo.setConsoleTestUri(this.envProperties.getConsoleTestUri());
            }
            registerInfo.setEmail(registerInfo.getUser().getEmail());
            logger.info("registerTestInfoInTestArea success");
            this.messageService.sendDevRegisterSuccessForTest(registerInfo);
            return registerResultInfoVO.getTenant().getSid();
        }
        catch (Exception ex) {
            registerInfo.setApplyUserId(user.getId());
            registerInfo.setApplyUserName(user.getName());
            registerInfo.setTenantId(tenant.getId());
            registerInfo.setTenantName(tenant.getName());
            registerInfo.setApplyDateTime(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").format(LocalDateTime.now()));
            registerInfo.setCode("dev");
            logger.info("registerTestInfoInTestArea error registerInfo :[{}]", (Object)registerInfo);
            this.messageService.sendDevRegisterFailForTest(registerInfo);
            throw new BusinessException((Throwable)ex);
        }
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public RegisterResultInfoVO initializeTenantInfos(Tenant tenant, User user, String appId, String sysCategory, String teamId, String tempPassword) {
        try {
            RegisterResultInfoVO registerResultInfoVO = new RegisterResultInfoVO();
            String testTenantId = String.format("test_%s", tenant.getId());
            Tenant testTenant = (Tenant)this.tenantCrudService.findById(testTenantId);
            if (null == testTenant) {
                testTenant = this.createTenant(tenant, testTenantId, sysCategory);
            } else {
                logger.warn(String.format("\u79df\u6237%s\u5df2\u7ecf\u5b58\u5728", testTenantId));
                if (!testTenant.isEoc() && !StringUtils.isEmpty((Object)sysCategory) && ("Athena".equals(sysCategory) || "1".equals(sysCategory))) {
                    testTenant.setEoc(true);
                }
                this.tenantCrudService.update((BaseEntity)testTenant);
            }
            long tenantSid = testTenant.getSid();
            User testUser = this.createUser(tenantSid, testTenantId, user, tempPassword, registerResultInfoVO);
            logger.info("[{}]\u521b\u5efa\u79df\u6237[{}]\u4e0e\u5e94\u7528[{}]\u5173\u7cfb", new Object[]{LocalDateTime.now(), testTenantId, appId});
            SysVO sysVO = new SysVO();
            sysVO.setId(appId);
            sysVO.setIdFirst(appId);
            this.purchaseApplicationService.purchaseApplication(testTenantId, "devAdmin", sysVO, false);
            logger.info("[{}]\u8bbe\u7f6e\u79df\u6237[{}]\u4e0b\u7528\u6237[{}]\u7684\u9f0e\u6377\u4e91\u529f\u80fd\u6743\u9650\u4ee5\u53ca\u5e94\u7528[{}]\u6570\u636e\u6743\u9650", new Object[]{LocalDateTime.now(), testTenantId, testUser.getId(), appId});
            if ("1".equals(teamId) || "4".equals(teamId)) {
                ArrayList<String> roleIds = new ArrayList<String>();
                List<QueryRoleResultVO> roleDBList = this.userInRoleMapper.queryUserInRoleByUser(tenantSid, testUser.getSid());
                if (!CollectionUtil.isEmpty(roleDBList)) {
                    List oldRoleIds = roleDBList.stream().map(QueryRoleResultVO::getId).collect(Collectors.toList());
                    roleIds.addAll(oldRoleIds);
                }
                roleIds.add("superadmin");
                this.userInRoleService.updateUserInRoleByUser(tenantSid, testUser.getSid(), roleIds);
            } else {
                this.defaultPolicyService.updateUserPolicy(tenantSid, "devAdmin");
                this.defaultPolicyService.updateUserDataPolicy(tenantSid, testUser.getSid(), appId);
            }
            registerResultInfoVO.setTenant(testTenant);
            registerResultInfoVO.setUser(testUser);
            return registerResultInfoVO;
        }
        catch (Exception exception) {
            throw new BusinessException((Throwable)exception);
        }
    }

    private Tenant createTenant(Tenant tenant, String testTenantId, String sysCategory) {
        User user;
        logger.info("{}\u521b\u5efa\u6d4b\u8bd5\u79df\u6237[{}]", (Object)LocalDateTime.now(), (Object)testTenantId);
        Tenant testTenant = new Tenant();
        BeanUtils.copyProperties((Object)((Object)tenant), (Object)((Object)testTenant));
        testTenant.setSid(0L);
        testTenant.setId(testTenantId);
        testTenant.setName(String.format("test_%s", tenant.getName()));
        testTenant.setEnterpriseType(TenantEnterpriseTypeEnum.ENTERPRISE_TENANT.getValue());
        testTenant.setOpen(true);
        testTenant.setConfirm(1);
        testTenant.setEoc(false);
        testTenant.setTestTenant(true);
        testTenant.setOpen(false);
        if (!StringUtils.isEmpty((Object)sysCategory) && ("Athena".equals(sysCategory) || "1".equals(sysCategory))) {
            testTenant.setEoc(true);
        }
        if ((user = (User)this.userCrudService.findById("devAdmin")) == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        long adminUserSid = user.getSid();
        testTenant.setOwnerUserSid(adminUserSid);
        EntityUtils.setCreateFields((BaseEntity)testTenant);
        testTenant.setCreateBy(adminUserSid);
        testTenant.setCreateById(user.getName());
        long tenantSid = this.tenantCrudService.create((BaseEntity)testTenant);
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenantSid, adminUserSid);
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenantSid);
            userInTenant.setUserSid(adminUserSid);
            this.userInTenantCrudService.create(userInTenant);
        }
        this.tenantInitializeService.initDefaultTenant(testTenantId, tenantSid, "devAdmin", adminUserSid);
        return testTenant;
    }

    private User createUser(Long tenantSid, String testTenantId, User user, String tempPassword, RegisterResultInfoVO registerResultInfoVO) {
        long userSid;
        String testUserId = String.format("%s%s%s", testTenantId, "$", user.getId());
        logger.info("[{}]\u521b\u5efa\u79df\u6237[{}]\u7684\u4f01\u4e1a\u7528\u6237[{}]", new Object[]{testTenantId, LocalDateTime.now(), testUserId});
        User testUser = (User)this.userCrudService.findById(testUserId);
        if (null == testUser) {
            testUser = new User();
            BeanUtils.copyProperties((Object)((Object)user), (Object)((Object)testUser));
            testUser.setSid(0L);
            testUser.setId(testUserId);
            testUser.setPassword(DigestUtils.sha256((String)tempPassword));
            testUser.setChanged(false);
            testUser.setActivated(true);
            testUser.setType(1);
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            testUser.setDueDate(LocalDateTime.parse("9999-12-31 23:59:59", dtf));
            userSid = this.userCrudService.create((BaseEntity)testUser);
        } else {
            registerResultInfoVO.setUserExist(true);
            userSid = testUser.getSid();
        }
        if (!this.userInTenantCrudService.existsByUnionKey(tenantSid, userSid)) {
            UserInTenant userInTenant = new UserInTenant();
            userInTenant.setTenantSid(tenantSid);
            userInTenant.setUserSid(userSid);
            this.userInTenantCrudService.create(userInTenant);
        }
        return testUser;
    }
}

