/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.impl;

import com.digiwin.dap.middleware.iam.entity.WhiteList;
import com.digiwin.dap.middleware.iam.mapper.WhiteListMapper;
import com.digiwin.dap.middleware.iam.repository.WhiteListRepository;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.service.impl.BaseEntityManagerService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class WhiteListServiceImpl
extends BaseEntityManagerService<WhiteList>
implements WhiteListService {
    @Autowired
    private WhiteListMapper whiteListMapper;
    @Autowired
    private WhiteListRepository whiteListRepository;

    protected WhiteListRepository getRepository() {
        return this.whiteListRepository;
    }

    @Override
    @Cacheable(cacheNames={"default"}, key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).WHITELIST_PREFIX + #id", cacheManager="dapCommonCacheManager")
    public List<String> getWhiteList(String id) {
        List<String> whiteLists = this.whiteListMapper.getById(id);
        ArrayList<String> result = new ArrayList<String>();
        for (String whiteList : whiteLists) {
            String[] split = whiteList.split(";");
            result.addAll(Arrays.asList(split));
        }
        return result;
    }

    @Override
    @CacheEvict(cacheNames={"default"}, key="T(com.digiwin.dap.middleware.iam.constant.RedisConstants).WHITELIST_PREFIX + #whiteList.id", cacheManager="dapCommonCacheManager")
    public void insertOrUpdateWhiteList(WhiteList whiteList) {
        WhiteList oldWhiteList = this.whiteListRepository.findFirstById(whiteList.getId());
        if (Objects.nonNull((Object)oldWhiteList)) {
            oldWhiteList.setContent(whiteList.getContent());
            this.update(oldWhiteList);
        } else {
            this.create(whiteList);
        }
    }
}

