/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.intelly.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.domain.Page;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyExperienceAuthStatusEnum;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyExperienceExtensionStatusEnum;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyExperienceStatusEnum;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyIdentityStatusEnum;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyIdentityTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.IntellyTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.TenantEnterpriseTypeEnum;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.form.CurrentIntellyVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperiencePageVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceResultVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceStatRequest;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceStatResultVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyExperienceVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityIdSearchVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityIdVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyIdentityVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationExportVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationPageVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationResultVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationStatResultVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationStatVO;
import com.digiwin.dap.middleware.iam.domain.form.IntellyRelationVO;
import com.digiwin.dap.middleware.iam.domain.tenant.MetadataOfTenant;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantSimpleVO;
import com.digiwin.dap.middleware.iam.entity.IntellyExperienceApplication;
import com.digiwin.dap.middleware.iam.entity.IntellyForm;
import com.digiwin.dap.middleware.iam.entity.IntellyIdentityApplication;
import com.digiwin.dap.middleware.iam.entity.IntellyRelation;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.IntellyMapper;
import com.digiwin.dap.middleware.iam.repository.IntellyExperienceApplicationRepository;
import com.digiwin.dap.middleware.iam.repository.IntellyFormRepository;
import com.digiwin.dap.middleware.iam.repository.IntellyIdentityApplicationRepository;
import com.digiwin.dap.middleware.iam.repository.IntellyRelationRepository;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyExperienceApplicationCrudService;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyIdentityApplicationCrudService;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyRelationCrudService;
import com.digiwin.dap.middleware.iam.service.intelly.IntellyService;
import com.digiwin.dap.middleware.iam.service.notice.SysNoticeService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.remote.GmcService;
import com.digiwin.dap.middleware.iam.support.remote.MessageService;
import com.digiwin.dap.middleware.iam.support.remote.domain.gmc.GoodsVO;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class IntellyServiceImpl
implements IntellyService {
    @Autowired
    private IntellyMapper intellyMapper;
    @Autowired
    private IntellyRelationRepository intellyRelationRepository;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private IntellyIdentityApplicationCrudService intellyIdentityApplicationCrudService;
    @Autowired
    private IntellyExperienceApplicationCrudService intellyExperienceApplicationCrudService;
    @Autowired
    private MessageService messageService;
    @Autowired
    private IntellyIdentityApplicationRepository intellyIdentityApplicationRepository;
    @Autowired
    private IntellyExperienceApplicationRepository intellyExperienceApplicationRepository;
    @Autowired
    private IntellyRelationCrudService intellyRelationCrudService;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private IntellyFormRepository intellyFormRepository;
    @Autowired
    private GmcService gmcService;
    @Autowired
    private SysNoticeService sysNoticeService;

    @Override
    public List<IntellyRelationResultVO> queryPage(IntellyRelationPageVO body) {
        List<Object> result = new ArrayList();
        if (IntellyTypeEnum.TENANT.getValue().equals(body.getType())) {
            result = this.intellyMapper.queryIntellyTenantPage(body);
        } else if (IntellyTypeEnum.USER.getValue().equals(body.getType())) {
            result = this.intellyMapper.queryIntellyUserPage(body);
        }
        return result;
    }

    @Override
    public void checkUser() {
        long userSid = UserUtils.getUserSid();
        List<IntellyRelation> relationList = this.intellyRelationRepository.findByRelationSidAndType(userSid, IntellyTypeEnum.USER.getValue());
        if (!CollectionUtils.isEmpty(relationList)) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_CHECK_INTELLY_EXIST);
        }
        User user = (User)this.userCrudService.findBySid(userSid);
        if (Objects.equals(user.getType(), UserTypeEnum.INTERNAL.getCode())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_CHECK_INTELLY_ENTERPRISE);
        }
        Tenant individualTenant = this.tenantCrudService.findIndividualTenant(userSid, TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
        if (individualTenant != null && (individualTenant.getId().length() > 40 || StringUtil.containsNonEnglishDigits(individualTenant.getId()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_CHECK_INTELLY_ID);
        }
    }

    @Override
    public List<IntellyRelationStatResultVO> queryStat(IntellyRelationStatVO body) {
        return this.intellyMapper.queryIntellyStat(body);
    }

    @Override
    public Long createIdentityApplication(IntellyIdentityVO body) {
        IntellyIdentityApplication application = this.intellyIdentityApplicationRepository.findByUserSid(body.getUserSid());
        if (application == null) {
            application = (IntellyIdentityApplication)((Object)body.doForward());
            application.setStatus(IntellyIdentityStatusEnum.INIT.getStatus());
            this.intellyIdentityApplicationCrudService.create(application);
            this.messageService.sendCompleteIdentityEmail(application);
        } else if (IntellyIdentityStatusEnum.REJECTED.getStatus() == application.getStatus().intValue()) {
            long sid = application.getSid();
            application = (IntellyIdentityApplication)((Object)body.doForward());
            application.setSid(sid);
            application.setStatus(IntellyIdentityStatusEnum.INIT.getStatus());
            this.intellyIdentityApplicationCrudService.update(application);
            this.messageService.sendCompleteIdentityEmail(application);
        } else if (IntellyIdentityStatusEnum.CONFIRMED.getStatus() == application.getStatus().intValue()) {
            long sid = application.getSid();
            Boolean notified = !ObjectUtils.nullSafeEquals((Object)application.getName(), (Object)body.getName());
            application = (IntellyIdentityApplication)((Object)body.doForward());
            application.setSid(sid);
            application.setStatus(IntellyIdentityStatusEnum.INIT.getStatus());
            if (notified.booleanValue()) {
                application.setNotified(true);
            }
            this.intellyIdentityApplicationCrudService.update(application);
            this.messageService.sendCompleteIdentityEmail(application);
        }
        return application.getSid();
    }

    @Override
    @Transactional
    public void confirmIdentityApplication(IntellyIdentityVO body) {
        IntellyIdentityApplication application = (IntellyIdentityApplication)this.intellyIdentityApplicationCrudService.findBySid(body.getSid());
        application.setStatus(IntellyIdentityStatusEnum.CONFIRMED.getStatus());
        this.intellyIdentityApplicationCrudService.update(application);
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        user.completeIdentity(application);
        this.userCrudService.update((BaseEntity)user);
        this.messageService.sendConfirmIdentityEmail(application);
        if (Boolean.TRUE.equals(application.getNotified())) {
            this.sysNoticeService.reAuthenticate(user.getId(), UserUtils.getToken());
            application.setNotified(false);
            this.intellyIdentityApplicationCrudService.update(application);
        }
    }

    @Override
    @Transactional
    public void rejectIdentityApplication(IntellyIdentityVO body) {
        IntellyIdentityApplication application = (IntellyIdentityApplication)this.intellyIdentityApplicationCrudService.findBySid(body.getSid());
        application.setStatus(IntellyIdentityStatusEnum.REJECTED.getStatus());
        this.intellyIdentityApplicationCrudService.update(application);
        this.messageService.sendRejectCompleteIdentityEmail(application, body);
    }

    @Override
    public Map<Long, IntellyIdentityVO> batchGetIdentity(List<Long> sids, boolean mask, Boolean excludeSensitiveData) {
        if (CollectionUtils.isEmpty(sids)) {
            return new HashMap<Long, IntellyIdentityVO>();
        }
        List<IntellyIdentityApplication> list = this.intellyIdentityApplicationRepository.findByUserSidIn(sids);
        return list.stream().map(a -> {
            IntellyIdentityVO vo = new IntellyIdentityVO();
            vo.doBackward(a);
            vo.setIdCode(IntellyIdentityTypeEnum.getShowCode(vo.getIdType(), vo.getIdCode(), mask));
            if (excludeSensitiveData.booleanValue()) {
                vo.setIdCode(null);
                vo.setIdFront(null);
                vo.setIdBack(null);
            }
            return vo;
        }).collect(Collectors.toMap(IntellyIdentityVO::getUserSid, Function.identity()));
    }

    @Override
    public Map<Long, IntellyIdentityVO> batchGetIdentity(List<Long> sids) {
        return this.batchGetIdentity(sids, true, false);
    }

    @Override
    public CurrentIntellyVO checkIntelly(long userSid) {
        CurrentIntellyVO result = new CurrentIntellyVO();
        result.setIdentity(this.batchGetIdentity(Collections.singletonList(userSid)).get(userSid));
        List<IntellyRelationResultVO> resultVOList = this.intellyMapper.queryIntellyUser(userSid);
        result.setIntellyList(resultVOList);
        result.setIntelly(CollectionUtils.isEmpty(resultVOList) ? null : resultVOList.get(0));
        result.setExperience(this.intellyMapper.queryExperienceApplications(new IntellyExperiencePageVO(userSid, 9999)));
        return result;
    }

    @Override
    public Long createIntelly(IntellyRelationVO body) {
        IntellyRelation relation = this.intellyRelationRepository.findByRelationSidAndTypeAndFormSid(body.getRelationSid(), body.getType(), body.getFormSid());
        if (relation != null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_INTELLY_EXIST);
        }
        return this.intellyRelationCrudService.create((BaseEntity)body.doForward());
    }

    @Override
    @Transactional
    public IntellyExperienceApplication createExperienceApplication(IntellyExperienceVO body) {
        List<IntellyExperienceApplication> history = this.intellyExperienceApplicationRepository.findByUserSidAndGoodsSid(body.getUserSid(), body.getGoodsSid());
        if (history.stream().anyMatch(a -> IntellyExperienceStatusEnum.alreadyApplied(a.getStatus()))) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_CHECK_INTELLY_EXPERIENCE_ADD);
        }
        IntellyExperienceApplication application = (IntellyExperienceApplication)((Object)body.doForward());
        application.setStatus(IntellyExperienceStatusEnum.INIT.getStatus());
        application.setAuthStatus(IntellyExperienceAuthStatusEnum.INIT.getStatus());
        application.setApplyCode(this.generateExperienceCode());
        this.intellyExperienceApplicationCrudService.create(application);
        User user = (User)this.userCrudService.findBySid(application.getUserSid());
        user.setName(body.getRealName());
        user.setEmail(body.getEmail());
        this.userCrudService.update((BaseEntity)user);
        return application;
    }

    private String generateExperienceCode() {
        long maxOrderCode;
        String key = "DEA" + DateUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyyMMdd");
        long sequence = RedisUtils.opsForValue().increment((Object)key, 1L);
        if (sequence == 1L && (maxOrderCode = this.intellyMapper.findMaxApplyCode()) >= sequence) {
            sequence = RedisUtils.opsForValue().increment((Object)key, maxOrderCode);
        }
        return key + String.format("%06d", sequence);
    }

    @Override
    public void confirmExperienceApplication(IntellyExperienceVO body) {
        IntellyExperienceApplication application = (IntellyExperienceApplication)this.intellyExperienceApplicationCrudService.findBySid(body.getSid());
        application.setStatus(IntellyExperienceStatusEnum.CONFIRMED.getStatus());
        application.setEffectiveDate(body.getEffectiveDate());
        application.setExpireDate(body.getExpireDate());
        application.setSourceCode(body.getSourceCode());
        application.setRemark(body.getRemark());
        application.setUrl(body.getUrl());
        this.intellyExperienceApplicationCrudService.update(application);
    }

    @Override
    public void authExperienceApplication(IntellyExperienceVO body) {
        IntellyExperienceApplication application = (IntellyExperienceApplication)this.intellyExperienceApplicationCrudService.findBySid(body.getSid());
        application.setAuthStatus(Optional.ofNullable(body.getAuthStatus()).orElse(IntellyExperienceAuthStatusEnum.DONE.getStatus()));
        this.intellyExperienceApplicationCrudService.update(application);
    }

    @Override
    public void rejectExperienceApplication(IntellyExperienceVO body) {
        IntellyExperienceApplication application = (IntellyExperienceApplication)this.intellyExperienceApplicationCrudService.findBySid(body.getSid());
        application.setStatus(IntellyExperienceStatusEnum.REJECTED.getStatus());
        application.setRemark(body.getRemark());
        this.intellyExperienceApplicationCrudService.update(application);
        this.messageService.sendRejectExperienceEmail(application, body.getRemark());
    }

    @Override
    public void batchRejectExperienceApplication(String type, List<IntellyExperienceVO> body) {
        List<IntellyExperienceApplication> applications = this.intellyExperienceApplicationCrudService.findInSids(body.stream().map(IntellyExperienceVO::getSid).collect(Collectors.toList()));
        if ("status".equalsIgnoreCase(type)) {
            applications.forEach(a -> {
                a.setStatus(IntellyExperienceStatusEnum.REJECTED.getStatus());
                a.setRemark(((IntellyExperienceVO)((Object)((Object)body.stream().findFirst().get()))).getRemark());
            });
        } else {
            applications.forEach(a -> {
                a.setExtensionStatus(IntellyExperienceExtensionStatusEnum.REJECTED.getStatus());
                a.setRemark(((IntellyExperienceVO)((Object)((Object)body.stream().findFirst().get()))).getRemark());
            });
        }
        this.intellyExperienceApplicationCrudService.updateAll(applications);
        applications.forEach(a -> this.messageService.sendRejectExperienceEmail((IntellyExperienceApplication)((Object)a), a.getRemark()));
    }

    @Override
    public List<IntellyExperienceResultVO> queryExperienceApplications(IntellyExperiencePageVO body) {
        return this.intellyMapper.queryExperienceApplications(body);
    }

    @Override
    public List<IntellyExperienceResultVO> queryOMExperienceApplications(IntellyExperiencePageVO body) {
        List<GoodsVO> filterGoods;
        if (StringUtils.hasText((String)body.getGoodsPurposeNotEq()) && !CollectionUtils.isEmpty(filterGoods = this.gmcService.getGoodsList(body.getGoodsPurposeNotEq()))) {
            body.setGoodsCodes(filterGoods.stream().map(GoodsVO::getCode).collect(Collectors.toList()));
        }
        List<IntellyExperienceResultVO> list = this.intellyMapper.queryOMExperienceApplications(body);
        Map<Long, IntellyIdentityVO> identityVOMap = this.batchGetIdentity(list.stream().map(IntellyExperienceResultVO::getUserSid).collect(Collectors.toList()), false, false);
        for (IntellyExperienceResultVO result : list) {
            result.setIdentity(identityVOMap.get(result.getUserSid()));
            Tenant individualTenant = this.tenantCrudService.findIndividualTenant(result.getUserSid(), TenantEnterpriseTypeEnum.INDIVIDUAL_TENANT.getValue());
            result.setIndividualTenant(new TenantSimpleVO(individualTenant));
        }
        return list;
    }

    @Override
    public void createExperienceExtension(IntellyExperienceVO body) {
        IntellyExperienceApplication application = (IntellyExperienceApplication)this.intellyExperienceApplicationCrudService.findBySid(body.getSid());
        if (application != null) {
            application.setExtensionStatus(IntellyExperienceExtensionStatusEnum.INIT.getStatus());
            application.setExtensionRemark(body.getExtensionRemark());
            this.intellyExperienceApplicationCrudService.update(application);
            this.messageService.sendExperienceExtensionEmail(application, body);
        }
    }

    @Override
    public void rejectExperienceExtension(IntellyExperienceVO body) {
        IntellyExperienceApplication application = (IntellyExperienceApplication)this.intellyExperienceApplicationCrudService.findBySid(body.getSid());
        application.setExtensionStatus(IntellyExperienceExtensionStatusEnum.REJECTED.getStatus());
        this.intellyExperienceApplicationCrudService.update(application);
        this.messageService.sendExperienceExtensionRejectEmail(application, body);
    }

    @Override
    public void confirmExperienceExtension(IntellyExperienceVO body) {
        IntellyExperienceApplication application = (IntellyExperienceApplication)this.intellyExperienceApplicationCrudService.findBySid(body.getSid());
        LocalDateTime oldExpireDate = application.getExpireDate();
        application.setExtensionStatus(IntellyExperienceExtensionStatusEnum.CONFIRMED.getStatus());
        application.setExpireDate(body.getExpireDate());
        this.intellyExperienceApplicationCrudService.update(application);
        this.messageService.sendExperienceExtensionConfirmEmail(application, body, oldExpireDate);
    }

    @Override
    public IntellyIdentityVO getIntellyIdentityByUserId(String userId) {
        long userSid = this.userCrudService.getSidById(userId);
        if (userSid == 0L) {
            return null;
        }
        IntellyIdentityApplication intellyIdentity = this.intellyIdentityApplicationRepository.findByUserSid(userSid);
        return Optional.ofNullable(intellyIdentity).map(x -> new IntellyIdentityVO(x.getSid(), x.getUserSid(), x.getStatus())).orElse(null);
    }

    @Override
    public IntellyExperienceStatResultVO getExperienceStatHead(IntellyExperienceStatRequest cond) {
        List<GoodsVO> filterGoods;
        if (StringUtils.hasText((String)cond.getGoodsPurposeNotEq()) && !CollectionUtils.isEmpty(filterGoods = this.gmcService.getGoodsList(cond.getGoodsPurposeNotEq()))) {
            cond.setGoodsCodes(filterGoods.stream().map(GoodsVO::getCode).collect(Collectors.toList()));
        }
        return this.intellyMapper.getExperienceStatHead(cond);
    }

    @Override
    public List<IntellyExperienceStatResultVO> getExperienceStatBody(IntellyExperienceStatRequest input) {
        List<GoodsVO> filterGoods;
        if (StringUtils.hasText((String)input.getGoodsPurposeNotEq()) && !CollectionUtils.isEmpty(filterGoods = this.gmcService.getGoodsList(input.getGoodsPurposeNotEq()))) {
            input.setGoodsCodes(filterGoods.stream().map(GoodsVO::getCode).collect(Collectors.toList()));
        }
        return this.intellyMapper.getExperienceStatBody(input);
    }

    @Override
    public PageSerializable<IntellyExperienceStatResultVO> getExperienceStatBodyPage(IntellyExperienceStatRequest input, Page page) {
        PageMethod.startPage((int)page.getPageNum(), (int)page.getPageSize(), (String)page.getOrderBy());
        return PageSerializable.of(this.intellyMapper.getExperienceStatBody(input));
    }

    @Override
    public PageSerializable<IntellyIdentityIdVO> findIdentityOfId(IntellyIdentityIdSearchVO body) {
        List<IntellyIdentityIdVO> result = this.intellyMapper.findIdentityOfId(body);
        result.forEach(a -> a.setIdCode(CharSequenceUtil.hide((CharSequence)a.getIdCode(), (int)3, (int)(a.getIdCode().length() - 3))));
        return PageSerializable.of(result);
    }

    @Override
    public List<IntellyExperienceResultVO> getExperienceAppliedGoods(IntellyExperienceStatRequest cond) {
        List<GoodsVO> filterGoods;
        if (cond != null && StringUtils.hasText((String)cond.getGoodsPurposeNotEq()) && !CollectionUtils.isEmpty(filterGoods = this.gmcService.getGoodsList(cond.getGoodsPurposeNotEq()))) {
            cond.setGoodsCodes(filterGoods.stream().map(GoodsVO::getCode).collect(Collectors.toList()));
        }
        return this.intellyMapper.getExperienceAppliedGoods(cond);
    }

    @Override
    public List<IntellyRelationExportVO> queryPageExport(IntellyRelationPageVO body) {
        ArrayList<IntellyRelationExportVO> result = new ArrayList();
        if (IntellyTypeEnum.TENANT.getValue().equals(body.getType())) {
            result = this.intellyMapper.queryIntellyTenantPageExport(body);
            this.populateAdditionalFields(result);
        } else if (IntellyTypeEnum.USER.getValue().equals(body.getType())) {
            throw new BusinessException("\u4e0d\u652f\u6301\u5bfc\u51fa");
        }
        return result;
    }

    private void populateAdditionalFields(List<IntellyRelationExportVO> result) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        List<String> tenantIds = result.stream().map(IntellyRelationExportVO::getTenantId).distinct().collect(Collectors.toList());
        List<MetadataOfTenant> allTenants = this.tenantMetadataCrudService.batchGetAllTenantMetadataValueWithTenantId(tenantIds);
        Map<String, List<MetadataOfTenant>> byTenant = allTenants.stream().collect(Collectors.groupingBy(MetadataOfTenant::getTenantId));
        for (Map.Entry<String, List<MetadataOfTenant>> entry : byTenant.entrySet()) {
            Optional<IntellyRelationExportVO> optionalTenant = result.stream().filter(tenant -> tenant.getTenantId().equals(entry.getKey())).findFirst();
            optionalTenant.ifPresent(a -> {
                for (MetadataOfTenant meta : (List)entry.getValue()) {
                    String catalogId = meta.getCatalogId();
                    String key = meta.getKey();
                    if ("resourceCost".equals(catalogId) && "deptId".equals(key)) {
                        a.setCostDeptId(meta.getValue());
                    }
                    if ("resourceCost".equals(catalogId) && "deptName".equals(key)) {
                        a.setCostDeptName(meta.getValue());
                    }
                    if ("resourceCost".equals(catalogId) && "empId".equals(key)) {
                        a.setCostEmpId(meta.getValue());
                    }
                    if (!"resourceCost".equals(catalogId) || !"empName".equals(key)) continue;
                    a.setCostEmpName(meta.getValue());
                }
            });
        }
    }

    @Override
    public void checkFormDel(long formSid) {
        List<IntellyRelation> relations = this.intellyRelationCrudService.findByFormSid(formSid);
        if (!CollectionUtils.isEmpty(relations)) {
            throw new BusinessException((ErrorHandler)I18nError.INTELLY_FORM_DEL_RELATION_EXIST);
        }
    }

    @Override
    public void checkFormGroupDel(long formGroupSid) {
        List<IntellyForm> intellyFormList = this.intellyFormRepository.findByGroupSid(formGroupSid);
        if (!CollectionUtils.isEmpty(intellyFormList)) {
            throw new BusinessException((ErrorHandler)I18nError.INTELLY_FORM_GROUP_DEL_RELATION_EXIST);
        }
    }
}

