/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.invite.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.invite.InviteUserLinkPageVO;
import com.digiwin.dap.middleware.iam.domain.invite.InviteUserPageRspVO;
import com.digiwin.dap.middleware.iam.domain.tenant.GeneralParametersVO;
import com.digiwin.dap.middleware.iam.entity.InvitedUserHistory;
import com.digiwin.dap.middleware.iam.entity.InvitedUserLink;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.mapper.InviteUserLinkMapper;
import com.digiwin.dap.middleware.iam.repository.InviteUserLinkRepository;
import com.digiwin.dap.middleware.iam.repository.InvitedUserHistoryRepository;
import com.digiwin.dap.middleware.iam.repository.UserInTenantRepository;
import com.digiwin.dap.middleware.iam.service.invite.InviteUserLinkService;
import com.digiwin.dap.middleware.iam.service.tenant.InvitedUserHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.validate.AuthValidateService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.github.pagehelper.PageSerializable;
import com.github.pagehelper.page.PageMethod;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InviteUserLinkServiceImpl
implements InviteUserLinkService {
    @Resource
    private InviteUserLinkRepository inviteUserLinkRepository;
    @Resource
    private UserInTenantRepository userInTenantRepository;
    @Resource
    private InvitedUserHistoryRepository invitedUserHistoryRepository;
    @Resource
    private InvitedUserHistoryCrudService invitedUserHistoryCrudService;
    @Resource
    private InviteUserLinkMapper inviteUserLinkMapper;
    @Resource
    private TenantCrudService tenantCrudService;
    @Autowired
    private AuthValidateService authValidateService;

    @Override
    public PageSerializable<InviteUserPageRspVO> search(InviteUserLinkPageVO body) {
        PageMethod.startPage((int)body.getPageNum(), (int)body.getPageSize(), (String)body.getOrderBy());
        List<InviteUserPageRspVO> result = this.inviteUserLinkMapper.queryPage(body);
        return new PageSerializable(result);
    }

    @Override
    @Transactional
    public void disable(InviteUserLinkPageVO body) {
        this.inviteUserLinkRepository.findById(body.getSid()).ifPresent(a -> {
            if (UserUtils.getTenantSid() != a.getTenantSid() && !this.authValidateService.checkAccessPermission("Sys", AppAuthContextHolder.getContext().getRequestInfo().getMethod(), AppAuthContextHolder.getContext().getRequestInfo().getPath(), UserUtils.getSysId()).booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_PERMISSION_ERROR);
            }
            a.setDueDate(LocalDateTime.now());
            a.setDisabled(true);
        });
    }

    @Override
    public void agree(InviteUserLinkPageVO body) {
        InvitedUserLink link = (InvitedUserLink)((Object)this.inviteUserLinkRepository.findById(body.getSid()).orElseThrow(() -> new BusinessException((ErrorHandler)I18nError.IAM_INVITE_LINK_INVALID)));
        if (link.isDisabled() || link.getDueDate().isBefore(LocalDateTime.now())) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_INVITE_LINK_EXPIRED);
        }
        if (this.userInTenantRepository.existsByTenantSidAndUserSid(link.getTenantSid(), body.getUserSid())) {
            Tenant tenant = (Tenant)this.tenantCrudService.findBySid(link.getTenantSid());
            throw new BusinessException((ErrorHandler)I18nError.IAM_TENANT_JOINED, new Object[]{tenant.getName()});
        }
        List<InvitedUserHistory> exist = this.invitedUserHistoryRepository.findInvitedUserHistories(link.getTenantSid(), body.getUserSid(), null, null);
        if (exist.isEmpty()) {
            this.createNewInviteHistory(link, body);
        } else {
            this.updateInviteHistory(exist, link);
        }
    }

    private void updateInviteHistory(List<InvitedUserHistory> exist, InvitedUserLink link) {
        ArrayList<InvitedUserHistory> update = new ArrayList<InvitedUserHistory>();
        for (InvitedUserHistory history : exist) {
            if (!IamConstants.AcceptedStatus.ApplyWaitAgree.toString().equals(history.getAcceptedStatus())) continue;
            history.setApp(this.merge(history.getApp(), link.getApp()));
            history.setOrg(this.merge(history.getOrg(), link.getOrg()));
            history.setRole(this.merge(history.getRole(), link.getRole()));
            update.add(history);
        }
        this.invitedUserHistoryCrudService.saveAll(update);
    }

    private String merge(String exist, String addition) {
        ArrayList<GeneralParametersVO> result = new ArrayList<GeneralParametersVO>(GeneralParametersVO.parseList(exist));
        for (GeneralParametersVO newOne : GeneralParametersVO.parseList(addition)) {
            if (!result.stream().noneMatch(a -> a.getId().equals(newOne.getId()))) continue;
            result.add(newOne);
        }
        return JsonUtils.objToJson(result);
    }

    private void createNewInviteHistory(InvitedUserLink link, InviteUserLinkPageVO body) {
        InvitedUserHistory invitedUserHistory = new InvitedUserHistory();
        invitedUserHistory.setApp(link.getApp());
        invitedUserHistory.setRole(link.getRole());
        invitedUserHistory.setOrg(link.getOrg());
        invitedUserHistory.setTenantSid(link.getTenantSid());
        invitedUserHistory.setUserSid(body.getUserSid());
        invitedUserHistory.setAcceptedstatus(IamConstants.AcceptedStatus.ApplyWaitAgree.name());
        invitedUserHistory.setType(true);
        invitedUserHistory.setUserType(link.getUserType());
        invitedUserHistory.setRequestDate(LocalDateTime.now());
        invitedUserHistory.setMode("userId");
        this.invitedUserHistoryCrudService.create(invitedUserHistory);
    }
}

