/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.invoiceinfo.impl;

import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceInfoVO;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceType;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.SourceType;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.entity.TenantCertification;
import com.digiwin.dap.middleware.iam.repository.InvoiceInfoRepository;
import com.digiwin.dap.middleware.iam.repository.InvoiceIntraCompanyRepository;
import com.digiwin.dap.middleware.iam.repository.TenantCertificationRepository;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceDataSyncService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceIntraCompanyCrudService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class InvoiceDataSyncServiceImpl
implements InvoiceDataSyncService {
    private static final Logger logger = LoggerFactory.getLogger(InvoiceDataSyncServiceImpl.class);
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private InvoiceInfoRepository invoiceInfoRepository;
    @Autowired
    private InvoiceInfoCrudService invoiceInfoCrudService;
    @Autowired
    private TenantCertificationRepository tenantCertificationRepository;
    @Autowired
    private InvoiceIntraCompanyCrudService invoiceIntraCompanyCrudService;
    @Autowired
    private InvoiceIntraCompanyRepository invoiceIntraCompanyRepository;

    @Override
    public void certificationToInvoiceInfo(TenantCertification tenantCertification, String area) {
        InvoiceInfo invoiceInfo = this.invoiceInfoRepository.getByTenantSid(tenantCertification.getTenantSid());
        if (invoiceInfo != null) {
            if (invoiceInfo.getSource() == SourceType.INTRA_COMPANY) {
                boolean needChange = false;
                if (StringUtils.isEmpty((Object)invoiceInfo.getInvoiceTitle())) {
                    invoiceInfo.setInvoiceTitle(tenantCertification.getName());
                    needChange = true;
                }
                if ("TW".equals(area)) {
                    if (StringUtils.isEmpty((Object)invoiceInfo.getTaxCode())) {
                        invoiceInfo.setTaxCode(tenantCertification.getBusinessAccountingNo());
                        invoiceInfo.setInvoiceType(InvoiceType.TRIPLET);
                        needChange = true;
                    }
                } else {
                    if (StringUtils.isEmpty((Object)invoiceInfo.getBankName())) {
                        invoiceInfo.setBankName(tenantCertification.getSubbranch());
                        needChange = true;
                    }
                    if (StringUtils.isEmpty((Object)invoiceInfo.getBankAccount())) {
                        invoiceInfo.setBankAccount(tenantCertification.getAccountNo());
                        needChange = true;
                    }
                }
                if (needChange) {
                    this.invoiceInfoCrudService.update(invoiceInfo);
                }
            } else {
                this.tenantCertificationToInvoiceInfo(invoiceInfo, tenantCertification, area);
                this.invoiceInfoCrudService.update(invoiceInfo);
            }
        } else {
            invoiceInfo = new InvoiceInfo();
            invoiceInfo.setTenantSid(tenantCertification.getTenantSid());
            invoiceInfo.setInvoiceType(InvoiceType.ENTERPRISE_VAT_ORDINARY_INVOICE);
            this.tenantCertificationToInvoiceInfo(invoiceInfo, tenantCertification, area);
            this.invoiceInfoCrudService.create(invoiceInfo);
        }
    }

    @Override
    public void invoiceDataSyncFromIntraCompany(List<InvoiceInfoVO> invoiceInfoVOS) {
        invoiceInfoVOS.forEach(invoiceInfoVO -> {
            if (!StringUtils.isEmpty((Object)invoiceInfoVO.getCustomerId())) {
                Long tenantSid = this.tenantRepository.findSidFirstByCustomerId(invoiceInfoVO.getCustomerId());
                if (tenantSid == null) {
                    if (!this.invoiceIntraCompanyRepository.existsByCustomerId(invoiceInfoVO.getCustomerId())) {
                        this.invoiceIntraCompanyCrudService.create(invoiceInfoVO.generateInvoiceIntraCompany());
                    }
                    return;
                }
                try {
                    if (this.invoiceInfoRepository.existsByTenantSid(tenantSid)) {
                        long sid = this.invoiceInfoRepository.findSidByTenantSid(tenantSid);
                        invoiceInfoVO.setTenantSid(tenantSid);
                        invoiceInfoVO.setSid(sid);
                        invoiceInfoVO.setSource(SourceType.INTRA_COMPANY);
                        this.invoiceInfoCrudService.update(invoiceInfoVO.generateInvoiceInfo(), true);
                    } else {
                        invoiceInfoVO.setTenantSid(tenantSid);
                        invoiceInfoVO.setSource(SourceType.INTRA_COMPANY);
                        this.invoiceInfoCrudService.create(invoiceInfoVO.generateInvoiceInfo());
                    }
                }
                catch (Exception e) {
                    logger.error("\u53d1\u7968Sid:" + invoiceInfoVO.getSid() + e.getMessage());
                }
            }
        });
    }

    @Override
    public void invoiceDataSyncFromCertification(String area) {
        List<TenantCertification> tenantCertifications = this.tenantCertificationRepository.findByPassed(true);
        tenantCertifications.forEach(tenantCertification -> this.certificationToInvoiceInfo((TenantCertification)((Object)tenantCertification), area));
    }

    private void tenantCertificationToInvoiceInfo(InvoiceInfo invoiceInfo, TenantCertification tenantCertification, String area) {
        invoiceInfo.setInvoiceTitle(tenantCertification.getName());
        invoiceInfo.setSource(SourceType.CERTIFICATION);
        invoiceInfo.setCategory("COMPANY");
        if ("TW".equals(area)) {
            invoiceInfo.setTaxCode(tenantCertification.getBusinessAccountingNo());
            invoiceInfo.setInvoiceType(InvoiceType.TRIPLET);
        } else {
            invoiceInfo.setBankName(tenantCertification.getSubbranch());
            invoiceInfo.setBankAccount(tenantCertification.getAccountNo());
        }
    }
}

