/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.invoiceinfo.impl;

import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceInfoVO;
import com.digiwin.dap.middleware.iam.domain.invoiceinfo.InvoiceReceiversVO;
import com.digiwin.dap.middleware.iam.entity.InvoiceInfo;
import com.digiwin.dap.middleware.iam.repository.InvoiceInfoRepository;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoCrudService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceInfoService;
import com.digiwin.dap.middleware.iam.service.invoiceinfo.InvoiceReceiversService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class InvoiceInfoServiceImpl
implements InvoiceInfoService {
    @Autowired
    private InvoiceInfoRepository invoiceInfoRepository;
    @Autowired
    private InvoiceInfoCrudService invoiceInfoCrudService;
    @Autowired
    private InvoiceReceiversService invoiceReceiversService;

    @Override
    public InvoiceInfoVO getInvoiceInfoContainReceiver(long tenantSid) {
        InvoiceInfo invoiceInfo = this.invoiceInfoRepository.getByTenantSid(tenantSid);
        if (invoiceInfo == null) {
            return null;
        }
        InvoiceInfoVO invoiceInfoVO = new InvoiceInfoVO();
        invoiceInfoVO.generateInvoiceInfoVO(invoiceInfo);
        List<InvoiceReceiversVO> invoiceReceiversVOS = this.invoiceReceiversService.getInvoiceReceiversVOs(invoiceInfo.getSid());
        invoiceInfoVO.setReceivers(invoiceReceiversVOS);
        return invoiceInfoVO;
    }

    @Override
    public boolean checkTenantHavePermission(long invoiceInfoSid, long tenantSid) {
        InvoiceInfo invoiceInfo = (InvoiceInfo)this.invoiceInfoCrudService.findBySid(invoiceInfoSid);
        return invoiceInfo.getTenantSid() == tenantSid;
    }
}

