/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.OperateException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.UserTypeEnum;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEocService;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdTenantInfoDTO;
import com.digiwin.dap.middleware.iam.support.remote.domain.ad.AdUser;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import java.util.Collections;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Order(value=11)
@Service(value="adIdentityService")
public class AdIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    private static final Logger logger = LoggerFactory.getLogger(AdIdentityServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private PasswordEncoder iamPasswordEncoder;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private RemoteEocService remoteEocService;
    @Autowired
    private ThreadPoolTaskExecutor dapTaskExecutor;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        boolean needCreate = loginUser.getUser() == null;
        Assert.notNull((Object)loginUser, (String)"loginUser\u53c2\u6570\u4e3anull");
        boolean isAdEncrypt = true;
        if (!ObjectUtils.isEmpty((Object)loginUser.getPasswordHash())) {
            if (!ObjectUtils.isEmpty((Object)loginUser.getClientEncryptPublicKey())) {
                try {
                    String clientPublicKey = loginUser.getClientEncryptPublicKey();
                    String passwordHash = loginUser.getPasswordHash();
                    loginUser.setPassword(PwdUtils.getPassWord((String)passwordHash, (String)clientPublicKey, (String)KeyConstant.BASE64_PRIVATE_KEY));
                }
                catch (OperateException ex) {
                    isAdEncrypt = false;
                    logger.error("AD\u767b\u5f55\u89e3\u5bc6\u5f02\u5e38");
                }
            } else {
                isAdEncrypt = false;
            }
        }
        if (ObjectUtils.isEmpty((Object)loginUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_ID_NOT_EMPTY);
        }
        if (ObjectUtils.isEmpty((Object)loginUser.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_TENANT_ID_EMPTY);
        }
        String passwordHash = loginUser.getPasswordHash();
        if (!ObjectUtils.isEmpty((Object)loginUser.getPassword())) {
            passwordHash = this.iamPasswordEncoder.encode((CharSequence)loginUser.getPassword());
        }
        if (ObjectUtils.isEmpty((Object)passwordHash)) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_ID_NOT_EMPTY);
        }
        Tenant tenant = loginUser.getTenant();
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, (Object[])new String[]{loginUser.getTenantId()});
        }
        if (!tenant.isAdLogin()) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_TENANT_AD_LOGIN_DISABLED_ERROR, new Object[]{loginUser.getTenantId()});
        }
        if (isAdEncrypt) {
            AdUser adUser = this.ldapService.getAdUser(loginUser, tenant);
            if (adUser == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21011);
            }
            User user = this.getUser(loginUser, adUser, tenant);
            loginUser.setUser(user);
            loginUser.setTenant(tenant);
            loginUser.setLoginSource(LoginSource.loginAd);
            IamAuthoredUser iamAuthoredUser = this.authoredUserService.generate(loginUser, false, false);
            if (needCreate && tenant.isEoc()) {
                logger.info("\u540c\u6b65\u79df\u6237{}\u7684AD\u7528\u6237 -> EOC\u5458\u5de5{}", (Object)tenant.getId(), (Object)adUser);
                this.dapTaskExecutor.execute(() -> this.remoteEocService.syncAdUser(new AdTenantInfoDTO(StringUtil.getAdCompanyId(null, adUser), Collections.singletonList(adUser), null), iamAuthoredUser.getToken()));
            }
            return iamAuthoredUser;
        }
        throw new BusinessException((ErrorHandler)I18nError.IAM_LOGIN_AD_AUTH_FAIL_ERROR);
    }

    private User getUser(LoginUser loginUser, AdUser adUser, Tenant tenant) {
        String userId = String.format("%s$%s", loginUser.getTenantId(), loginUser.getUserId());
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            user = new User();
            if (Strings.isBlank((String)loginUser.getPasswordHash())) {
                loginUser.setPasswordHash(this.iamPasswordEncoder.encode((CharSequence)loginUser.getPassword()));
            }
            user.setName(adUser.getName());
            user.setNickname(adUser.getDisplayName());
            user.setTelephone(adUser.getTelephoneNumber() != null ? adUser.getTelephoneNumber() : null);
            user.setPhone(adUser.getMobile());
            user.setEmail(adUser.getMail());
            user.setId(userId);
            user.setPassword(loginUser.getPasswordHash());
            user.setActivated(true);
            user.setChanged(true);
            user.setComeFrom(IdentityType.ad.name());
            user.setType(UserTypeEnum.INTERNAL.ordinal());
            user.setEnterprise(true);
            this.userCrudService.create((BaseEntity)user);
        } else if (!IdentityType.ad.name().equals(user.getComeFrom())) {
            user.setComeFrom(IdentityType.ad.name());
            this.userCrudService.update((BaseEntity)user);
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            userInTenant = new UserInTenant();
            userInTenant.setUserSid(user.getSid());
            userInTenant.setTenantSid(tenant.getSid());
            this.userInTenantCrudService.create(userInTenant);
        }
        return user;
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.ad;
    }
}

