/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.authorization.record.ServiceAuthorizationRecordVO;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.service.authorization.code.ServiceAuthorizationCodeService;
import com.digiwin.dap.middleware.iam.service.service.authorization.record.ServiceAuthorizationRecordService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdExecution;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Order(value=9)
@Service(value="agentIdentityService")
public class AgentIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private LdapService ldapService;
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private ServiceAuthorizationCodeService serviceAuthorizationCodeService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private ServiceAuthorizationRecordService serviceAuthorizationRecordService;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        IamAuthoredUser authoredUser;
        loginUser.setLoginSource(LoginSource.agent);
        Sys sys = loginUser.getApp();
        String userId = loginUser.getUserId();
        User user = userId.contains("$") ? (User)this.userCrudService.findById(userId) : this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), 0);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USERNAME_PASSWORD_ERROR, new Object[]{loginUser.getUserId()});
        }
        if (StringUtils.isEmpty((Object)loginUser.getAgentToken())) {
            loginUser.setPassword(PwdUtils.getPassWord((String)loginUser.getPasswordHash(), (String)loginUser.getClientEncryptPublicKey(), (String)KeyConstant.BASE64_PRIVATE_KEY));
            String adCode = userId.toLowerCase().endsWith("@digiwin.com") ? loginUser.getUserId().split("@")[0] : userId;
            AdExecution adUser = this.ldapService.checkAccount(adCode, loginUser.getPassword(), this.envProperties.getCountry());
            if (adUser.getInfo() == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21011);
            }
            loginUser.setUserId(adUser.getInfo().getMail());
            List<ServiceAuthorizationRecordVO> recordVOS = this.serviceAuthorizationCodeService.getProxyUsers(loginUser.getAgentAuthorizationCode());
            if (recordVOS.isEmpty()) {
                throw new BusinessException((ErrorHandler)I18nError.AUTHORIZE_CODE_NO_USER, new Object[]{loginUser.getAgentAuthorizationCode()});
            }
            String tenantId = recordVOS.get(0).getTenantId();
            this.getTenant(tenantId, user, sys, loginUser, false);
            loginUser.setRecordVOS(recordVOS);
            authoredUser = this.authoredUserService.getProxyUsers(loginUser, sys);
        } else {
            IamAuthoredUser agentAuthoredUser = (IamAuthoredUser)RedisUtils.get((Object)LoginUser.agentTokenKey(loginUser.getAgentToken()), IamAuthoredUser.class);
            if (agentAuthoredUser == null) {
                throw new BusinessException((ErrorHandler)I18nError.AGENT_TOKEN_DISABLE);
            }
            if (sys == null ? !StringUtils.isEmpty((Object)agentAuthoredUser.getAppId()) : !sys.getId().equals(agentAuthoredUser.getAppId())) {
                throw new BusinessException((ErrorHandler)I18nError.AGENT_USER_ERROR);
            }
            String serviceAuthCode = agentAuthoredUser.getAgentAuthorizationCode();
            Boolean canAgent = this.serviceAuthorizationRecordService.checkCanAgent(serviceAuthCode, loginUser.getUserId());
            if (!canAgent.booleanValue()) {
                throw new BusinessException((ErrorHandler)I18nError.AGENT_USER_DISABLE, new Object[]{loginUser.getUserId()});
            }
            this.getTenant(agentAuthoredUser.getTenantId(), user, sys, loginUser, true);
            loginUser.setAgentUserId(agentAuthoredUser.getUserId());
            loginUser.setAgentAuthorizationCode(agentAuthoredUser.getAgentAuthorizationCode());
            authoredUser = this.authoredUserService.generate(loginUser, false, false);
            authoredUser.setAgentUserId(null);
            authoredUser.setAgentAuthorizationCode(null);
        }
        return authoredUser;
    }

    private void getTenant(String tenantId, User user, Sys sys, LoginUser loginUser, boolean checkUserTenant) {
        AuthResult authResult = AuthResult.of();
        Tenant tenant = (Tenant)this.tenantCrudService.findById(tenantId);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, new Object[]{tenantId});
        }
        if (checkUserTenant) {
            UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
            if (userInTenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_TENANT, new Object[]{user.getId(), tenant.getName()});
            }
            if (userInTenant.isDisabled() || userInTenant.isDeleted()) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21004);
            }
            if (sys != null) {
                boolean exists = this.commonCacheService.existsBySysIdAndTenantId(sys.getId(), tenant.getId());
                if (!exists) {
                    authResult.setAuthType(AuthType.AppNone);
                }
                this.authoredUserService.checkCanUseApp(authResult, tenantId, user.getId(), sys);
            } else {
                authResult.setAuthType(AuthType.AppNone);
            }
        }
        loginUser.setUser(user);
        loginUser.setTenant(tenant);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return IdentityType.agent == loginUser.getIdentityType();
    }
}

