/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=4)
@Service(value="allIdentityService")
public class AllIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    private static final Logger log = LoggerFactory.getLogger(AllIdentityServiceImpl.class);
    @Autowired
    private List<IdentityService> identityServices;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        for (IdentityService identityService : this.identityServices) {
            if (identityService instanceof AllIdentityServiceImpl) continue;
            try {
                return identityService.login(loginUser);
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.all;
    }
}

