/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.alibaba.nacos.shaded.com.google.common.collect.Lists;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredDevice;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.auth.AuthoredUser;
import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.domain.CommonErrorCode;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.exception.UnauthorizedException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.IamConstants;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.oauth.OauthScopeApiVO;
import com.digiwin.dap.middleware.iam.domain.tenant.TenantRelevantInfoVO;
import com.digiwin.dap.middleware.iam.domain.token.GrantTypeInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserAndTenantSimpleInfo;
import com.digiwin.dap.middleware.iam.domain.user.UserMetadataVO;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.SysInTenant;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMappingMapper;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInRoleQueryService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.RamService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.validate.LoginCheckService;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.bitwalker.useragentutils.DeviceType;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Primary
@Service
public class AuthoredLoginUserServiceImpl
implements AuthoredUserService {
    private static final Logger logger = LoggerFactory.getLogger(AuthoredLoginUserServiceImpl.class);
    private static ObjectMapper objectMapper = JsonUtils.createObjectMapper();
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private AuthoredUserService authoredUserService;
    @Autowired(required=false)
    private RamService ramService;
    @Autowired
    private UserInRoleQueryService userInRoleQueryService;
    @Autowired
    private WhiteListService whiteListService;
    @Autowired
    private UserMappingMapper userMappingMapper;
    @Autowired
    private LoginCheckService loginCheckService;
    @Autowired
    private UserInTenantMapper userInTenantMapper;

    @Override
    public IamAuthoredUser generate(LoginUser loginUser, Boolean checkAuth, Boolean doubleCheck) {
        long tokenExpire = this.getTokenExpire(loginUser);
        return this.generate(loginUser, checkAuth, doubleCheck, tokenExpire);
    }

    @Override
    public IamAuthoredUser generate(LoginUser loginUser, Boolean checkAuth, Boolean doubleCheck, long tokenExpire) {
        boolean needDoubleCheck;
        loginUser.afterPropertiesSet();
        if (checkAuth.booleanValue()) {
            this.checkCanUseApp(AuthResult.of(), loginUser.getTenantId(), loginUser.getUserId(), loginUser.getApp());
        }
        IamAuthoredUser authoredUser = null;
        String tokenKey = null;
        String loginKey = loginUser.uniqueKey();
        String userToken = (String)RedisUtils.get((Object)loginKey, String.class);
        if (userToken != null) {
            tokenKey = LoginUser.tokenKey(userToken);
            authoredUser = (IamAuthoredUser)RedisUtils.get((Object)tokenKey, IamAuthoredUser.class);
        }
        if (authoredUser != null) {
            boolean notAllowMultiLogin;
            String cacheLoginKey;
            if (loginUser.getUserSid() != authoredUser.getSid() || loginUser.getTenantSid() != authoredUser.getTenantSid()) {
                authoredUser.setSid(loginUser.getUserSid());
                authoredUser.setTenantSid(loginUser.getTenantSid());
                RedisUtils.set((String)tokenKey, (Object)authoredUser);
            }
            if (!loginKey.equals(cacheLoginKey = LoginUser.uniqueKey(authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getAppId(), authoredUser.getDeviceType(), loginUser.getIdentityType(), loginUser.getAgentUserId(), authoredUser.getDevice(), loginUser.getSysMultiLogin())) || !userToken.equals(authoredUser.getToken())) {
                logger.warn("\u7528\u6237\u7f13\u5b58\u4fe1\u606f\u4e0d\u4e00\u81f4\uff0cloginKey:{}, tokenKey:{}", (Object)loginKey, (Object)tokenKey);
                RedisUtils.set((String)tokenKey.replace("token", "exception"), (Object)authoredUser);
                authoredUser = this.generate(loginUser, loginKey, tokenKey, tokenExpire);
            }
            boolean bl = notAllowMultiLogin = loginUser.getSysMultiLogin() == false && loginUser.getDeviceType() == authoredUser.getDeviceType() && IdentityType.secretKey != loginUser.getIdentityType() && !Arrays.asList(this.envProperties.getKickedAllowUsers().split(",")).contains(loginUser.getUserId());
            if (notAllowMultiLogin) {
                authoredUser.setKickedTime(LocalDateTime.now());
                authoredUser.setKicked(true);
                RedisUtils.delete((String)loginKey);
                RedisUtils.set((String)tokenKey, (Object)authoredUser, (Duration)Duration.ofDays(1L));
                authoredUser = null;
            }
        }
        if (authoredUser == null) {
            tokenKey = LoginUser.tokenKey(UUID.randomUUID().toString());
            authoredUser = this.generate(loginUser, loginKey, tokenKey, tokenExpire);
        } else {
            this.resetAuthoredUser(authoredUser);
        }
        boolean bl = needDoubleCheck = doubleCheck != false && loginUser.getSysDoubleCheck() != false && loginUser.doubleCheckEnabledByTenantAndUser() && !RedisUtils.hasKey((String)loginUser.verificationSuccessKey());
        if (needDoubleCheck) {
            String verificationTokenKey = LoginUser.verificationTokenKey(authoredUser.getToken());
            authoredUser.setNeedVerificationCode(true);
            authoredUser.setUserToken(authoredUser.getToken());
            authoredUser.setIdentityCodeAcceptType(loginUser.decideIdentityCodeAcceptType());
            authoredUser.setSetBy(loginUser.decideDoubleCheckSetBy());
            RedisUtils.delete((String)tokenKey);
            RedisUtils.set((String)verificationTokenKey, (Object)authoredUser, (Duration)Duration.ofDays(1L));
        } else {
            authoredUser.renewal(tokenKey, tokenExpire, null, this.envProperties.getCustomizeTokenExpired());
        }
        this.resetUserMetadata(authoredUser);
        authoredUser.fixData(this.envProperties.getDeployArea());
        return authoredUser;
    }

    private IamAuthoredUser generate(LoginUser loginUser, String loginKey, String tokenKey, long tokenExpire) {
        IamAuthoredUser authoredUser = IamAuthoredUser.createAuthoredUser(loginUser.getUser(), loginUser.getTenant());
        authoredUser.setAppId(loginUser.getSysId());
        authoredUser.setShared(loginUser.getSysMultiLogin());
        authoredUser.setDeviceType(loginUser.getDeviceType());
        authoredUser.setIdentityType(loginUser.getIdentityType());
        authoredUser.setTokenExpiresAt(System.currentTimeMillis() + Duration.ofMinutes(tokenExpire).toMillis());
        authoredUser.setTokenExpiresIn(tokenExpire * 60L * 1000L);
        authoredUser.setToken(tokenKey.replace("iam:token:", ""));
        authoredUser.setLoginInfo(loginKey);
        authoredUser.setLoginSource(loginUser.getLoginSource());
        authoredUser.setDevice(loginUser.getDevice());
        authoredUser.setTokenExpireSysId(loginUser.getTokenExpireSysId());
        if (loginKey.startsWith("iam:login:agent:key:")) {
            authoredUser.setAgentAuthorizationCode(loginUser.getAgentAuthorizationCode());
            authoredUser.setAgentUserId(loginUser.getAgentUserId());
            RedisUtils.set((String)tokenKey, (Object)authoredUser, (Duration)Duration.ofHours(4L));
            RedisUtils.set((String)loginKey, (Object)authoredUser.getToken(), (Duration)Duration.ofHours(4L));
            RedisUtils.opsForList().rightPush((Object)LoginUser.agentListKey(authoredUser.getTenantId(), authoredUser.getUserId()), (Object)loginKey);
        } else if (IdentityType.crossRegion == loginUser.getIdentityType()) {
            authoredUser.setTokenExpiresIn(Duration.ofDays(1L).toMillis());
            authoredUser.setTokenExpiresAt(System.currentTimeMillis() + Duration.ofDays(1L).toMillis());
            RedisUtils.set((String)tokenKey, (Object)authoredUser, (Duration)Duration.ofDays(1L));
            RedisUtils.set((String)loginKey, (Object)authoredUser.getToken(), (Duration)Duration.ofDays(1L));
        } else {
            RedisUtils.set((String)tokenKey, (Object)authoredUser, (Duration)Duration.ofMinutes(tokenExpire));
            RedisUtils.set((String)loginKey, (Object)authoredUser.getToken(), (Duration)Duration.ofMinutes(tokenExpire));
        }
        return authoredUser;
    }

    @Override
    public void resetAuthoredUser(IamAuthoredUser authoredUser) {
        User user = this.commonCacheService.getUserBySid(authoredUser.getSid());
        if (Objects.isNull((Object)user)) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{authoredUser.getUserId()});
        }
        Tenant tenant = this.commonCacheService.getTenantBySid(authoredUser.getTenantSid());
        Sys sys = this.commonCacheService.getSysById(authoredUser.getAppId());
        authoredUser.updateUser(user);
        authoredUser.updateTenant(tenant);
        authoredUser.updateSys(sys);
    }

    @Override
    public void resetUserMetadata(IamAuthoredUser authoredUser) {
        List<UserMetadataVO> metadataCurrent = this.commonCacheService.getMetadata(authoredUser.getTenantSid(), authoredUser.getSid());
        List<UserMetadataVO> metadataDefault = this.commonCacheService.getMetadata(0L, authoredUser.getSid());
        authoredUser.setMetadata(metadataCurrent);
        authoredUser.getMetadata().addAll(metadataDefault);
        authoredUser.setAcceptLanguage(null);
        Optional<UserMetadataVO> currentMetadata = metadataCurrent.stream().filter(p -> "basic".equals(p.getCatalogId()) && "dapAcceptLanguage".equals(p.getKey())).findFirst();
        if (currentMetadata.isPresent()) {
            authoredUser.setAcceptLanguage(currentMetadata.get().getValue());
        } else {
            Optional<UserMetadataVO> defaultMetadata = metadataDefault.stream().filter(p -> "basic".equals(p.getCatalogId()) && "dapAcceptLanguage".equals(p.getKey())).findFirst();
            defaultMetadata.ifPresent(p -> authoredUser.setAcceptLanguage(p.getValue()));
        }
    }

    @Override
    public IamAuthoredUser getByUserToken(String userToken) {
        String tokenKey = LoginUser.tokenKey(userToken);
        IamAuthoredUser authoredUser = (IamAuthoredUser)RedisUtils.get((Object)tokenKey, IamAuthoredUser.class);
        if (authoredUser == null) {
            throw new BusinessException((ErrorHandler)CommonErrorCode.USER_TOKEN_INVALID, String.format("\u89e3\u6790UserToken[%s]\u4e3anull", userToken));
        }
        if (authoredUser.isKicked()) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_KICKED_ERROR, new Object[]{authoredUser.getKickedTime()});
        }
        this.checkUserInTenant(authoredUser.getSid(), authoredUser.getUserId(), authoredUser.getTenantSid(), authoredUser.getTenantId());
        this.resetAuthoredUser(authoredUser);
        if (authoredUser.getTokenExpiresAt() > 0L) {
            authoredUser.setTokenExpiresIn(authoredUser.getTokenExpiresAt() - System.currentTimeMillis());
        }
        authoredUser.renewal(tokenKey, null, this::getTokenExpire, this.envProperties.getCustomizeTokenExpired());
        return authoredUser;
    }

    @Override
    public long getTokenExpire(IamAuthoredUser iamAuthoredUser) {
        long tokenExpire = this.envProperties.getTokenExpire();
        if ("WHALE".equalsIgnoreCase(iamAuthoredUser.getAppId())) {
            iamAuthoredUser.setDeviceType(DeviceType.MOBILE);
        }
        if (this.envProperties.getCustomizeTokenExpired().booleanValue()) {
            if ("virtual".equalsIgnoreCase(iamAuthoredUser.getUserId()) || "integration".equalsIgnoreCase(iamAuthoredUser.getUserId()) || DeviceType.MOBILE.equals((Object)iamAuthoredUser.getDeviceType()) || IamConstants.ALLOW_LONG_TOKEN_SOURCE.contains(Optional.ofNullable(iamAuthoredUser.getDevice()).map(AuthoredDevice::getSourceType).orElse(null))) {
                tokenExpire = this.envProperties.getTokenExpire();
            } else {
                tokenExpire = IamConstants.TOKEN_MIN_MINUTES;
                Sys sys = this.commonCacheService.getSysById(iamAuthoredUser.getAppId());
                if (Objects.isNull((Object)sys)) {
                    return IamConstants.TOKEN_MAX_MINUTES;
                }
                if (sys.isCustomizeTokenExpired()) {
                    SysInTenant sysInTenant;
                    iamAuthoredUser.setTokenExpireSysId(sys.getId());
                    tokenExpire = sys.isAllowTenantAdjustTime() ? (Objects.nonNull((Object)(sysInTenant = this.commonCacheService.getSysInTenant(sys.getId(), iamAuthoredUser.getTenantSid()))) && sysInTenant.isTokenExpireAdjusted() ? sysInTenant.getTokenExpire() : sys.getTokenExpire()) : sys.getTokenExpire();
                } else {
                    List<String> whiteList = this.whiteListService.getWhiteList("APPS_TOKEN_EXPIRE");
                    Map<String, Long> whiteAppMap = whiteList.stream().map(e -> e.split(":")).filter(split -> ((String[])split).length == 2).collect(Collectors.toMap(split -> split[0].toUpperCase(), split -> Long.valueOf(split[1])));
                    if (whiteAppMap.containsKey(sys.getId().toUpperCase())) {
                        iamAuthoredUser.setTokenExpireSysId(sys.getId());
                        tokenExpire = whiteAppMap.get(sys.getId().toUpperCase());
                    } else {
                        String tokenExpireSysId = iamAuthoredUser.getTokenExpireSysId();
                        if (StringUtils.hasText((String)tokenExpireSysId)) {
                            Sys tokenExpireSys = this.commonCacheService.getSysById(tokenExpireSysId);
                            if (Objects.nonNull((Object)tokenExpireSys) && tokenExpireSys.isCustomizeTokenExpired()) {
                                SysInTenant sysInTenant;
                                tokenExpire = tokenExpireSys.isAllowTenantAdjustTime() ? (Objects.nonNull((Object)(sysInTenant = this.commonCacheService.getSysInTenant(tokenExpireSys.getId(), iamAuthoredUser.getTenantSid()))) && sysInTenant.isTokenExpireAdjusted() ? sysInTenant.getTokenExpire() : tokenExpireSys.getTokenExpire()) : tokenExpireSys.getTokenExpire();
                            } else if (whiteAppMap.containsKey(tokenExpireSysId.toUpperCase())) {
                                tokenExpire = whiteAppMap.get(tokenExpireSysId.toUpperCase());
                            } else {
                                iamAuthoredUser.setTokenExpireSysId(null);
                            }
                        }
                    }
                }
            }
        }
        return tokenExpire;
    }

    @Override
    public long getTokenExpire(LoginUser loginUser) {
        loginUser.afterPropertiesSet();
        long tokenExpire = this.envProperties.getTokenExpire();
        if (Objects.nonNull((Object)loginUser.getApp()) && "WHALE".equalsIgnoreCase(loginUser.getApp().getId())) {
            loginUser.setDeviceType(DeviceType.MOBILE);
        }
        if (this.envProperties.getCustomizeTokenExpired().booleanValue()) {
            if ("virtual".equalsIgnoreCase(loginUser.getUser().getId()) || "integration".equalsIgnoreCase(loginUser.getUser().getId()) || DeviceType.MOBILE.equals((Object)loginUser.getDeviceType()) || IamConstants.ALLOW_LONG_TOKEN_SOURCE.contains(Optional.ofNullable(loginUser.getDevice()).map(AuthoredDevice::getSourceType).orElse(null))) {
                tokenExpire = this.envProperties.getTokenExpire();
            } else {
                tokenExpire = IamConstants.TOKEN_MIN_MINUTES;
                Sys sys = loginUser.getApp();
                if (Objects.isNull((Object)sys)) {
                    return IamConstants.TOKEN_MAX_MINUTES;
                }
                if (sys.isCustomizeTokenExpired()) {
                    SysInTenant sysInTenant;
                    loginUser.setTokenExpireSysId(sys.getId());
                    tokenExpire = sys.isAllowTenantAdjustTime() ? (Objects.nonNull((Object)(sysInTenant = this.commonCacheService.getSysInTenant(sys.getId(), loginUser.getTenantSid()))) && sysInTenant.isTokenExpireAdjusted() ? sysInTenant.getTokenExpire() : sys.getTokenExpire()) : sys.getTokenExpire();
                } else {
                    List<String> whiteList = this.whiteListService.getWhiteList("APPS_TOKEN_EXPIRE");
                    Map<String, Long> whiteAppMap = whiteList.stream().map(e -> e.split(":")).filter(split -> ((String[])split).length == 2).collect(Collectors.toMap(split -> split[0].toUpperCase(), split -> Long.valueOf(split[1])));
                    if (whiteAppMap.containsKey(sys.getId().toUpperCase())) {
                        loginUser.setTokenExpireSysId(sys.getId());
                        tokenExpire = whiteAppMap.get(sys.getId().toUpperCase());
                    } else {
                        String tokenExpireSysId = loginUser.getTokenExpireSysId();
                        if (StringUtils.hasText((String)tokenExpireSysId)) {
                            Sys tokenExpireSys = this.commonCacheService.getSysById(tokenExpireSysId);
                            if (Objects.nonNull((Object)tokenExpireSys) && tokenExpireSys.isCustomizeTokenExpired()) {
                                SysInTenant sysInTenant;
                                tokenExpire = tokenExpireSys.isAllowTenantAdjustTime() ? (Objects.nonNull((Object)(sysInTenant = this.commonCacheService.getSysInTenant(tokenExpireSys.getId(), loginUser.getTenantSid()))) && sysInTenant.isTokenExpireAdjusted() ? sysInTenant.getTokenExpire() : tokenExpireSys.getTokenExpire()) : tokenExpireSys.getTokenExpire();
                            } else if (whiteAppMap.containsKey(tokenExpireSysId.toUpperCase())) {
                                tokenExpire = whiteAppMap.get(tokenExpireSysId.toUpperCase());
                            } else {
                                loginUser.setTokenExpireSysId(null);
                            }
                        }
                    }
                }
            }
        }
        return tokenExpire;
    }

    @Override
    public void checkCanUseApp(IamAuthoredUser authoredUser, Sys sys) {
        AuthoredSys authoredSys = Sys.loginSys(sys);
        AuthResult authResult = this.ramService.processAuth(AuthResult.of(), authoredUser, authoredSys);
        AuthType.checkAuthResult((AuthType)authResult.getAuthType(), (AuthoredUser)authoredUser, (AuthoredSys)authoredSys);
    }

    @Override
    public String checkCanUseApp(AuthResult authResult, String tenantId, String userId, Sys sys) {
        AuthoredUser authoredUser = new AuthoredUser();
        authoredUser.setUserId(userId);
        authoredUser.setTenantId(tenantId);
        AuthoredSys authoredSys = Sys.loginSys(sys);
        authResult = this.ramService.processAuth(authResult, authoredUser, authoredSys);
        if (Objects.isNull(authResult)) {
            return null;
        }
        AuthType.checkAuthResult((AuthType)authResult.getAuthType(), (AuthoredUser)authoredUser, (AuthoredSys)authoredSys);
        return authResult.getTenantId();
    }

    @Override
    public IamAuthoredUser getByUserToken(String userToken, Sys sys) {
        IamAuthoredUser authoredUser = this.getByUserToken(userToken);
        this.checkCanUseApp(authoredUser, sys);
        return authoredUser;
    }

    @Override
    public IamAuthoredUser getByGrantTypeInfo(GrantTypeInfo grantTypeInfo) {
        Assert.hasText((String)grantTypeInfo.getTenantId(), (String)"grantTypeInfo.tenantId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)grantTypeInfo.getVerifyUserId(), (String)"grantTypeInfo.verifyUserId\u4e0d\u80fd\u4e3a\u7a7a");
        AuthoredSys authoredSys = AppAuthContextHolder.getContext().getAuthoredSys();
        String sysId = "";
        if (!StringUtils.isEmpty((Object)grantTypeInfo.getAppId())) {
            sysId = grantTypeInfo.getAppId();
        } else if (authoredSys != null) {
            sysId = authoredSys.getId();
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(grantTypeInfo.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{grantTypeInfo.getTenantId()});
        }
        List<Long> userSids = this.userMappingMapper.findUserSidsByVerifyUserId(tenant.getSid(), grantTypeInfo.getVerifyUserId(), sysId, grantTypeInfo.getAccount());
        if (userSids == null || userSids.size() == 0) {
            throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_MAPPING_ERROR, new Object[]{grantTypeInfo.getTenantId(), sysId, grantTypeInfo.getVerifyUserId()});
        }
        if (userSids.size() > 1) {
            throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_GRANT_MAPPING_ERROR, new Object[]{grantTypeInfo.getVerifyUserId()});
        }
        User user = (User)this.userCrudService.findBySid(userSids.get(0));
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{userSids.get(0)});
        }
        if (user.isDeleted() || user.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21004);
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_TENANT, new Object[]{user.getId(), tenant.getId()});
        }
        if (userInTenant.isDisabled() || userInTenant.isDeleted()) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_DISABLE_TENANT, new Object[]{tenant.getId(), user.getId()});
        }
        Sys sys = this.commonCacheService.getSysById(sysId);
        boolean checkAuth = true;
        if (sys == null) {
            sys = new Sys();
            sys.setId(sysId);
            checkAuth = false;
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setIdentityType(IdentityType.grant);
        loginUser.setTenant(tenant);
        loginUser.setUser(user);
        loginUser.setApp(sys);
        if (null != grantTypeInfo.getGrantType() && grantTypeInfo.getTokenExpire() != null && grantTypeInfo.getTokenExpire() > 0L) {
            return this.authoredUserService.generate(loginUser, checkAuth, false, grantTypeInfo.getTokenExpire());
        }
        return this.authoredUserService.generate(loginUser, checkAuth, false);
    }

    @Override
    public IamAuthoredUser refreshUserToken(String userToken, Sys sys) {
        return this.getByUserToken(userToken, sys);
    }

    @Override
    public IamAuthoredUser refreshUserTokenInTenant(String userToken, Tenant tenant, Sys sys) {
        IamAuthoredUser authoredUser = this.getByUserToken(userToken);
        this.loginCheckService.checkIP(authoredUser.getIdentityType(), tenant, sys);
        if (tenant != null) {
            if (tenant.getSid() == authoredUser.getTenantSid()) {
                return authoredUser;
            }
            this.checkUserInTenant(authoredUser.getSid(), authoredUser.getUserId(), tenant.getSid(), tenant.getId(), true);
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setTenant(tenant);
        User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
        loginUser.setUser(user);
        loginUser.setApp(sys);
        loginUser.setDeviceType(authoredUser.getDeviceType());
        loginUser.setDevice(authoredUser.getDevice());
        loginUser.setTokenExpireSysId(authoredUser.getTokenExpireSysId());
        loginUser.setLoginSource(LoginSource.refreshTenant);
        return this.authoredUserService.generate(loginUser, true, false);
    }

    private void checkUserInTenant(long userSid, String userId, long tenantSid, String tenantId) {
        this.checkUserInTenant(userSid, userId, tenantSid, tenantId, false);
    }

    private void checkUserInTenant(long userSid, String userId, long tenantSid, String tenantId, boolean securityLog) {
        if (tenantSid == 0L || tenantId == null) {
            return;
        }
        UserInTenant userInTenant = this.commonCacheService.getUserInTenant(tenantSid, userSid);
        if (userInTenant == null) {
            if (securityLog) {
                throw new BusinessException((ErrorHandler)I18nError.IAM_USER_PERMISSION_COMMON_ERROR, new Object[]{UserUtils.getUserName(), userId, AppAuthContextHolder.getContext().getClientIP(), Base64.encode((String)JsonUtils.writeValue((Object)tenantId))});
            }
            throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{tenantId, userId});
        }
        if (userInTenant.isDisabled() || userInTenant.isDeleted()) {
            throw new BusinessException((ErrorHandler)I18nError.TOKEN_USER_DISABLE_TENANT, new Object[]{tenantId, userId});
        }
    }

    @Override
    public IamAuthoredUser refreshUserTokenInSys(String userToken, Sys sys, AuthoredDevice device) {
        IamAuthoredUser authoredUser = this.getByUserToken(userToken);
        LoginUser loginUser = new LoginUser();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        loginUser.setTenant(tenant);
        User user = (User)this.userCrudService.findBySid(authoredUser.getSid());
        loginUser.setUser(user);
        loginUser.setApp(sys);
        loginUser.setDeviceType(authoredUser.getDeviceType());
        loginUser.setDevice(authoredUser.getDevice());
        if (Objects.nonNull(device)) {
            loginUser.setDevice(device);
        }
        loginUser.setTokenExpireSysId(authoredUser.getTokenExpireSysId());
        loginUser.setLoginSource(LoginSource.refreshSys);
        return this.authoredUserService.generate(loginUser, true, false);
    }

    @Override
    public void clear(long tenantSid, long userSid) {
    }

    @Override
    public void clear(long tenantSid, long userSid, String appId) {
    }

    @Override
    public void logout(IamAuthoredUser authoredUser, String appId, boolean clearAll) {
        if (this.envProperties.isTokenExpired().booleanValue()) {
            this.clearUserTokenCache(authoredUser, appId, clearAll);
        }
    }

    private void clearUserTokenCache(IamAuthoredUser authoredUser, String appId, boolean clearAllTenants) {
        List<TenantRelevantInfoVO> allTenantByUser;
        ArrayList<String> tokenKeys = new ArrayList<String>();
        tokenKeys.add(LoginUser.tokenKey(authoredUser.getToken()));
        if (clearAllTenants && !CollectionUtils.isEmpty(allTenantByUser = this.userInTenantMapper.findAllTenantByUser(authoredUser.getSid()))) {
            List<String> loginKeys = allTenantByUser.stream().map(e -> LoginUser.uniqueKey(authoredUser.getUserId(), e.getId(), appId, authoredUser.getDeviceType(), authoredUser.getIdentityType(), authoredUser.getAgentUserId(), authoredUser.getDevice(), authoredUser.isShared())).collect(Collectors.toList());
            tokenKeys.addAll(this.getTokenKeys(loginKeys));
        }
        List partition = Lists.partition(tokenKeys, (int)500);
        partition.forEach(RedisUtils::delete);
    }

    private List<String> getTokenKeys(List<String> loginKeys) {
        ArrayList<String> tokenKeys = new ArrayList<String>();
        if (CollectionUtils.isEmpty(loginKeys)) {
            return tokenKeys;
        }
        List loginKeysPartitions = Lists.partition(loginKeys, (int)500);
        loginKeysPartitions.forEach(list -> {
            List tokenList = RedisUtils.opsForValue().multiGet((Collection)list);
            if (!CollectionUtils.isEmpty((Collection)tokenList)) {
                tokenKeys.addAll(tokenList.stream().filter(Objects::nonNull).map(this::processTokenObject).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        });
        return tokenKeys;
    }

    private String processTokenObject(Object tokenStrObj) {
        try {
            return LoginUser.tokenKey((String)objectMapper.readValue(tokenStrObj.toString(), String.class));
        }
        catch (Exception ex) {
            logger.error("{}Key\u503c\u4e3a:{}\uff0c\u9519\u8bef\u4fe1\u606f\uff1a{}", new Object[]{"\u3010Redis\u5f02\u5e38\u3011", tokenStrObj, ex.getMessage()});
            return null;
        }
    }

    @Override
    public IamAuthoredUser getOauthUser(String userToken, HttpServletRequest request) {
        String tokenKey = String.format("iam:oauth:access:token:%s", userToken);
        IamAuthoredUser authoredUser = (IamAuthoredUser)RedisUtils.get((Object)tokenKey, IamAuthoredUser.class);
        if (authoredUser == null) {
            throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_INVALID, String.format("\u89e3\u6790AccessToken[%s]\u4e3anull", userToken));
        }
        List<OauthScopeApiVO> oauthScopeApis = authoredUser.getAuthoredApis();
        if (oauthScopeApis.isEmpty()) {
            throw new UnauthorizedException((ErrorHandler)I18nError.OAUTH_ACCESS_TOKEN_NO_AUTH);
        }
        List scopeApis = oauthScopeApis.stream().map(OauthScopeApiVO::getApi).collect(Collectors.toList());
        if (!scopeApis.contains(request.getRequestURI())) {
            throw new UnauthorizedException((ErrorHandler)I18nError.OAUTH_ACCESS_TOKEN_NO_AUTH_1, new Object[]{request.getRequestURI()});
        }
        return authoredUser;
    }

    @Override
    public IamAuthoredUser changeUserToken(IamAuthoredUser authoredUser, LoginUser loginUser, Sys sys) {
        List<String> tenants = this.whiteListService.getWhiteList("IAM_URIS_WHITE_TENANTS");
        if (!tenants.isEmpty() && !tenants.contains(authoredUser.getTenantId())) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_CANNOT_OPERATE_USER_AGENT);
        }
        if (null == this.userInRoleQueryService.queryUserInRoleByUserAndRole(authoredUser.getTenantSid(), authoredUser.getSid(), "chang_user_admin")) {
            throw new BusinessException((ErrorHandler)I18nError.USER_CANNOT_AGENT_USER, new Object[]{authoredUser.getUserId()});
        }
        String userId = PwdUtils.getPassWord((String)loginUser.getUserId(), (String)loginUser.getClientEncryptPublicKey(), (String)KeyConstant.BASE64_PRIVATE_KEY);
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{userId});
        }
        if (!this.userInTenantCrudService.existsByUnionKey(authoredUser.getTenantSid(), user.getSid())) {
            throw new BusinessException((ErrorHandler)I18nError.USER_CANNOT_AGENT_USER, new Object[]{userId});
        }
        LoginUser loginInfo = new LoginUser();
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(authoredUser.getTenantSid());
        loginInfo.setTenant(tenant);
        loginInfo.setUser(user);
        loginInfo.setApp(sys);
        loginInfo.setDeviceType(authoredUser.getDeviceType());
        loginInfo.setLoginSource(LoginSource.changeUser);
        this.checkCanUseApp(AuthResult.of(), tenant.getId(), userId, sys);
        IamAuthoredUser iamAuthoredUser = null;
        String agentKey = String.format("iam:user:agent:key:%s:%s:%s:%s", authoredUser.getUserId(), authoredUser.getTenantId(), sys == null || StringUtils.isEmpty((Object)sys.getId()) ? "nonsys" : sys.getId(), userId).toLowerCase();
        String userToken = (String)RedisUtils.get((Object)agentKey, String.class);
        if (userToken != null) {
            String tokenKey = LoginUser.tokenKey(userToken);
            iamAuthoredUser = (IamAuthoredUser)RedisUtils.get((Object)tokenKey, IamAuthoredUser.class);
        }
        if (iamAuthoredUser == null) {
            iamAuthoredUser = this.generate(loginInfo, false, false);
            String token = UUID.randomUUID().toString();
            iamAuthoredUser.setToken(token);
            RedisUtils.set((String)agentKey, (Object)token);
            RedisUtils.set((String)LoginUser.tokenKey(token), (Object)iamAuthoredUser, (Duration)Duration.ofHours(1L));
        }
        return iamAuthoredUser;
    }

    @Override
    public IamAuthoredUser getProxyUsers(LoginUser loginUser, Sys sys) {
        User user = loginUser.getUser();
        Tenant tenant = loginUser.getTenant();
        String sysId = sys == null ? null : sys.getId();
        String agentKey = String.format("iam:agent:key:%s:%s:%s", user.getId(), tenant.getId(), StringUtils.isEmpty((Object)sysId) ? "nonsys" : sysId).toLowerCase();
        String userToken = (String)RedisUtils.get((Object)agentKey, String.class);
        IamAuthoredUser authoredUser = null;
        if (!StringUtils.isEmpty((Object)userToken)) {
            authoredUser = (IamAuthoredUser)RedisUtils.get((Object)LoginUser.agentTokenKey(userToken), IamAuthoredUser.class);
        }
        if (null == authoredUser) {
            authoredUser = IamAuthoredUser.createAuthoredUser(user, tenant);
            authoredUser.setAgentAuthorizationCode(loginUser.getAgentAuthorizationCode());
            authoredUser.setToken(UUID.randomUUID().toString());
            authoredUser.setTokenExpiresIn(600000L);
            authoredUser.setTokenExpiresAt(System.currentTimeMillis() + Duration.ofMinutes(10L).toMillis());
            authoredUser.setAppId(sysId);
            RedisUtils.set((String)agentKey, (Object)authoredUser.getToken());
            RedisUtils.set((String)LoginUser.agentTokenKey(authoredUser.getToken()), (Object)authoredUser, (Duration)Duration.ofMinutes(10L));
        } else if (!loginUser.getAgentAuthorizationCode().equals(authoredUser.getAgentAuthorizationCode())) {
            authoredUser.setAgentAuthorizationCode(loginUser.getAgentAuthorizationCode());
            RedisUtils.set((String)LoginUser.agentTokenKey(authoredUser.getToken()), (Object)authoredUser);
        }
        ArrayList<UserAndTenantSimpleInfo> users = new ArrayList<UserAndTenantSimpleInfo>();
        loginUser.getRecordVOS().forEach(r -> {
            UserAndTenantSimpleInfo userAndTenantSimpleInfo = new UserAndTenantSimpleInfo();
            userAndTenantSimpleInfo.setUserId(r.getUserId());
            userAndTenantSimpleInfo.setUserName(r.getUserName());
            users.add(userAndTenantSimpleInfo);
        });
        authoredUser.setAgentUserList(users);
        return authoredUser;
    }
}

