/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.CardInfo;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.card.CardInfoCrudService;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Order(value=6)
@Service(value="cardKeyIdentityService")
public class CardKeyIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    private static final Logger logger = LoggerFactory.getLogger(CardKeyIdentityServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private CardInfoCrudService cardInfoCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        CardInfo cardInfo;
        if (StringUtils.isEmpty((Object)loginUser.getServiceName())) {
            loginUser.setServiceName("rfid");
        }
        String cardId = loginUser.getSecretKey();
        if (!"rfid".equals(loginUser.getServiceName()) || StringUtils.hasText((String)loginUser.getClientEncryptPublicKey())) {
            try {
                String clientPublicKey = RSA.decrypt((String)loginUser.getClientEncryptPublicKey(), (String)KeyConstant.BASE64_PRIVATE_KEY);
                cardId = PwdUtils.decryptPwd((String)loginUser.getSecretKey(), (String)clientPublicKey);
            }
            catch (Exception ex) {
                throw new BusinessException((ErrorHandler)I18nError.PARAM_ERROR);
            }
        }
        if ((cardInfo = this.cardInfoCrudService.findByIdAndType(cardId, loginUser.getServiceName())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_NO_CARD, new Object[]{cardId});
        }
        UserInTenant userInTenant = (UserInTenant)this.userInTenantCrudService.findBySid(cardInfo.getUserTenantSid());
        if (userInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.IAM_CARD_NOT_BIND, new Object[]{cardInfo.getType(), cardInfo.getId()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findBySid(userInTenant.getTenantSid());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.CARD_BIND_RECORD_NOT_EXIST, new Object[]{cardInfo.getType(), cardInfo.getId(), userInTenant.getTenantSid()});
        }
        User user = (User)this.userCrudService.findBySid(userInTenant.getUserSid());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.CARD_BIND_RECORD_NOT_EXIST, new Object[]{cardInfo.getType(), cardInfo.getId(), userInTenant.getUserSid()});
        }
        loginUser.setTenant(tenant);
        loginUser.setUser(user);
        loginUser.setLoginSource(LoginSource.loginCardKey);
        return this.authoredUserService.generate(loginUser, true, false);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.cardKey;
    }
}

