/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntity;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Org;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInOrg;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.repository.OrgRepository;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInOrgCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.exception.IncorrectUsernameOrPasswordException;
import com.digiwin.dap.middleware.iam.support.remote.LdapService;
import com.digiwin.dap.middleware.iam.support.remote.digiwinadwsdl.domain.AdExecution;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Order(value=3)
@Service(value="digiwinIdentityService")
public class DigiwinIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    private static final Logger logger = LoggerFactory.getLogger(DigiwinIdentityServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private OrgRepository orgRepository;
    @Autowired
    private UserInOrgCrudService userInOrgCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;
    @Autowired
    private PasswordEncoder iamPasswordEncoder;
    @Autowired
    private LdapService ldapService;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @Transactional
    public IamAuthoredUser login(LoginUser loginUser) {
        boolean adLogin = true;
        try {
            if (Strings.isNotBlank((String)loginUser.getClientEncryptPublicKey())) {
                loginUser.setPassword(PwdUtils.getPassWord((String)loginUser.getPasswordHash(), (String)loginUser.getClientEncryptPublicKey(), (String)KeyConstant.BASE64_PRIVATE_KEY));
            }
            if (Strings.isBlank((String)loginUser.getPassword())) {
                adLogin = false;
            }
        }
        catch (Exception e) {
            adLogin = false;
            logger.error("AD\u767b\u5f55\u89e3\u5bc6\u5f02\u5e38");
        }
        if (adLogin) {
            Tenant tenant;
            String adCode;
            String userId = loginUser.getUserId();
            if (userId.contains("@")) {
                if (!userId.toLowerCase().endsWith("@digiwin.com")) throw new BusinessException((ErrorHandler)I18nError.ERROR_21011);
                adCode = loginUser.getUserId().split("@")[0];
            } else {
                adCode = userId;
            }
            AdExecution adUser = this.ldapService.checkAccount(adCode, loginUser.getPassword(), this.envProperties.getCountry());
            if (adUser.getInfo() == null) {
                throw new IncorrectUsernameOrPasswordException(I18nError.ERROR_21011);
            }
            loginUser.setUserId(adUser.getInfo().getMail());
            User user = loginUser.getUser();
            if (user == null) {
                user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), 0);
            }
            boolean checkAuth = true;
            if (user == null) {
                user = new User(adUser.getInfo());
                user.setPassword(this.iamPasswordEncoder.encode((CharSequence)loginUser.getPassword()));
                this.userCrudService.create((BaseEntity)user);
                tenant = (Tenant)this.tenantCrudService.findById("99990000");
            } else {
                tenant = this.getTenant(loginUser, user);
                checkAuth = false;
            }
            loginUser.setUser(user);
            if (tenant != null) {
                if (tenant.getConfirm() == 1) {
                    UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
                    if (userInTenant == null) {
                        this.userInTenantCrudService.create(new UserInTenant(user.getSid(), tenant.getSid()));
                    }
                    if (Strings.isNotBlank((String)adUser.getInfo().getDept())) {
                        List<Org> orgs = this.orgRepository.findByTenantSidAndId(tenant.getSid(), adUser.getInfo().getDept());
                        for (Org org : orgs) {
                            if (this.userInOrgCrudService.existsByUnionKey(new Object[]{user.getSid(), org.getSid()})) continue;
                            this.userInOrgCrudService.create(new UserInOrg(user.getSid(), org.getSid()));
                        }
                    }
                    loginUser.setTenant(tenant);
                } else {
                    logger.error(String.format("\u79df\u6237%s\u72b6\u6001\u4e3a%s\uff0c\u6ca1\u6709\u5ba1\u6838", tenant.getId(), tenant.getConfirm()));
                }
            }
            loginUser.setLoginSource(LoginSource.loginServiceDigiwin);
            IamAuthoredUser authoredUser = this.authoredUserService.generate(loginUser, checkAuth, true);
            authoredUser.setJobCode(adUser.getInfo().getjCode());
            authoredUser.setDept(adUser.getInfo().getDept());
            return authoredUser;
        }
        User user = loginUser.getUser();
        if (user == null) {
            user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), 0);
            if (user == null) {
                throw new IncorrectUsernameOrPasswordException(I18nError.PASSWORD_UPDATE_USER_NOT_EXIST);
            }
            loginUser.setUser(user);
        }
        if (!user.getPassword().equals(loginUser.getPasswordHash())) {
            throw new IncorrectUsernameOrPasswordException(I18nError.ERROR_21011);
        }
        Tenant tenant = this.getTenant(loginUser, user);
        if (tenant != null && tenant.getConfirm() == 1) {
            loginUser.setTenant(tenant);
        }
        loginUser.setIdentityType(IdentityType.token);
        loginUser.setLoginSource(LoginSource.loginServiceDigiwin);
        return this.authoredUserService.generate(loginUser, false, true);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.service && "digiwin".equals(loginUser.getServiceName());
    }
}

