/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import cn.hutool.extra.servlet.ServletUtil;
import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.util.HttpUtils;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.NetUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Order(value=7)
@Service(value="faceRecognitionKeyIdentityService")
public class FaceRecognitionIdentityServiceImpl
extends IdentityServiceBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FaceRecognitionIdentityServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private TenantCrudService tenantCrudService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        String[] content;
        String secretKey = loginUser.getSecretKey();
        if (StringUtils.isEmpty((Object)secretKey)) {
            ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            if (attributes != null) {
                HttpServletRequest request = attributes.getRequest();
                Map headerMap = ServletUtil.getHeaderMap((HttpServletRequest)request);
                String ip = ServletUtil.getClientIPByHeader((HttpServletRequest)request, (String[])NetUtils.HEADERS);
                String requestBody = "";
                try {
                    requestBody = JsonUtils.createObjectMapper().writeValueAsString(HttpUtils.getRequestBody((HttpServletRequest)request));
                }
                catch (JsonProcessingException e) {
                    LOGGER.error("requestBody\u8f6c\u5316\u5f02\u5e38");
                }
                LOGGER.error("secretKey is null\u3002\u5730\u5740 remoteAddr: [{}], ip: [{}], requestBody: {}, headerMap: {}", new Object[]{request.getRemoteAddr(), "0:0:0:0:0:0:0:1".equals(ip) ? "127.0.0.1" : ip, requestBody, headerMap});
            }
            throw new IllegalArgumentException("secretKey is null");
        }
        if (Strings.isNotBlank((String)loginUser.getClientEncryptPublicKey())) {
            try {
                secretKey = PwdUtils.getPassWord((String)secretKey, (String)loginUser.getClientEncryptPublicKey(), (String)KeyConstant.BASE64_PRIVATE_KEY);
            }
            catch (Exception ex) {
                LOGGER.error("\u89e3\u6790\u79d8\u94a5[{}]\u5931\u8d25\uff0c", (Object)secretKey, (Object)ex);
            }
        }
        if ((content = AES.decryptCBC((String)secretKey, (String)KeyConstant.OTHER).split("@#\\$%\\^_")).length > 3) {
            if (!content[0].equals(loginUser.getTenantId())) {
                throw new BusinessException((ErrorHandler)I18nError.ENTERPRISE_USERS_NOT_BELONG_TENANT, new Object[]{loginUser.getUserId(), content[0]});
            }
            Tenant tenant = (Tenant)this.tenantCrudService.findById(content[0]);
            if (tenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21013, (Object[])new String[]{content[0]});
            }
            Sys sys = this.commonCacheService.getSysById(content[1]);
            if (sys == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21014, (Object[])new String[]{content[1]});
            }
            AuthoredSys authoredSys = new AuthoredSys(sys.getSid(), sys.getId());
            authoredSys.setInside(sys.isInside());
            authoredSys.setPlatform(sys.isPlatform());
            AppAuthContextHolder.getContext().setAuthoredSys(authoredSys);
            User user = loginUser.getUser();
            if (user == null) {
                user = StringUtils.isEmpty((Object)loginUser.getUserId()) ? (User)this.userCrudService.findById("virtual") : this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), 0);
            }
            if (user == null) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{StringUtils.isEmpty((Object)loginUser.getUserId()) ? "virtual" : loginUser.getUserId()});
            }
            if (!this.userInTenantCrudService.existsByUnionKey(tenant.getSid(), user.getSid())) {
                throw new BusinessException((ErrorHandler)I18nError.USER_TENANT_EXISTED_ERROR, new Object[]{tenant.getId(), StringUtils.isEmpty((Object)loginUser.getUserId()) ? "virtual" : loginUser.getUserId()});
            }
            loginUser.setTenant(tenant);
            loginUser.setUser(user);
            loginUser.setApp(sys);
            loginUser.setLoginSource(LoginSource.loginFaceRecognition);
            return this.authoredUserService.generate(loginUser, true, false);
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_21012);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.faceRecognition;
    }
}

