/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.FiiService;
import java.util.Map;
import org.apache.logging.log4j.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Order(value=5)
@Service(value="fiiIdentityService")
public class FiiIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private FiiService fiiService;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        Assert.notNull((Object)loginUser, (String)"loginUser\u53c2\u6570\u4e3anull");
        if (Strings.isBlank((String)loginUser.getPasswordHash())) {
            throw new IllegalArgumentException("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isBlank((String)loginUser.getUserId())) {
            throw new IllegalArgumentException("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isBlank((String)loginUser.getClient_id())) {
            throw new IllegalArgumentException("FII API\u5bc6\u94a5ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String userId = "FII-" + loginUser.getUserId();
        User user = (User)this.userCrudService.findById(userId);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USERNAME_PASSWORD_ERROR);
        }
        if (!"FII".equalsIgnoreCase(user.getComeFrom())) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21015);
        }
        String fiiAccount = this.fiiService.getAccount(loginUser);
        if (StringUtils.hasText((String)fiiAccount) && fiiAccount.equals(userId)) {
            Tenant tenant = this.getTenant(loginUser, user);
            if (tenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.FII_TENANT_NOT_EXIST);
            }
            loginUser.setTenant(tenant);
            loginUser.setUser(user);
            loginUser.setLoginSource(LoginSource.loginServiceFii);
            return this.authoredUserService.generate(loginUser, false, false);
        }
        throw new BusinessException((ErrorHandler)I18nError.FII_LOGIN_FAILED);
    }

    public IamAuthoredUser getByCode(Map<String, Object> paras) {
        String access_token = this.fiiService.getAccessToken(paras);
        String userId = this.fiiService.getUserId(paras, access_token);
        User user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(userId, userId, userId, null);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST);
        }
        Tenant tenant = this.getTenant(new LoginUser(), user);
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.FII_TENANT_NOT_EXIST);
        }
        LoginUser loginUser = new LoginUser();
        loginUser.setTenant(tenant);
        loginUser.setUser(user);
        AuthoredSys authoredSys = AppAuthContextHolder.getContext().getAuthoredSys();
        if (authoredSys != null) {
            loginUser.setApp(new Sys(authoredSys));
        }
        loginUser.setLoginSource(LoginSource.loginServiceFii);
        return this.authoredUserService.generate(loginUser, false, false);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.service && "fii".equals(loginUser.getServiceName());
    }
}

