/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middleware.auth.domain.AuthResult;
import com.digiwin.dap.middleware.auth.domain.AuthType;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.entity.BaseEntityWithId;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.mapper.TenantMapper;
import com.digiwin.dap.middleware.iam.mapper.UserInTenantMapper;
import com.digiwin.dap.middleware.iam.service.login.AuthoredUserService;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.tenant.TenantCrudService;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.validate.LoginCheckService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public abstract class IdentityServiceBase
implements IdentityService {
    private Logger logger = LoggerFactory.getLogger(IdentityServiceBase.class);
    private static final String TENANT_DIGIWIN = "digiwin";
    @Autowired
    private TenantMapper tenantMapper;
    @Autowired
    private UserInTenantMapper userInTenantMapper;
    @Autowired
    protected TenantCrudService tenantCrudService;
    @Autowired
    protected CommonCacheService commonCacheService;
    @Autowired
    protected AuthoredUserService authoredUserService;
    @Autowired
    protected EnvProperties envProperties;
    @Autowired
    protected LoginCheckService loginCheckService;

    protected Tenant getTenant(LoginUser loginUser, User user) {
        Tenant tenant = this.findTenant(loginUser);
        return this.getTenant(user, tenant, loginUser.getApp(), Boolean.TRUE.equals(loginUser.getExcludeNonVisible()));
    }

    protected Tenant getTenant(User user, Tenant tenant, Sys sys, boolean excludeNonVisible) {
        String tenantId;
        AuthResult authResult = AuthResult.of();
        List<Object> tenants = new ArrayList();
        if (tenant != null) {
            if (0 == tenant.getConfirm()) {
                throw new BusinessException((ErrorHandler)I18nError.LOGIN_TENANT_NOT_CONFIRM, new Object[]{tenant.getId()});
            }
            UserInTenant userInTenant = this.userInTenantMapper.getUserInTenant(tenant.getSid(), user.getSid());
            if (userInTenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_TENANT, new Object[]{user.getId(), tenant.getName()});
            }
            if (userInTenant.isDisabled() || userInTenant.isDeleted()) {
                throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_DISABLE_TENANT, new Object[]{tenant.getId(), user.getId()});
            }
            if (excludeNonVisible && Boolean.FALSE.equals(userInTenant.isTenantVisible())) {
                throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_DISABLE_TENANT, new Object[]{tenant.getId(), user.getId()});
            }
            if (sys != null) {
                boolean exists = this.commonCacheService.existsBySysIdAndTenantId(sys.getId(), tenant.getId());
                if (!exists) {
                    authResult.setAuthType(AuthType.AppNone);
                }
            } else {
                authResult.setAuthType(AuthType.AppNone);
            }
        } else if ("integration".equals(user.getId())) {
            tenant = 0 == this.envProperties.getCloud() ? (Tenant)this.tenantCrudService.findById(TENANT_DIGIWIN) : this.tenantMapper.findDefaultTenant();
            authResult.setAuthType(AuthType.AppOk);
        } else if (sys != null) {
            tenants = this.tenantMapper.findTenantByUserSidAndSysSid(user.getSid(), sys.getSid(), excludeNonVisible);
            tenant = this.selectTenant(user.getDefaultTenantSid(), tenants);
            authResult.setTenants(tenants.stream().map(BaseEntityWithId::getId).collect(Collectors.toList()));
        } else {
            authResult.setAuthType(AuthType.AppNone);
            if (user.getDefaultTenantSid() > 0L) {
                tenant = this.tenantMapper.findTenantByUserSidAndTenantSid(user.getSid(), user.getDefaultTenantSid(), excludeNonVisible);
            }
            if (tenant == null) {
                tenants = this.tenantMapper.findTwoTenantByUserSid(user.getSid(), excludeNonVisible);
                tenant = this.selectTenant(0L, tenants);
            }
        }
        if (tenant != null && (tenantId = this.authoredUserService.checkCanUseApp(authResult, tenant.getId(), user.getId(), sys)) != null && !tenantId.equals(tenant.getId())) {
            tenant = tenants.stream().filter(t -> t.getId().equals(tenantId)).findFirst().orElse(null);
        }
        return tenant;
    }

    private Tenant findTenant(LoginUser loginUser) {
        if (loginUser.getTenantSid() > 0L) {
            return (Tenant)this.tenantCrudService.findBySid(loginUser.getTenantSid());
        }
        if (StringUtils.hasLength((String)loginUser.getTenantId())) {
            return (Tenant)this.tenantCrudService.findById(loginUser.getTenantId());
        }
        return null;
    }

    private Tenant selectTenant(Long defaultTenantSid, List<Tenant> tenants) {
        Tenant first;
        if (tenants.isEmpty()) {
            return null;
        }
        if (tenants.size() == 1) {
            return tenants.get(0);
        }
        if (defaultTenantSid > 0L) {
            Tenant tenant = tenants.stream().filter(t -> defaultTenantSid.longValue() == t.getSid()).findFirst().orElse(null);
            if (null != tenant) {
                return tenant;
            }
            this.logger.error("\u7528\u6237\u7684\u9ed8\u8ba4\u79df\u6237{}\u4e0d\u5b58\u5728", (Object)defaultTenantSid);
        }
        return "99990000".equals((first = tenants.get(0)).getId()) ? tenants.get(1) : first;
    }

    @Override
    public void logout(long tenantSid, long userSid, String appId) {
        this.authoredUserService.clear(tenantSid, userSid, appId);
    }
}

