/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.DigestUtils;
import com.digiwin.dap.middleware.commons.crypto.PwdUtils;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.constant.enums.CloudTypeEnum;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.exception.IncorrectUsernameOrPasswordException;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Primary;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Order(value=1)
@Service(value="defaultIdentityService")
@Primary
public class IdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    private static final Logger log = LoggerFactory.getLogger(IdentityServiceImpl.class);
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private PasswordEncoder iamPasswordEncoder;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        User user = loginUser.getUser();
        if (user == null) {
            user = this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), 0);
            if (user == null) {
                if (CloudTypeEnum.isCloud(this.envProperties.getCloud()) && !DeployAreaEnum.isAzure((String)this.envProperties.getDeployArea())) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_LOGIN_21001_1, new Object[]{loginUser.getUserId()});
                }
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GROUND_LOGIN_21001);
            }
            loginUser.setUser(user);
        }
        if (user.isDeleted() || user.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21004);
        }
        if (!user.isActivated()) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_ACTIVE);
        }
        if (Strings.isBlank((String)loginUser.getPassword()) && Strings.isBlank((String)loginUser.getPasswordHash()) && Strings.isBlank((String)loginUser.getPasswordHash1())) {
            throw new BadCredentialsException("\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (Strings.isNotBlank((String)loginUser.getPasswordHash()) && Strings.isNotBlank((String)loginUser.getClientEncryptPublicKey())) {
            loginUser.setPassword(PwdUtils.getPassWord((String)loginUser.getPasswordHash(), (String)loginUser.getClientEncryptPublicKey(), (String)KeyConstant.BASE64_PRIVATE_KEY));
            loginUser.setPasswordHash(this.iamPasswordEncoder.encode((CharSequence)loginUser.getPassword()));
        }
        if (!StringUtils.isEmpty((Object)loginUser.getPassword())) {
            if (Strings.isBlank((String)loginUser.getPasswordHash())) {
                loginUser.setPasswordHash(this.iamPasswordEncoder.encode((CharSequence)loginUser.getPassword()));
            }
            if (Strings.isBlank((String)loginUser.getPasswordHash1())) {
                if (user.getSalt() != null) {
                    loginUser.setPassword(loginUser.getPassword() + user.getSalt());
                }
                loginUser.setPasswordHash1(DigestUtils.md5Hex((String)loginUser.getPassword()));
            }
        }
        if (!user.getPassword().equals(loginUser.getPasswordHash()) && !user.getPassword().equals(loginUser.getPasswordHash1())) {
            log.error(String.format("\u7528\u6237[%s]\u7684PasswordHash[%s],PasswordHash1[%s]\u4e0e\u6570\u636e\u5e93\u4e2d\u7684password[%s]\u4e0d\u5339\u914d\uff01", loginUser.getUserId(), loginUser.getPasswordHash(), loginUser.getPasswordHash1(), user.getPassword()));
            throw new IncorrectUsernameOrPasswordException(I18nError.LOGIN_USERNAME_PASSWORD_ERROR);
        }
        Tenant tenant = this.getTenant(loginUser, user);
        loginUser.setTenant(tenant);
        this.loginCheckService.checkIP(loginUser.getIdentityType(), tenant, loginUser.getApp());
        loginUser.setLoginSource(LoginSource.get(loginUser.getIdentityType()));
        return this.authoredUserService.generate(loginUser, false, true);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return IdentityType.general(loginUser.getIdentityType());
    }
}

