/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middle.kms.constants.KeyConstant;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserInTenant;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.service.user.UserInTenantCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.exception.IncorrectUsernameOrPasswordException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Order(value=0x7FFFFFFF)
@Service(value="internalIdentityService")
public class InternalIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private UserInTenantCrudService userInTenantCrudService;

    @Override
    @Transactional
    public IamAuthoredUser login(LoginUser loginUser) {
        Tenant tenant;
        if (!"integration".equals(loginUser.getUserId())) {
            throw new BusinessException((ErrorHandler)I18nError.ONLY_INTEGRATION_LOGIN);
        }
        if (!"integration".equals(AES.decryptHex((String)loginUser.getPasswordHash(), (String)KeyConstant.LOGIN))) {
            throw new IncorrectUsernameOrPasswordException(I18nError.LOGIN_USERNAME_PASSWORD_ERROR);
        }
        if (ObjectUtils.isEmpty((Object)loginUser.getTenantId())) {
            loginUser.setTenantId("digiwin");
        }
        Object[] targetTenant = new Object[1];
        if (loginUser.getTenantSid() > 0L) {
            targetTenant[0] = loginUser.getTenantSid();
            tenant = (Tenant)this.tenantCrudService.findBySid(loginUser.getTenantSid());
        } else {
            targetTenant[0] = loginUser.getTenantId();
            tenant = (Tenant)this.tenantCrudService.findById(loginUser.getTenantId());
        }
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21005, targetTenant);
        }
        User user = (User)this.userCrudService.findById(loginUser.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{loginUser.getUserId()});
        }
        UserInTenant userInTenant = this.userInTenantCrudService.findByUnionKey(tenant.getSid(), user.getSid());
        if (userInTenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_NOT_TENANT, new Object[]{user.getId(), tenant.getId()});
        }
        loginUser.setTenant(tenant);
        loginUser.setUser(user);
        loginUser.setLoginSource(LoginSource.loginInternal);
        return this.authoredUserService.generate(loginUser, false, false);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.internal;
    }
}

