/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.DeployAreaEnum;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.ImageCode;
import com.digiwin.dap.middleware.iam.domain.login.LoginFailureInfo;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.service.WhiteListService;
import com.digiwin.dap.middleware.iam.service.login.LoginFailureHandlingService;
import com.digiwin.dap.middleware.iam.service.tenantmetadata.TenantMetadataCrudService;
import com.digiwin.dap.middleware.util.UserUtils;
import java.time.Duration;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class LoginFailureHandlingServiceImpl
implements LoginFailureHandlingService {
    private static final Logger logger = LoggerFactory.getLogger(LoginFailureHandlingServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private TenantMetadataCrudService tenantMetadataCrudService;
    @Autowired
    private WhiteListService whiteListService;

    @Override
    public void frozen(String userId, Integer type, String message) {
        if ("integration".equalsIgnoreCase(userId)) {
            if (DeployAreaEnum.isAzure((String)this.envProperties.getDeployArea())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_GROUND_LOGIN_21001);
            }
            throw new BusinessException((ErrorHandler)I18nError.ERROR_LOGIN_21001_1);
        }
        String key = "iam:failure:login:" + userId.toLowerCase();
        Duration duration = Duration.ofSeconds(300L);
        LoginFailureInfo loginFailureInfo = (LoginFailureInfo)RedisUtils.get((Object)key, LoginFailureInfo.class);
        if (loginFailureInfo == null) {
            loginFailureInfo = new LoginFailureInfo();
            loginFailureInfo.setCount(1);
            RedisUtils.set((String)key, (Object)loginFailureInfo, (Duration)duration);
        } else {
            int count = loginFailureInfo.getCount();
            loginFailureInfo.setCount(count + 1);
            if (loginFailureInfo.getCount() >= 10) {
                loginFailureInfo.setFrozen(true);
                loginFailureInfo.setFrozenTime(LocalDateTime.now());
                RedisUtils.set((String)key, (Object)loginFailureInfo, (Duration)duration);
                logger.error("\u7528\u6237[{}]\u5df2\u7ecf\u88ab\u51bb\u7ed3\uff0c\u8bf7{}\u5206\u949f\u540e\u91cd\u65b0\u767b\u5f55", (Object)userId, (Object)5);
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21003, (Object[])new Integer[]{5});
            }
            RedisUtils.set((String)key, (Object)loginFailureInfo, (Duration)Duration.ofSeconds(RedisUtils.getExpire((String)key)));
        }
        logger.error("\u7528\u6237[{}]\u8d26\u6237\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u60a8\u8fd8\u80fd\u5c1d\u8bd5{}\u6b21", (Object)userId, (Object)(10 - loginFailureInfo.getCount()));
        if (0 == type) {
            if ("cn".equalsIgnoreCase(this.envProperties.getCountry())) {
                throw new BusinessException((ErrorHandler)I18nError.ERROR_21002_1, (Object[])new Integer[]{10 - loginFailureInfo.getCount()});
            }
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21017, (Object[])new Integer[]{10 - loginFailureInfo.getCount()});
        }
        throw new BusinessException((ErrorHandler)I18nError.ERROR_21017, (Object[])new Integer[]{10 - loginFailureInfo.getCount()});
    }

    @Override
    public void checkFrozen(String userId, String code, String value) {
        String key = "iam:failure:login:" + userId.toLowerCase();
        LoginFailureInfo loginFailureInfo = (LoginFailureInfo)RedisUtils.get((Object)key, LoginFailureInfo.class);
        if (loginFailureInfo != null) {
            if (loginFailureInfo.isFrozen()) {
                Duration duration = Duration.between(loginFailureInfo.getFrozenTime(), LocalDateTime.now());
                long durationMinutes = duration.toMinutes();
                if (durationMinutes < 5L) {
                    logger.error("\u7528\u6237[{}]\u5df2\u7ecf\u88ab\u51bb\u7ed3\uff0c\u8bf7{}\u5206\u949f\u540e\u91cd\u65b0\u767b\u5f55", (Object)userId, (Object)(5L - durationMinutes));
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21003, (Object[])new Long[]{5L - durationMinutes});
                }
            } else if (this.whiteListService.getWhiteList("LOGIN_IMAGE_CHECK_APP").contains(UserUtils.getSysId()) && loginFailureInfo.getCount() >= 5) {
                if (ObjectUtils.isEmpty((Object)code) || ObjectUtils.isEmpty((Object)value)) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21032);
                }
                String redisKey = String.format("iam:failure:login:app:user:image:%s:%s:%s", UserUtils.getSysId(), userId, code).toLowerCase();
                ImageCode imageCode = (ImageCode)RedisUtils.get((Object)redisKey, ImageCode.class);
                if (null == imageCode) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21033);
                }
                if (!value.equalsIgnoreCase(imageCode.getCode())) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21034);
                }
            }
        }
    }

    @Override
    public void unfreeze(String userId) {
        RedisUtils.delete((String)("iam:failure:login:" + userId.toLowerCase()));
    }

    @Override
    public void freezeInner(String userId, Tenant tenant) {
        String key = "iam:failure:login:" + userId.toLowerCase();
        int attempts = this.getAttempts(tenant);
        LoginFailureInfo loginFailureInfo = (LoginFailureInfo)RedisUtils.get((Object)key, LoginFailureInfo.class);
        if (loginFailureInfo == null) {
            loginFailureInfo = new LoginFailureInfo();
            loginFailureInfo.setCount(1);
            RedisUtils.set((String)key, (Object)loginFailureInfo);
        } else {
            int count = loginFailureInfo.getCount();
            loginFailureInfo.setCount(count + 1);
            if (loginFailureInfo.getCount() >= attempts) {
                loginFailureInfo.setFrozen(true);
                loginFailureInfo.setFrozenTime(LocalDateTime.now());
                RedisUtils.set((String)key, (Object)loginFailureInfo);
                logger.error("\u4f01\u4e1a\u7528\u6237[{}]\u5df2\u7ecf\u88ab\u51bb\u7ed3", (Object)userId);
                throw new BusinessException((ErrorHandler)I18nError.ERROR_FROZEN);
            }
            RedisUtils.set((String)key, (Object)loginFailureInfo);
        }
        logger.error("\u7528\u6237[{}]\u8d26\u6237\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u60a8\u8fd8\u80fd\u5c1d\u8bd5{}\u6b21", (Object)userId, (Object)(attempts - loginFailureInfo.getCount()));
        throw new BusinessException((ErrorHandler)I18nError.ERROR_21017, (Object[])new Integer[]{attempts - loginFailureInfo.getCount()});
    }

    private int getAttempts(Tenant tenant) {
        int resultAttempts = 10;
        String attempts = this.tenantMetadataCrudService.getTenantMetadataValue(tenant.getSid(), "basic", "passwordAttempts");
        if (StringUtils.hasLength((String)attempts)) {
            try {
                resultAttempts = Integer.parseInt(attempts);
            }
            catch (Exception e) {
                logger.error("parse password attempts error", (Throwable)e);
            }
        }
        return resultAttempts;
    }

    @Override
    public void checkFrozenInner(String userId, String code, String value) {
        String key = "iam:failure:login:" + userId.toLowerCase();
        LoginFailureInfo loginFailureInfo = (LoginFailureInfo)RedisUtils.get((Object)key, LoginFailureInfo.class);
        if (loginFailureInfo != null) {
            if (loginFailureInfo.isFrozen()) {
                logger.error("\u4f01\u4e1a\u7528\u6237[{}]\u5df2\u7ecf\u88ab\u51bb\u7ed3", (Object)userId);
                throw new BusinessException((ErrorHandler)I18nError.ERROR_FROZEN);
            }
            if (this.whiteListService.getWhiteList("LOGIN_IMAGE_CHECK_APP").contains(UserUtils.getSysId()) && loginFailureInfo.getCount() >= 5) {
                if (ObjectUtils.isEmpty((Object)code) || ObjectUtils.isEmpty((Object)value)) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21032);
                }
                String redisKey = String.format("iam:failure:login:app:user:image:%s:%s:%s", UserUtils.getSysId(), userId, code).toLowerCase();
                ImageCode imageCode = (ImageCode)RedisUtils.get((Object)redisKey, ImageCode.class);
                if (null == imageCode) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21033);
                }
                if (!value.equalsIgnoreCase(imageCode.getCode())) {
                    throw new BusinessException((ErrorHandler)I18nError.ERROR_21034);
                }
            }
        }
    }
}

