/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middleware.auth.AppAuthContextHolder;
import com.digiwin.dap.middleware.auth.AuthoredSys;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.domain.login.OauthLoginRequest;
import com.digiwin.dap.middleware.iam.domain.token.GrantTypeInfo;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.entity.UserMapping;
import com.digiwin.dap.middleware.iam.mapper.UserMappingMapper;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import com.digiwin.dap.middleware.iam.support.remote.oauth.RemoteOauthService;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Order(value=8)
@Service(value="oauthIdentityService")
public class OauthIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    private static final Logger logger = LoggerFactory.getLogger(OauthIdentityServiceImpl.class);
    @Autowired
    private UserMappingMapper userMappingMapper;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private CommonCacheService commonCacheService;
    @Autowired
    private List<RemoteOauthService> remoteOauthServices;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        logger.info("\u7b2c\u4e09\u65b9\u9a8c\u8bc1\u767b\u5f55Oauth:{}", (Object)JsonUtils.writeValue((Object)loginUser.getOauthLoginRequest()));
        OauthLoginRequest oauthLoginRequest = loginUser.getOauthLoginRequest();
        if (oauthLoginRequest.getVerified().booleanValue()) {
            OauthLoginRequest checkedResult = new OauthLoginRequest();
            for (RemoteOauthService service : this.remoteOauthServices) {
                if (!service.support(oauthLoginRequest.getType())) continue;
                checkedResult = service.getUserInfo(oauthLoginRequest.getCallBackUri(), oauthLoginRequest.getMethod(), oauthLoginRequest.getAccessToken(), oauthLoginRequest.getData());
            }
            if (!(StringUtils.isEmpty((Object)oauthLoginRequest.getUnionid()) || StringUtils.isEmpty((Object)checkedResult.getUnionid()) || oauthLoginRequest.getUnionid().equals(checkedResult.getUnionid()))) {
                throw new BusinessException((ErrorHandler)I18nError.THIRD_USER_ERROR, new Object[]{checkedResult.getUnionid(), oauthLoginRequest.getUnionid()});
            }
        }
        GrantTypeInfo grantTypeInfo = new GrantTypeInfo(oauthLoginRequest);
        Tenant tenant = null;
        if (grantTypeInfo.getTenantSid() == null || grantTypeInfo.getTenantSid() == 0L) {
            if (!StringUtils.isEmpty((Object)grantTypeInfo.getTenantId()) && (tenant = (Tenant)this.tenantCrudService.findById(grantTypeInfo.getTenantId())) == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{grantTypeInfo.getTenantId()});
            }
        } else {
            tenant = (Tenant)this.tenantCrudService.findBySid(grantTypeInfo.getTenantSid());
            if (tenant == null) {
                throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{grantTypeInfo.getTenantSid()});
            }
        }
        return this.getByGrantTypeInfoCore(loginUser, grantTypeInfo, tenant);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IamAuthoredUser getByGrantTypeInfoCore(LoginUser loginUser, GrantTypeInfo grantTypeInfo, Tenant tenant) {
        User user;
        UserMapping userMapping;
        Assert.hasText((String)grantTypeInfo.getVerifyUserId(), (String)"grantTypeInfo.verifyUserId\u4e0d\u80fd\u4e3a\u7a7a");
        AuthoredSys authoredSys = AppAuthContextHolder.getContext().getAuthoredSys();
        String sysId = "";
        if (!StringUtils.isEmpty((Object)grantTypeInfo.getAppId())) {
            sysId = grantTypeInfo.getAppId();
        } else if (authoredSys != null) {
            sysId = authoredSys.getId();
        }
        Assert.hasText((String)sysId, (String)"grantTypeInfo.appId\u4e0d\u80fd\u4e3a\u7a7a");
        Long tenantSid = tenant == null ? 0L : tenant.getSid();
        List<UserMapping> userMappingVOList = this.userMappingMapper.queryByTenantAndVerifyUserId(tenantSid, grantTypeInfo.getVerifyUserId(), sysId, grantTypeInfo.getAccount());
        if (userMappingVOList == null || userMappingVOList.size() == 0) {
            throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_MAPPING_ERROR, new Object[]{grantTypeInfo.getTenantId(), sysId, grantTypeInfo.getVerifyUserId()});
        }
        if (userMappingVOList.size() > 1) {
            List currentTenantMappingList = userMappingVOList.stream().filter(u -> tenantSid.longValue() == u.getTenantSid()).collect(Collectors.toList());
            if (tenantSid <= 0L) throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_GRANT_MAPPING_ERROR, new Object[]{grantTypeInfo.getVerifyUserId()});
            if (currentTenantMappingList.size() > 1) {
                throw new BusinessException((ErrorHandler)I18nError.ACCESS_TOKEN_GRANT_MAPPING_ERROR, new Object[]{grantTypeInfo.getVerifyUserId()});
            }
            userMapping = (UserMapping)((Object)currentTenantMappingList.get(0));
        } else {
            userMapping = userMappingVOList.get(0);
        }
        if ((user = (User)this.userCrudService.findBySid(userMapping.getUserSid())) == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21001, new Object[]{userMappingVOList.get(0).getUserSid()});
        }
        if (user.isDeleted() || user.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21004);
        }
        Sys sys = this.commonCacheService.getSysById(sysId);
        if (sys == null) {
            sys = new Sys();
            sys.setId(sysId);
        }
        tenant = this.getTenant(user, tenant, sys, false);
        loginUser.setTenant(tenant);
        loginUser.setUser(user);
        loginUser.setApp(sys);
        return this.authoredUserService.generate(loginUser, false, false);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.oauth;
    }
}

