/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.cache.UserTempTokenCacheVO;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Sys;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.cache.CommonCacheService;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Order(value=10)
@Service(value="tempUserTokenService")
public class TempUserTokenServiceImpl
extends IdentityServiceBase
implements IdentityService {
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private CommonCacheService commonCacheService;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        String tempTokenKey = String.format("iam:temp:token:%s", loginUser.getTempUserToken());
        UserTempTokenCacheVO cacheVO = (UserTempTokenCacheVO)RedisUtils.get((Object)tempTokenKey, UserTempTokenCacheVO.class);
        String value = String.join((CharSequence)"_", loginUser.getUserId(), loginUser.getTenantId(), loginUser.getSysId());
        if (Objects.isNull(cacheVO) || !Objects.equals(value, cacheVO.getValue())) {
            throw new BusinessException((ErrorHandler)I18nError.TEMP_TOKEN_INVALID, new Object[]{loginUser.getTempUserToken()});
        }
        Long createTime = cacheVO.getCreateTime();
        if (!Objects.isNull(createTime) && System.currentTimeMillis() - createTime > this.envProperties.getTempTokenExpire() * 60L * 1000L) {
            throw new BusinessException((ErrorHandler)I18nError.TEMP_TOKEN_INVALID, new Object[]{loginUser.getTempUserToken()});
        }
        Tenant tenant = (Tenant)this.tenantCrudService.findById(loginUser.getTenantId());
        if (tenant == null) {
            throw new BusinessException((ErrorHandler)I18nError.TENANT_NOT_EXISTED, new Object[]{loginUser.getTenantId()});
        }
        String sysId = loginUser.getSysId();
        User user = (User)this.userCrudService.findById(loginUser.getUserId());
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_LOGIN_21001_1, new Object[]{loginUser.getUserId()});
        }
        if (user.isDeleted() || user.isDisabled()) {
            throw new BusinessException((ErrorHandler)I18nError.ERROR_21004);
        }
        Sys sys = this.commonCacheService.getSysById(sysId);
        if (sys == null) {
            sys = new Sys();
            sys.setId(sysId);
        }
        tenant = this.getTenant(user, tenant, sys, false);
        loginUser.setTenant(tenant);
        loginUser.setUser(user);
        loginUser.setApp(sys);
        return this.authoredUserService.generate(loginUser, false, false);
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.tempUserToken;
    }
}

