/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.login.impl;

import com.digiwin.dap.middleware.cache.RedisUtils;
import com.digiwin.dap.middleware.domain.ErrorHandler;
import com.digiwin.dap.middleware.exception.BusinessException;
import com.digiwin.dap.middleware.iam.constant.I18nError;
import com.digiwin.dap.middleware.iam.domain.EnvProperties;
import com.digiwin.dap.middleware.iam.domain.login.IdentityType;
import com.digiwin.dap.middleware.iam.domain.login.LoginSource;
import com.digiwin.dap.middleware.iam.domain.login.LoginUser;
import com.digiwin.dap.middleware.iam.entity.Tenant;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.service.login.IdentityService;
import com.digiwin.dap.middleware.iam.service.login.impl.IdentityServiceBase;
import com.digiwin.dap.middleware.iam.service.user.UserCrudService;
import com.digiwin.dap.middleware.iam.support.auth.domain.IamAuthoredUser;
import com.digiwin.dap.middleware.iam.support.remote.RemoteEMCService;
import com.digiwin.dap.middleware.iam.util.StringUtil;
import java.time.Duration;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Order(value=7)
@Service(value="verificationCodeIdentityService")
public class VerificationCodeIdentityServiceImpl
extends IdentityServiceBase
implements IdentityService {
    private static final Logger logger = LoggerFactory.getLogger(VerificationCodeIdentityServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private UserCrudService userCrudService;
    @Autowired
    private RemoteEMCService remoteEMCService;

    @Override
    public IamAuthoredUser login(LoginUser loginUser) {
        String verificationUserTokenKey;
        IamAuthoredUser verificationUser;
        String verificationCode = loginUser.getVerificationCode();
        Assert.notNull((Object)verificationCode, (String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        logger.info("verificationCode:{}", (Object)verificationCode);
        User user = !StringUtils.isEmpty((Object)loginUser.getUserToken()) ? (User)this.userCrudService.findById(loginUser.getUserId()) : this.userCrudService.queryUserByIdOrEmailOrTelephoneAndType(loginUser.getUserId(), loginUser.getUserId(), loginUser.getUserId(), 0);
        if (user == null) {
            throw new BusinessException((ErrorHandler)I18nError.USER_NOT_EXIST, new Object[]{loginUser.getUserId()});
        }
        loginUser.setUser(user);
        Tenant tenant = this.getTenant(loginUser, user);
        loginUser.setTenant(tenant);
        this.checkUserAccount(loginUser);
        if (!this.checkVerificationCode(loginUser).booleanValue()) {
            throw new BusinessException((ErrorHandler)I18nError.LOGIN_USER_VERIFICATION_CODE_ERROR);
        }
        if (!StringUtils.isEmpty((Object)loginUser.getUserToken()) && (verificationUser = (IamAuthoredUser)RedisUtils.get((Object)(verificationUserTokenKey = LoginUser.verificationTokenKey(loginUser.getUserToken())), IamAuthoredUser.class)) != null) {
            String tokenKey = LoginUser.tokenKey(loginUser.getUserToken());
            verificationUser.setNeedVerificationCode(false);
            String verificationSuccessKey = LoginUser.verificationSuccessKey(verificationUser.getUserId(), verificationUser.getDeviceType());
            RedisUtils.set((String)verificationSuccessKey, (Object)true, (Duration)Duration.ofDays(this.envProperties.getDoubleCheckExpire().intValue()));
            RedisUtils.delete((String)verificationUserTokenKey);
            this.authoredUserService.resetAuthoredUser(verificationUser);
            this.authoredUserService.resetUserMetadata(verificationUser);
            RedisUtils.set((String)tokenKey, (Object)verificationUser, (Duration)Duration.ofMinutes(this.envProperties.getTokenExpire()));
            verificationUser.fixData(this.envProperties.getDeployArea());
            return verificationUser;
        }
        loginUser.setLoginSource(LoginSource.loginVerificationCode);
        return this.authoredUserService.generate(loginUser, false, false);
    }

    public Boolean checkVerificationCode(String verificationCode, String account, String type) {
        if (this.remoteEMCService.checkVerificationCode(account, "verificationCodelogin", verificationCode, type)) {
            logger.info("\u9a8c\u8bc1\u7801\u6821\u9a8c\u6210\u529f");
            return true;
        }
        logger.info("\u9a8c\u8bc1\u7801\u6821\u9a8c\u5931\u8d25");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkUserAccount(LoginUser loginUser) {
        User user = loginUser.getUser();
        if (Boolean.TRUE.equals(loginUser.doubleCheckEnabledByTenantAndUser())) {
            String type = loginUser.decideIdentityCodeAcceptType();
            if ("mobile".equals(type)) {
                if (!ObjectUtils.isEmpty((Object)user.getTelephone())) return;
                throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EMPTY);
            }
            if (!"email".equals(type)) throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EMPTY);
            if (!ObjectUtils.isEmpty((Object)user.getEmail())) return;
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EMPTY);
        }
        if (StringUtil.checkEmail(loginUser.getUserId())) {
            if (!ObjectUtils.isEmpty((Object)user.getEmail())) return;
            throw new BusinessException((ErrorHandler)I18nError.USER_EMAIL_EMPTY);
        }
        if (!ObjectUtils.isEmpty((Object)user.getTelephone())) return;
        throw new BusinessException((ErrorHandler)I18nError.USER_TELEPHONE_EMPTY);
    }

    public Boolean checkVerificationCode(LoginUser loginUser) {
        if (Boolean.TRUE.equals(loginUser.doubleCheckEnabledByTenantAndUser())) {
            if ("mobile".equals(loginUser.decideIdentityCodeAcceptType())) {
                return this.checkVerificationCode(loginUser.getVerificationCode(), loginUser.getUser().getTelephone(), "sms");
            }
            return this.checkVerificationCode(loginUser.getVerificationCode(), loginUser.getUser().getEmail(), "email");
        }
        if (Locale.SIMPLIFIED_CHINESE.getCountry().equals(this.envProperties.getCountry().toUpperCase())) {
            return this.checkVerificationCode(loginUser.getVerificationCode(), loginUser.getUser().getTelephone(), "sms");
        }
        if (StringUtil.checkEmail(loginUser.getUserId())) {
            return this.checkVerificationCode(loginUser.getVerificationCode(), loginUser.getUser().getEmail(), "email");
        }
        return this.checkVerificationCode(loginUser.getVerificationCode(), loginUser.getUser().getTelephone(), "sms");
    }

    @Override
    public boolean support(LoginUser loginUser) {
        return loginUser.getIdentityType() == IdentityType.verificationCode;
    }
}

