/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.loginhistory.impl;

import com.digiwin.dap.middleware.iam.domain.loginhistory.LoginHistoryVO;
import com.digiwin.dap.middleware.iam.entity.LoginHistory;
import com.digiwin.dap.middleware.iam.entity.User;
import com.digiwin.dap.middleware.iam.mapper.LoginHistoryMapper;
import com.digiwin.dap.middleware.iam.mapper.UserMapper;
import com.digiwin.dap.middleware.iam.repository.TenantRepository;
import com.digiwin.dap.middleware.iam.repository.UserRepository;
import com.digiwin.dap.middleware.iam.service.loginhistory.LoginHistoryCrudService;
import com.digiwin.dap.middleware.iam.service.loginhistory.LoginHistoryService;
import com.github.pagehelper.PageSerializable;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoginHistoryServiceImpl
implements LoginHistoryService {
    @Autowired
    private LoginHistoryCrudService loginHistoryCrudService;
    @Autowired
    private LoginHistoryMapper loginHistoryMapper;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private TenantRepository tenantRepository;
    @Autowired
    private UserMapper userMapper;

    @Override
    public void addLoginHistory(String tenantId, String userId, String type, String appId) {
        HashMap<String, Long> loginUserHistory = new HashMap<String, Long>();
        if (tenantId == null) {
            tenantId = "";
        }
        if (userId == null) {
            userId = "";
        }
        if (appId == null) {
            appId = "";
        }
        if (type == null) {
            type = "";
        }
        long currentTime = System.currentTimeMillis();
        String key = String.format("%s@%s@%s@%s", tenantId, userId, appId, type);
        if (loginUserHistory.containsKey(key) && (Long)loginUserHistory.get(key) >= currentTime) {
            return;
        }
        loginUserHistory.put(key, 60000L + currentTime);
        LoginHistory loginHistory = new LoginHistory();
        loginHistory.setUserId(userId);
        loginHistory.setTenantId(tenantId);
        loginHistory.setAppId(appId);
        loginHistory.setStatus(type);
        loginHistory.setHistoryTime(LocalDateTime.now());
        this.loginHistoryCrudService.create(loginHistory);
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW, rollbackFor={Exception.class})
    public void addLoginHistory(long tenantSid, long userSid, String type, String appId) {
        User user = this.userMapper.findBySid(userSid);
        String userId = Objects.nonNull((Object)user) ? user.getId() : null;
        String tenantId = this.tenantRepository.findIdBySid(tenantSid);
        this.addLoginHistory(tenantId, userId, type, appId);
    }

    @Override
    public PageSerializable findByCondition(LoginHistoryVO condition, int pageNum, int pageSize, String orderBy) {
        List<LoginHistoryVO> list = this.loginHistoryMapper.findByCondition(condition, pageNum, pageSize, orderBy);
        return new PageSerializable(list);
    }
}

