/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.iam.service.metadata.impl;

import com.digiwin.dap.middleware.entity.UnionKey;
import com.digiwin.dap.middleware.iam.domain.metadata.MetadataColumnVO;
import com.digiwin.dap.middleware.iam.entity.MetadataColumn;
import com.digiwin.dap.middleware.iam.repository.MetadataColumnRepository;
import com.digiwin.dap.middleware.iam.service.metadata.MetadataColumnCrudService;
import com.digiwin.dap.middleware.repository.BaseEntityRepository;
import com.digiwin.dap.middleware.service.impl.BaseEntityWithUnionKeyManagerService;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MetadataColumnCrudServiceImpl
extends BaseEntityWithUnionKeyManagerService<MetadataColumn>
implements MetadataColumnCrudService {
    @Autowired
    private MetadataColumnRepository metadataColumnRepository;

    protected UnionKey createUnionKey() {
        return UnionKey.create().apply(MetadataColumn.class).add("catalogId").add("key");
    }

    protected BaseEntityRepository getRepository() {
        return this.metadataColumnRepository;
    }

    @Override
    public List<MetadataColumnVO> getAllMetadataColumn() {
        List metadataColumnList = this.metadataColumnRepository.findAll();
        ArrayList<MetadataColumnVO> metadataColumnVOList = new ArrayList<MetadataColumnVO>();
        for (MetadataColumn metadataColumn : metadataColumnList) {
            MetadataColumnVO metadataColumnVO = new MetadataColumnVO();
            metadataColumnVO.convertMetadataColumnToMetadataColumnVO(metadataColumn);
            metadataColumnVOList.add(metadataColumnVO);
        }
        return metadataColumnVOList;
    }

    @Override
    public List<MetadataColumnVO> getMetadataColumnByCatalogId(String catalogId) {
        List<MetadataColumn> metadataColumnList = this.metadataColumnRepository.findByCatalogId(catalogId);
        ArrayList<MetadataColumnVO> metadataColumnVOList = new ArrayList<MetadataColumnVO>();
        for (MetadataColumn metadataColumn : metadataColumnList) {
            MetadataColumnVO metadataColumnVO = new MetadataColumnVO();
            metadataColumnVO.convertMetadataColumnToMetadataColumnVO(metadataColumn);
            metadataColumnVOList.add(metadataColumnVO);
        }
        return metadataColumnVOList;
    }

    @Override
    public MetadataColumn getByCatalogIdAndKey(String catalogId, String key) {
        return this.metadataColumnRepository.findByCatalogIdAndKey(catalogId, key);
    }
}

